/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module	      : EDDJFM.H				      */
/*								      */
/*   Description      : PM Display Driver DBCS handling routine       */
/*			Definitions for DBCS Font Manager	      */
/*			(Imported from PMNLSFM.INC)		      */
/*								      */
/*   Created	      : 12/04/91				      */
/*   Author	      : Yohji Nakamura (JL04328 at YMTVM6)	      */
/*								      */
/*   Notes	      : 					      */
/*								      */
/*   History	      : 					      */
/*								      */
/*			OCO Source Materials			      */
/*			XXXX-XXX				      */
/**********************************************************************/
#include <pmnlsfm.h>		       /*			      */

#define L_GLYPHLIST_NAME 16	       /*			      */

#ifdef OMIT
/*--------------------------------------------------------------------*/
/* Now all of these definitions are included in PMNLSFM.H	      */
/*--------------------------------------------------------------------*/
typedef ULONG	HFM;		       /* font manager font handle    */

typedef struct			       /*			      */
{				       /*			      */
  HFM	hfm;			       /* font handle		      */
  ULONG pFont;			       /* segmented ptr to font seg   */
				       /* (cannot use as a ptr!)      */
  ULONG ulLen;			       /* length of font segment      */
  BOOL32 flType;		       /* type flag		      */
  CHAR szGlyphList[L_GLYPHLIST_NAME];  /* name of glyph list	      */
  LONG lMatch;			       /* match number		      */
  USHORT usCache;		       /* cache size		      */
} FMFONTINFO;			       /*			      */
				       /*			      */
typedef FMFONTINFO *PFMFONTINFO;       /*			      */

				       /* for flType... 	      */
#define DDFM_PM_FONT	1	       /*   SBCS glyph is resident    */
#define DDFM_CACHE_FONT 2	       /*   SBCS is also cached       */
				       /*			      */
typedef struct			       /*			      */
{				       /*			      */
  BOOL32 flQuery;		       /* query type		      */
  LONG sizl_cx; 		       /* cell width		      */
  LONG sizl_cy; 		       /* cell height		      */
  LONG a_space; 		       /* A space		      */
  LONG b_space; 		       /* B space		      */
  LONG c_space; 		       /* C space		      */
  ULONG ulLen;			       /* font image buffer length    */
  ULONG pBuffer;		       /* segmented ptr to image buff */
				       /* (Cannot use as a pointer!)  */
} FMQUERYDATA;			       /*			      */
				       /*			      */
typedef FMQUERYDATA *PFMQUERYDATA;     /*			      */

				       /* for flQuery...	      */
#define DDFM_FONT_SIZE	1	       /*			      */
#define DDFM_FONT_IMAGE 2	       /*			      */
#define DDFM_FONT_NULL	4	       /*			      */

#define DDFM_PUBLIC	1	       /* for flOptions parm...       */
#define DDFM_PRIVATE	2	       /* (FmQueryFonts)	      */

#define DDFM_WITH_FONT	1	       /* for flOptions parm...       */
#define DDFM_WITHOUT_FONT 2	       /* (FmCharStr)		      */
#endif /* OMIT */

#define LMATCH_SYS_SBCS 	(-1L)
				       /* lmatch value for SBCS res   */
				       /* font (Sys. Prop.)	      */
				       /* See DBCSFONT.ASM	      */
