;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***********************************************************************
;    Module	      : EDDJDEF.INC
;
;    Description      : PM Display Driver DBCS handling routine
;			Common Definitions for DBCS handling routines
;
;    Created	      : 11/28/91
;    Author	      : Yohji Nakamura (JL04328 at YMTVM6)
;
;    Notes	      :
;
;    History	      :
;
;			OCO Source Materials
;			XXXX-XXX
;***********************************************************************
;======================================================================
; type and constants
;======================================================================
;-----------------------------------------------------------------------;
; Runtime Options				(from OPTIONS.INC)
;-----------------------------------------------------------------------;

; Display driver logical configuration options (for swFlags).
; The configuration is checked at initialization time.
; The significance of the bits in the flags is described below:

SW_OPTIONS	equ	0003h		; sw options field
SW_SYSTEM_DBCS	equ	0001h		; system default codepage is DBCS
SW_DISPLAY_DBCS equ	0002h		; driver can display DBCS font set

; Some basic constants

; MAXSHORT	  equ	  7FFFh 	  ;Kinda majorly positive
; MINSHORT	  equ	  8000h 	  ;Kinda majorly negative
; MAXLONG	  equ	  7FFFFFFFh	  ;Massively positive
; MINLONG	  equ	  80000000h	  ;Massively negative
;
; MAX_COORDINATE  equ	007FFFFFFh	  ;Limit width and height to 27 bits
; MIN_COORDINATE  equ	0F8000000h
;
; SIZE_BYTE	  equ	  1		  ;I hope you never use this!
; SIZE_WORD	  equ	  2		  ;# of bytes in a word
; SIZE_DWORD	  equ	  4		  ;# of bytes in a dword
; SHIFT_BYTE	  equ	  0		  ;I wish they had a power function
; SHIFT_WORD	  equ	  1
; SHIFT_DWORD	  equ	  2
;
; INVALID_SEL	  equ	  0FFFFh
; INVALID_ADDRESS equ	(-1)

;-----------------------------------------------------------------------
; values for NLSParseFlag in FONTDETAILS   (See EDDJDEF.H)
;-----------------------------------------------------------------------
NLSCA_SBCS	equ	0001h
NLSCA_DBCS	equ	0002h
NLSCA_MBCS	equ	0004h

NLSCA_MAP_SBCS	equ	0040h
NLSCA_MAP_DBCS	equ	0080h

NLSCA_MUST_CHOP equ	8000h
NLSCA_UNIFIED_DBCS equ	4000h
NLSCA_CALL_DBCSFM equ	2000h
NLSCA_SBC_ONLY	equ	1000h

;-----------------------------------------------------------------------
; values for NLSFontFlag in FONTDETAILS   (See EDDJDEF.H)
;-----------------------------------------------------------------------
NLSCA_FONT_SBCS equ	0001h
NLSCA_FONT_DBCS equ	0002h
NLSCA_FONT_MBCS equ	0004h
NLSCA_FONT_DBCS_USED equ 0008h

NLSCA_FONT_CACHED equ	0040h
NLSCA_FONT_HUGE equ	0080h

CB_SBCS_MAP_TBL equ	512
CB_DBCS_MAP_TBL equ	256

; CpMapTable	  struc 	      ;ca_paus
; cmt_CharToGlyph db	  CB_SBCS_MAP_TBL dup (?) ; code-point to glyph-index
; cmt_DBCSLeading db	  CB_DBCS_MAP_TBL dup (?) ; code-point to DBCS leading byte
; CpMapTable	  ends


; LONG	  struc 			  ;Used to access the low and
; lo	  dw	  ?			  ;   high words of a dword
; hi	  dw	  ?
; LONG	  ends
;
; FARPOINTER	  struc 		  ;Used to access the offset
; off	  dw	  ?			  ;   and selector of a pointer
; sel	  dw	  ?
; FARPOINTER	  ends
				       ; 
DEFAULTVIOCODEPAGE  equ 850	       ; UGL codepage

