/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module	      : EDDJDEF.H				      */
/*								      */
/*   Description      : PM Display Driver DBCS handling routine       */
/*			Common definitions for DBCS handling routines */
/*								      */
/*   Created	      : 12/03/91				      */
/*   Author	      : Yohji Nakamura (JL04328 at YMTVM6)	      */
/*								      */
/*   Notes	      : 					      */
/*								      */
/*   History	      : 					      */
/*								      */
/*			OCO Source Materials			      */
/*			XXXX-XXX				      */
/**********************************************************************/
/*====================================================================*/
/* constants							      */
/*====================================================================*/
/*--------------------------------------------------------------------*/
/* Values for NLSParseFlag in FONTDETAILS			      */
/*								      */
/* NLSCA_SBCS		 Use SBCS parsing rule			      */
/* NLSCA_MBCS		 Use MBCS parsing rule			      */
/* NLSCA_DBCS		 Use DBCS parsing rule			      */
/*								      */
/*	Note these 3 flags are mutually exclusive.		      */
/*								      */
/* NLSCA_MAP_SBCS	 SBCS mapping vector available (= CA_MUST_MAP)*/
/* NLSCA_MAP_DBCS	 DBCS mapping vector available		      */
/*								      */
/* --- Hi-byte of NLSParseFlag is used for parsing status flags ---   */
/*								      */
/* NLSCA_CONCAT 	Parsing option. If this bit is ON, parser     */
/*			leaves DBCS leading byte un-processed when it */
/*			is the last byte of string.  If OFF, it is    */
/*			converted to SBCS default char. 	      */
/*								      */
/* NLSCA_UNIFIED_DBCS	When this is ON, string to be processed       */
/*			should be converted to unified-DBCS string    */
/*			first.					      */
/*								      */
/* NLSCA_SBC_ONLY	When this is ON, string to be processed       */
/*			includes only single byte characters.	      */
/*								      */
/* NLSCA_CALL_DBCSFM	When this is ON, we need to call DBCS font    */
/*			manager before accessing font data	      */
/*								      */
/* NLSCA_MUST_CHOP	Means given string must be chopped into       */
/*			sub-strings smaller than limit. 	      */
/*			Limit should be:			      */
/*			  when UNIFIED_DBCS is ON: U-DBCS buffer size */
/*			  when CALL_DBCSFM is ON: FM cache size       */
/*								      */
/*--------------------------------------------------------------------*/
#define NLSCA_SBCS	  0x0001
#define NLSCA_DBCS	  0x0002
#define NLSCA_MBCS	  0x0004

#define NLSCA_MAP_SBCS	  0x0040
#define NLSCA_MAP_DBCS	  0x0080

#define NLSCA_MUST_CHOP   0x8000
#define NLSCA_UNIFIED_DBCS 0x4000
#define NLSCA_CALL_DBCSFM 0x2000
#define NLSCA_SBC_ONLY	  0x1000

/*--------------------------------------------------------------------*/
/* Values for NLSFontFlag in FONTDETAILS			      */
/*								      */
/* NLSCA_FONT_SBCS	 font is SBCS font			      */
/* NLSCA_FONT_DBCS	 font is DBCS font			      */
/* NLSCA_FONT_MBCS	 font is MBCS font			      */
/*								      */
/*	Note these 3 flags are mutually exclusive.		      */
/*								      */
/* NLSCA_FONT_CACHED	 cached font (SBCS characters aren't resident)*/
/* NLSCA_FONT_HUGE	 less than 256 characrters in FM-cache at once*/
/*--------------------------------------------------------------------*/
#define NLSCA_FONT_SBCS       0x0001
#define NLSCA_FONT_DBCS       0x0002
#define NLSCA_FONT_MBCS       0x0004

#define NLSCA_FONT_TYPE       (NLSCA_FONT_SBCS | \
			       NLSCA_FONT_MBCS | \
			       NLSCA_FONT_DBCS)

#define NLSCA_FONT_CACHED     0x0040
#define NLSCA_FONT_HUGE       0x0080

/*====================================================================*/
/* external variables						      */
/*====================================================================*/
extern ULONG  ulDrvCompat;	       /* driver version compatibility*/
extern ULONG  ulDrvFontRes;	       /*			      */
extern BOOL   flDrvSaveScreenBits;     /* application compatibility   */
extern BOOL   flDrvAdjustCellSize;     /*			      */
				       /*			      */
#define DRVCOMPAT_1	1	       /* compatible to 1.x driver    */
#define DRVCOMPAT_2	2	       /*		2.x driver    */
#define DRVCOMPAT_DEFAULT	0      /*    driver's own version     */

#define SIZE_FACENAME 32	       /* length of facename field    */

extern CHAR szSysFontName[SIZE_FACENAME];
extern CHAR szVioFontName[SIZE_FACENAME];

extern USHORT usSysFontHeight;	       /*			      */
extern USHORT usSysFontWidth;	       /*			      */

/*====================================================================*/
/* types and constants						      */
/*====================================================================*/
#define CP_UGL_FONT 850

#define DEFAULT_DB_CODEPOINT	0xFFFF /* we will use this value to   */
				       /*   represent a double byte   */
				       /*   default char. (We know    */
				       /*   glyph index for this char,*/
				       /*   but cannot know codepoint)*/
				       /*   Later, when converting    */
				       /*   codepoint to glyph index, */
				       /*   it should be converted to */
				       /*   proper glyph index as no  */
				       /*   known DBCS CP include this*/
				       /*   value as valid codepoint. */
#define WORK_BUFFER_SIZE	MAX_FM_CACHE
				       /* this is necessary & minimum */
				       /*   see below...	      */
/*====================================================================*/
/* some useful macros						      */
/*====================================================================*/
#define ZEROPTR( type ) 	((type *)0)
#define OFSOF( type, field )	&(ZEROPTR(type)->field)
#define ENOUGHSIZE(type,field)				\
		((OFSOF(type,field)+sizeof(ZEROPTR(type)->field)))
				       /* assuming packed struct...   */
/*--------------------------------------------------------------------*/
/* next macro returns max string length we can handle at once, when   */
/*	NLSCA_MUST_CHOP is either ON or OFF.  Limit should be:	      */
/*	Lim-1: When NLSCA_CALL_DBCSFM is ON, size of Font Manager's   */
/*		cache buffer. (kept in FMCacheSize in FONTDETAILS)    */
/*	Lim-2: When NLSCA_UNIFIED_DBCS is ON, size of global U-DBCS   */
/*		buffer. 					      */
/*	Lim-3: When both is OFF, size of global U-DBCS buffer	      */
/*								      */
/*	Since current implementation uses			      */
/*	    (size of U-DBCS buffer) >= (max possible FM cache size)   */
/*	using only Lim-1 is enough when CALL_DBCSFM is ON.	      */
/*--------------------------------------------------------------------*/
#define STRINGLIMIT( pfontdtl ) \
		((pfontdtl)->NLSParseFlag & NLSCA_CALL_DBCSFM ? 	\
		 (pfontdtl)->FMCacheSize : WORK_BUFFER_SIZE)

#if MAX_FM_CACHE > WORK_BUFFER_SIZE
#error "MAX_FM_CACHE must be <= WORK_BUFFER_SIZE!"
#endif
