/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*   Module           : EDDJCACH.H                                    */
/*                                                                    */
/*   Description      : PM Display Driver DBCS handling routine       */
/*                      External definitions for EDDJCACH.C           */
/*                                                                    */
/*   Created          : 12/12/91                                      */
/*   Author           : Yohji Nakamura (JL04328 at YMTVM6)            */
/*                                                                    */
/*   Notes            :                                               */
/*                                                                    */
/*   History          :                                               */
/*                                                                    */
/*                      OCO Source Materials                          */
/*                      XXXX-XXX                                      */
/**********************************************************************/
/*====================================================================*/
/* constants                                                          */
/*====================================================================*/
#define FLAG_NOT_IN_CACHE       0xffff8000
                                       /* need to be valid when conv- */
                                       /* erted to SHORT...           */
#define ERROR_CACHE_FULL        0xffffffff

/*====================================================================*/
/* function definitions                                               */
/*====================================================================*/
extern LONG eddj_LocateInCache( PFONTCACHEINFO pFCInfo,
                                USHORT usCodepoint );

#ifdef OMIT
extern LONG eddj_ForceCharInCache( PFONTDETAILS pFontDtl,
                                   USHORT usCodepoint );

extern ULONG eddh_update_cache( PCHAR          pCodePoints,
                                ULONG          ulCharNum,
                                PFONTCACHEINFO pFontCacheInfo,
                                PFONTDETAILS   pFontDetails,
                                PUSHORT        pStringWidth );

extern ULONG eddj_force_update_cache( PCHAR          pCodePoints,
                                      ULONG          ulCharNum,
                                      PFONTCACHEINFO pFontCacheInfo,
                                      PFONTDETAILS   pFontDetails,
                                      PUSHORT        pStringWidth );
#endif /* OMIT */

extern ULONG eddj_PutStringInCache( PCHAR          pCodePoints,
                                    ULONG          ulCharNum,
                                    PFONTCACHEINFO pFontCacheInfo,
                                    PFONTDETAILS   pFontDetails,
                                    PUSHORT        pStringWidth );

#ifndef _8514                                               
extern ULONG eddj_PutImageInCache( PBYTE pImageData,
                                   USHORT xGlyphWidth,
                                   USHORT yGlyphHeight );

#else 

extern ULONG eddj_PutImageInCache( PBYTE pImageData,
                                   USHORT xGlyphWidth,
                                   USHORT yGlyphHeight,
                                   USHORT index );
#endif 
