/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/* Cruiser has many DCR changes etc associated with it                */
/* To allow individual changes to be tested individually, and to      */
/* allow backing out of other changes, each component of the change   */
/* is conditionally included using a different #ifdef label           */
/* To bring them all together if CRUISER is defined on the command    */
/* line, individual labels are defined here                           */
/*                                                                    */
/* There is an equivalent file for the asm code                       */
/**********************************************************************/

#define DBCS            // DBCS enabling
#define JFIX            // Japan unique problem fix
#define IBMJ            // IBM-Japan unique functions
#define TMP             // Temporary code
#define JTUNE           // Japan additional tune-up code

/**********************************************************************/
/* To try and simplify the make compile line, I have moved the        */
/* common defines in to this file                                     */
/**********************************************************************/
#define PDP
#define VFB
#define REAL_CRUISER
#define POST174
#define DCR4041
#define DLINT_ARGS
#define AVIO_RES_FONTS

#ifdef RETAIL
#undef XGADEBUG
#endif /* RETAIL */

#ifdef REAL_CRUISER

/**********************************************************************/
/* set this if compiling on a cruiser system (ie with cruiser         */
/* header files                                                       */
/**********************************************************************/
#ifndef CRUISER
#define CRUISER
#endif /* ndef CRUISER */

/**********************************************************************/
/* EXTRA_SPACE allows the CHAR_EXTRA and BREAK_EXTRA to be processed  */
/**********************************************************************/
#define EXTRA_SPACE

/**********************************************************************/
/* NEW_CHAR_FLAGS allows for CHS_UNDERSCORE and CHS_STRIKEOUT         */
/**********************************************************************/
#define NEW_CHAR_FLAGS

/**********************************************************************/
/* PALETTE_MGR does what you'd expect !                               */
/**********************************************************************/
#define PALETTE_MGR

/**********************************************************************/
/* BMHEADER2 allows for the use of BITMAP2 type structures            */
/**********************************************************************/
#define BMHEADER2

/**********************************************************************/
/* DEVRES2 uses the changed QueryDevResource2 spec                    */
/**********************************************************************/
#define DEVRES2

/**********************************************************************/
/* NEW_PATTERNS adds 2 new patterns to the pattern set                */
/**********************************************************************/
#define NEW_PATTERNS

/**********************************************************************/
/* LINESBG include support for background colours and mixes           */
/**********************************************************************/
#define LINESBG

/**********************************************************************/
/* EXTRAMIX allows more binary mixes for areas                        */
/**********************************************************************/
#define EXTRAMIX

/**********************************************************************/
/* COLORDATA includes QueryColorData changes                          */
/**********************************************************************/
#define COLORDATA

/**********************************************************************/
/* FLOOD_FILL installs flood fill support                             */
/**********************************************************************/
#define FLOOD_FILL

/**********************************************************************/
/* DRAW_BITS allows the DrawBits calls                                */
/**********************************************************************/
#define DRAW_BITS

/**********************************************************************/
/* SEAMLESS includes the Seamless         code.                       */
/**********************************************************************/
#define SEAMLESS

/**********************************************************************/
/* SIXTEEN is for 16bpp support                                       */
/**********************************************************************/
#define SIXTEEN

/**********************************************************************/
/* FONTSIZE is DCR 50 which requires different font resolutions to    */
/* be returned for different screens.                                 */
/**********************************************************************/
#define FONTSIZE

/**********************************************************************/
/* Cache small bitmaps in left over VRAM.                             */
/**********************************************************************/
#define VRAMPTR

#endif /* REAL_CRUISER */

#ifdef CRUISER
/**********************************************************************/
/* NEW_PALETTE makes our palette the same as the 8514s                */
/**********************************************************************/
#define NEW_PALETTE
/**********************************************************************/
/* NO_HANDLES is for when we drop the AI handle type code             */
/**********************************************************************/
#define NO_HANDLES
/**********************************************************************/
/* CC20 is for 2.0 code for character chaching                        */
/**********************************************************************/
#define CC20
/**********************************************************************/
/* SDBM20 means always use 'Software Drawing to BitMaps for 2.0'      */
/**********************************************************************/
#define SDBM20
#endif /* CRUISER */


/**********************************************************************/
/* the file below is as it was for 1.3 and previous versions of the   */
/* driver                                                             */
/* there is no equivalent .inc file for this bit                      */
/**********************************************************************/
#define INCL_WINHEAP


#define INCL_GRE_DEVSUPPORT
#define INCL_DDIBUNDLES
#define INCL_DDIDEFS
#define INCL_DDIFONTSTRUCS
#define INCL_SUB
#define INCL_WINP_SELSERVER
#define INCL_WINPOINTERS
#define INCL_DOSSEMAPHORES
#define INCL_GPIDISPPRF

#include <os2.h>
#include <pmwinx.h>
#include <pmgpip.h>
#ifdef INCL_32
    #include <32pmddi.h>
#else
    #include <pmddi.h>
#endif  /* INCL_32 */
#include <pmtktp.h>

/**********************************************************************/
/* This file has not been moved to the 32bit API yet.                 */
/**********************************************************************/
#define INCL_NOSHIELDPROCS  /* we dont want the function prototypes ! */
#include <pmaviop.h>

#include <eddtypes.h>
#include <afiexp.h>

#include <eddmacro.h>
#include <eddconse.h>
#include <eddconty.h>
#include <edddcone.h>
#include <edderre.h>
#ifdef INCL_32
#include <semaphor.h>
#endif /* INCL_32 */

/**********************************************************************/
/* now include a file which contains all the definitions etc which    */
/* are missing from the PM include files                              */
/**********************************************************************/
#include <missing.h>
#include <paltypes.h>
#include "xgaadapt.h"

#include <eddtypet.h>

#include <edddebug.h>

/**********************************************************************/
/* Include the string handling function prototypes.                   */
/* There are problems including them in 16bit code.                   */
/**********************************************************************/
#ifndef INCL_16
//#include <string.h>
#endif /* ndef INCL_16 */

/**********************************************************************/
/* define the PDC global pointre as an external                       */
/**********************************************************************/
extern PDC             pdc;
#ifndef   _8514
extern ADAPTERINFO     aiXGAAdapter;
extern ADAPTERINFO2    ai2XGAAdapter;
#else
extern ADAPTER8514     ai8514Adapter;
#endif

/**********************************************************************/
/* flags for SSAlloc (shareable with GetSeg = 2)                      */
/**********************************************************************/
#define ALLOC_FLAGS 2

/**********************************************************************/
/* These line will need tidying up when we come to do a retail build. */
/* For the moment to get debug output in a particular source module   */
/* define XGADEBUG before including eddinclt.h                        */
/**********************************************************************/
#ifndef XGADEBUG

// avoid compiler warning that we redefine an existing macro !
#ifdef DebugOutput
#undef DebugOutput
#endif
#ifdef DebugInput
#undef DebugInput
#endif

#define DebugOutput(X)
#define DebugInput()

#define OutputString(String)
#define OutputValue(Value,Base)
#define OutputPair(String,Value,Base)
#define CrLf()

#endif /* XGADEBUG */

#ifdef RETAIL
#define haltproc()
#else
VOID haltproc(VOID);
#endif /* RETAIL */

/**********************************************************************/
/* We use some low value pointers as LCIDs for fonts.                 */
/**********************************************************************/
#define MAX_LCID 254




#ifdef MATROX
#include "matrox.h"
#endif /* MATROX */

#ifdef FIREWALLS
/* can only use 4 of these when INI entry is a char, ie 1 is 31. */
#define FIRST_TIME_INT 1
#define FIRST_TIME_INT_ENABLED ((achInts[0]&FIRST_TIME_INT)!=0)
#define NEW_PROCESS_INT 2
#define NEW_PROCESS_INT_ENABLED ((achInts[0]&NEW_PROCESS_INT)!=0)
#define UNUSED_XGA_INT1 4
#define UNUSED_XGA_INT2 8

extern CHAR chInts;
#endif /* FIREWALLS */

