;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.xlist
;**********************************************************************/
;*                                                                    */
;*   File            = EDDHTYPE                                       */
;*                                                                    */
;*   Description     = Display Device Driver Types for masm           */
;*                                                                    */
;*   Function        =                                                */
;*                                                                    */
;*   Reference       = Device Driver Interface Specification          */
;*                                                                    */
;*                                                                    */
;**********************************************************************/



; Clip rectangles

clip_rect       struc
clip_x0         dw      ?
clip_x0h        dw      ?
clip_y0         dw      ?
clip_y0h        dw      ?
clip_x1         dw      ?
clip_x1h        dw      ?
clip_y1         dw      ?
clip_y1h        dw      ?
clip_rect       ends

len_clip_rect   equ     10h

pointer         struc
off             dw      ?
sel             dw      ?
pointer         ends

; extended bitmap header

bitmap_header   struc
virt_addr       dd      ?
phys_addr       dd      ?
bm_size         dd      ?
bm_width        dw      ?
bm_height       dw      ?
bm_format       dw      ?
hw_width        dw      ?
hw_height       dw      ?
hw_format       dw      ?
dchandle        dd      ?
bytesperline    dw      ?
ifdef VRAMPTR
bm_cache_slot   dd      ?
endif ; VRAMPTR
markerinfo      dd      ?
bitmap_header   ends

; Type for BltSPad
BltSPad         struc
ExpPatBMHeader  db      size bitmap_header DUP(?)
ExpSrcBMHeader  db      size bitmap_header DUP(?)
ExpDstBMHeader  db      size bitmap_header DUP(?)
BltFunction     dd      ?
ClipRectX0      dw      ?
ClipRectX0H     dw      ?
ClipRectY0      dw      ?
ClipRectY0H     dw      ?
ClipRectX1      dw      ?
ClipRectX1H     dw      ?
ClipRectY1      dw      ?
ClipRectY1H     dw      ?
BltSPad         ends

; Type for AVIOINFO
AVIOInfo        struc
pfciTable       dd      ?
pfciTable1      dd      ?
pfciTable2      dd      ?
pfciTable3      dd      ?
bCellWidth      db      ?
bCellHeight     db      ?
sXoffset        dw      ?
sYoffset        dw      ?
AVIOInfo        ends

; Type for FONTDETAILS
FONTDETAILS         struc
pFocaFont           dd  ?
usCachedFontIndex   dw  ?
usCodePage          dw  ?
pCodePageVector     dd  ?
usFontID            dw  ?
ifdef DBCS                                                             ;/*KASA*/
pDBCSMap            dd  ?                                              ;/*KASA*/
NLSParseFlag        dw  ?                                              ;/*KASA*/
NLSFontFlag         dw  ?                                              ;/*KASA*/
FMCacheSize         dw  ?                                              ;/*KASA*/
usECodePage         dw  ?                                              ;/*KASA*/
lMatch              dd  ?                                              ;/*KASA*/
usDbcWidth          dw  ?                                              ;/*KASA*/
ulDefCodepoint      dd  ?                                              ;/*KASA*/
endif                                                                  ;/*KASA*/
FONTDETAILS         ends


; Dword access under 286

WORDPART        STRUC
lo              dw      ?               ;lo part at +0
hi              dw      ?               ;hi part at +2
WORDPART        ENDS

; coordinates access

coords          struc
x               dw      ?
y               dw      ?
coords          ends

; limits access

limits          struc
cmin            dw      ?
cmax            dw      ?
limits          ends

csdb            struc

csetres1        db      ?               ; reserved
csettype        db      ?               ; character set type
csetres2        db      ?               ; reserved
csetres3        db      4 dup(?)        ; reserved
csetcx          db      ?               ; cell width in pels
csetcy          db      ?               ; cell height in pels
csetres4        db      ?               ; reserved
csetcell        dw      ?               ; cell size in bytes
csetflag        dw      ?               ; character set flags
csetixt         dd      ?               ; address of index table
csetcet         dd      ?               ; address of character envelope table
csetfirst       db      ?               ; first code point
csetlast        db      ?               ; last code point
csetchar        dd      ?               ; address of character set table
csetres5        db      ?               ; reserved
csetres6        db      ?               ; reserved
cset2char       dd      ?               ; address of plane 2 char set table
csetres7        db      ?               ; reserved
csetres8        db      ?               ; reserved
cset3char       dd      ?               ; address of plane 3 char set table

csdb            ends

; character set flags
multi_plane     equ     04000h          ; 0=single_plane, 1=tri_plane
prop_spaced     equ     02000h          ; 0=fixed_space,  1=proportional_space

; constant values for csettype
csetimage       equ     0               ; image character set
csetssv         equ     3               ; short stroke vector character set
extended_font   equ     01000h          ; 1 = font in extended memory

ifdef DCAF                                                                ;@DCAF
GSB_PB                      struc                                         ;@DCAF
gsb_pNextFreeDestByte       dd ?                                          ;@DCAF
gsb_cbFreeBytesInDestBuffer dd ?                                          ;@DCAF
gsb_pfnCompressRow          dd ?                                          ;@DCAF
gsb_prclCurrent             dd ?                                          ;@DCAF
gsb_cbCompressBufferSize    dd ?                                          ;@DCAF
gsb_pTransferBufferVirt     dd ?                                          ;@DCAF
gsb_pTransferBufferPhys     dd ?                                          ;@DCAF
gsb_cbTransferBufferSize    dd ?                                          ;@DCAF
gsb_pConvertBuffer1         dd ?                                          ;@DCAF
gsb_pConvertBuffer2         dd ?                                          ;@DCAF
gsb_ulDataFieldSize         dd ?                                          ;@DCAF
gsb_cyScreenHeight          dd ?                                          ;@DCAF
gsb_cScreenBitsPerPel       dd ?                                          ;@DCAF
gsb_ulXGAPixOp              dd ?                                          ;@DCAF
gsb_ulPixMapFormatB         dd ?                                          ;@DCAF
GSB_PB                      ends                                          ;@DCAF
                                                                          ;@DCAF
                                                                          ;@DCAF
SSB_PB                      struc                                         ;@DCAF
ssb_pNextSrcByte            dd ?                                          ;@DCAF
ssb_fConversionRequired     dd ?                                          ;@DCAF
ssb_pfnConvertRow           dd ?                                          ;@DCAF
ssb_cbBytesPerScanline      dd ?                                          ;@DCAF
ssb_pConvertBuffer1         dd ?                                          ;@DCAF
ssb_pConvertBuffer2         dd ?                                          ;@DCAF
ssb_cyRowsToDo              dd ?                                          ;@DCAF
ssb_cPelsPerRow             dd ?                                          ;@DCAF
ssb_cbBytesPerDstRow        dd ?                                          ;@DCAF
ssb_pTopDstRow              dd ?                                          ;@DCAF
ssb_cbEndOfRowInc           dd ?                                          ;@DCAF
ssb_cDataFieldsPerRow       dd ?                                          ;@DCAF
ssb_pConvertTable           dd ?                                          ;@DCAF
SSB_PB                      ends                                          ;@DCAF
endif ;DCAF                                                               ;@DCAF

.list
