/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   FILE: EDDHTYPE.H                                                 */
/*                                                                    */
/*   DESCRIPTION     = XGA performance specific types                 */
/*                                                                    */
/*   REFERENCE       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/*   CHANGE HISTORY:                                                  */
/*                                                                    */
/*   d69092 21May93 <DCRTURBO> (KJE, GAM) Creation for turbo stretch  */
/*              implementation to improve performance of image        */
/*              stretching bitblt function.                           */
/**********************************************************************/

/**********************************************************************/
/* Thats better..                                                     */
/**********************************************************************/
typedef ClipRectangle * pClipRectangle;

/**********************************************************************/
/*                                                                    */
/* GENERAL ENHANCED PERFORMANCE TYPES                                 */
/*                                                                    */
/**********************************************************************/
typedef struct _coord { /* co */
    SHORT    x;
    SHORT    y;
} coord;

/**********************************************************************/
/*                                                                    */
/* POLYLINE (DRAWLINESINPATH) ENHANCED PERFORMANCE TYPES              */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Parameter block                                                    */
/**********************************************************************/
typedef struct _POLYLINEPB { /* plpb */
    ULONG           ulPixelOp;
    USHORT          cClipRects;
    pClipRectangle  pClipRects;
    POINTS          ptsFirstPos;
    POINTS          ptsDevOffsets;
    ULONG           cPoints;
    PVOID           pPoints;
    USHORT          usPatPos;
    USHORT          usPatType;
    PVOID           pPlotStepCodes;
    USHORT          usPatEnd;
    USHORT          usCallType;
    pBitmapHeader   pbmhDest;
} POLYLINEPB;

typedef POLYLINEPB * PPOLYLINEPB;

/**********************************************************************/
/* Scratch pad block                                                  */
/**********************************************************************/
typedef struct _PolylineSP { /* plsp */
        coord       startpoint;
        coord       endpoint;
        USHORT      herror;
        LONG        patdimtmp;
        USHORT      patpostmp;
        LONG        mskofftmp;
        LONG        xlimits;
        LONG        ylimits;
        USHORT      ETstart;
        USHORT      PatPosStart;
        LONG        newstart;
        LONG        newend;
        USHORT      deltaX;
        USHORT      deltaY;
        USHORT      clipstatus;
        USHORT      k1;
        USHORT      k2;
        USHORT      k1_k2;
        ULONG       point_count;
        USHORT      clip_count;
        USHORT      oldclipsptr;
        USHORT      oldclipsnum;
        LONG        pixopwork;
#ifdef _8514
        USHORT      usMajorAxis;
        USHORT      usErrorTerm;
        USHORT      usCmdFlags;
#endif
        DevRect     PLineBounds;
        DevRect     OrigLine;
        DevRect     ClipRect;
        BYTE        RunStore[RUN_BATCH_SIZE];
        DevPoint    BitmapSize;
    } PolyLineSP;

/**********************************************************************/
/* Type defintion for the look up tables we use to do bresenham.      */
/**********************************************************************/
typedef struct _BresStep { /* bs */
        DevPoint    Both;
        DevPoint    Major;
    } BresStep;

typedef struct _PlotStep { /* psp */
        BYTE        Both;
        BYTE        Major;
    } PlotStep;

/**********************************************************************/
/*                                                                    */
/* BITBLT ENHANCED PERFORMANCE TYPES                                  */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Define scanline length which will be used in defining the vector   */
/* that holds information on the source pixel replication/dessimation */
/* for each pixel in the destination scanline.                        */
/**********************************************************************/
#define  MAX_SCANLINE_LENGTH 65536

/**********************************************************************/
/* BitBlt() structures for hardware access                            */
/**********************************************************************/
typedef struct _BITBLTPB
{
    pBitmapHeader    pbmhDest;
    USHORT           cDestClipRects;
    pClipRectangle   pNextDestClipRect;
    RECTS            rcsTrg;
    pBitmapHeader    pbmhSrc;
    RECTS            rcsSrc;
    POINTS           ptsPatOrig;
    ULONG            ulPixelOp;
    PSHORTLINE       pSLHeaderLeft;
    PSHORTLINE       pSLHeaderRight;
#ifdef DCAF                                                      //DCAF
    BOOL             fAccumulateDCAFBounds;                      //DCAF
#endif                                                           //DCAF

    /******************************************************************/
    /* <DCRTURBO> - Additional fields defined below to TurboStretch   */
    /* functional enhancements.                                       */
    /******************************************************************/

    /******************************************************************/
    /* Fake bitmap header for stretch function implementation. This   */
    /* will contain the "stretched" coordinates that are needed to    */
    /* fake out the XGA Display Driver BitBlt routines so that they   */
    /* see that the source bitmap and destination bitmaps are both    */
    /* the same size.                                                 */
    /******************************************************************/
    BitmapHeader     bmhStretchSrc;

    /******************************************************************/
    /* Pointer to real bitmap header that was passed in to the XGA    */
    /* Display Driver Bitblit routine by the Graphics Engine.         */
    /******************************************************************/
    pBitmapHeader    pbmhRealStretchSrc;

    /******************************************************************/
    /* TRUE if stretch operation is in effect.                        */
    /******************************************************************/
    ULONG            fStretching;

    /******************************************************************/
    /* Extents of UNSTRETCHED source.                                 */
    /******************************************************************/
    USHORT           usSrcXExt;
    USHORT           usSrcYExt;

    /******************************************************************/
    /* Extents of destination bitmap.                                 */
    /******************************************************************/
    USHORT           usDstXExt;
    USHORT           usDstYExt;

    /******************************************************************/
    /* Stretch operation error terms indicating the modulo ratio      */
    /* diferences between the source and destination extents.         */
    /******************************************************************/
    USHORT           usXErrorTerm;
    USHORT           usYErrorTerm;

    /******************************************************************/
    /* Define the origin point that will represent the origin of the  */
    /* final stretched source bitmap (not the source origin of the    */
    /* unstretched, as provided by entry into bitblt from the         */
    /* Graphics Engine). This will map to the Bottom-Left point of    */
    /* the source rectangle which is relative to the AI origin offset */
    /* (The AI origin is in the Top-Left):                            */
    /*                                                                */
    /*  AI Origin                                                     */
    /*   (XA,YA)                                                      */
    /*     +Ŀ     */
    /*                                                              */
    /*               Ŀ              */
    /*               ///////////////////////////////              */
    /*               ///////////////////////////////              */
    /*               //////Stretched Source/////////              */
    /*               ///////////////////////////////              */
    /*               ///////////////////////////////              */
    /*               +              */
    /*        ptsStretchSrcOrig                                     */
    /*             (X,Y)                                            */
    /*                                                              */
    /*     +     */
    /* Graphics Engine                                                */
    /*     Origin                                                     */
    /*     (XG,YG)                                                    */
    /*                                                                */
    /* NOTE: Conversion must be done to compute the ptsStretchSrcOrig */
    /*       (X,Y) coordinates relative to the AI Origin (XA, YA);    */
    /*       This involves manipulating the Y value of the source     */
    /*       origin relative to the Graphics Engine's origin reference*/
    /*       (XG,YG) depicted above.                                  */
    /*                                                                */
    /******************************************************************/
    POINTS           ptsStretchSrcOrig;

    /******************************************************************/
    /* Stretch pixel vector used by stretch functions to determine    */
    /* which pixels to use when replicating OR dessimating to         */
    /* accomplish stretching function.                                */
    /*                                                                */
    /* This array will contain the zero-based index offsets into the  */
    /* source bitmap for creating the stretched destinamtion bitmap.  */
    /******************************************************************/
    USHORT           *horizontalPixelVector ;

    /******************************************************************/
    /* BitBlt Options parameter (e.g. BBO_IGNORE, BBO_OR)             */
    /******************************************************************/
    ULONG            ArgOptions;

    /******************************************************************/
    /* <DCRTURBO> - End of additional fields.                         */
    /******************************************************************/

} BITBLTPB;

typedef BITBLTPB * PBITBLTPB;

/**********************************************************************/
/* ds scratch pad redefinition for bitblt                             */
/**********************************************************************/
typedef struct _BltSpad { /* bsp */
    BitmapHeader     ExpPatBMHeader;
    BitmapHeader     ExpSrcBMHeader;
    BitmapHeader     ExpDstBMHeader;
    VOID ( * BltFunction)();
    ClipRectangle    ClipRect;
} BltSPad;


/**********************************************************************/
/* text structures for hardware access                                */
/* note first three fields in common with BitBltPB - this is crucial  */
/**********************************************************************/
typedef struct _TEXTPB { /* tpb */
    pBitmapHeader     pbmhDest;
    USHORT            cDestClipRects;
    pClipRectangle    pNextDestClipRect;
    POINTS            ptsStartCoord;
    USHORT            cChars;
    PBYTE             pCodePoints;
    PINTFONT          pIntFont;
    #ifndef   BPP24
    USHORT            usBColor;
    USHORT            usFColor;
    #else
    ULONG             usBColor;
    ULONG             usFColor;
    #endif
    USHORT            usTheCharSpacing;
    PFONTCACHEINFO    pFontCacheInfo;
    PBYTE             pCharCache;
    BYTE              bCharWidth;
    BYTE              bCharHeight;
    PBYTE             pCharMask;
#ifdef _8514
    USHORT            usCacheInUse;
#endif
#ifdef DBCS                                                 
    BYTE              bfgmix;          /* needed for correct offset!  */
    BYTE              bbgmix;          /* ditto...                    */
    PSHORT            psCacheIndex;    /* we need this ptr in         */
                                       /* eddh_draw_text              */
                                       /* Note this struct may be     */
                                       /* expanded to max 120B.       */
#endif                                                      
} TEXTPB;

typedef TEXTPB * PTEXTPB;

typedef struct _AATextPB { /* aapb */
    pBitmapHeader     DstBMHeader;
    USHORT            NumDstClipRegions;
    pClipRectangle    pNextDestClipRect;
    DevPoint          FirstCharacterPosition;
    USHORT            NumberOfCharacters;
    PBYTE             CodePoints;
    PAIFONT           pAIFont;
    USHORT            BColor;
    USHORT            FColor;
    USHORT            theCharSpacing;
    PFONTCACHEINFO    pFontCacheInfo;
    ULONG             CharCacheAddr;
    BYTE              CharWidth;
    BYTE              CharHeight;
    ULONG             CharMaskAddr;
} AATextPB;

typedef AATextPB * pAATextPB;

typedef struct _LockedFontData { /* lfd */
    USHORT     Set;
    SEL        LockDC;
    ULONG      Handle;
    ULONG      Address;
} LockedFontData;

/**********************************************************************/
/*                                                                    */
/* AVIO ENHANCED PERFORMANCE TYPES..                                  */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Define a type to access the parameter block during AVIO calls      */
/**********************************************************************/
typedef struct _AVIOPB { /* avpb */
    BYTE            bColumn;
    BYTE            bRow;
    BYTE            bAcross;
    BYTE            bDown;
    PBYTE           pLVBChars;
#ifdef DBCS                                                 
    PBYTE           pLVBFirst;
    PBYTE           pLVBLast;
#endif 
    BYTE            bBufferWidth;
    BYTE            bSourceColumn;
    BYTE            bSourceRow;
    BYTE            bDestColumn;
    BYTE            bDestRow;
    USHORT          cClipRects;
    pClipRectangle  pFirstClipRect;
    pClipRectangle  pCurrentClipRect;
    USHORT          usCursorX;
    USHORT          usCursorY;
    USHORT          usCursorH;
    USHORT          usCursorL;
    pBitmapHeader   pbmhDest;
} AVIOPB;

typedef AVIOPB * PAVIOPB;

/**********************************************************************/
/*                                                                    */
/* POLYSHORTLINES ENHANCED PERFOMANCE TYPES                           */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Parameter block                                                    */
/**********************************************************************/
typedef struct _SHORTLINESPB { /* shpb */
    ULONG           ulPixelOp;
    USHORT          usPatPos;
    USHORT          usPatType;
    USHORT          usXStart;
    USHORT          usYStart;
    USHORT          usYStop;
    PVOID           pSteps;
    USHORT          usPatEnd;
} SHORTLINESPB;

/**********************************************************************/
/* Scratch pad block                                                  */
/**********************************************************************/
typedef struct _ShortLinesSP { /* shsb */
    USHORT  numysteps;
    USHORT  yplot;
    USHORT  diagleft;
    USHORT  diagright;
    USHORT  patpostmp;
    DevRect PSLineBounds;
} ShortLinesSP;

/**********************************************************************/
/*                                                                    */
/* IMAGE DATA ENHANCED PERFORMANCE TYPES                              */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Parameter block                                                    */
/* If you change this structure, then also change the one in          */
/* eddhimag.asm                                                       */
/**********************************************************************/
typedef struct _IMAGEDATAPB { /* ipb */
    POINTS          ptsStart;
    PBYTE           pPels;
    ULONG           ulCount;
    pClipRectangle  pClipRects;
    pBitmapHeader   pbmhDest;
    USHORT          cClips;
} IMAGEDATAPB;


/**********************************************************************/
/*                                                                    */
/* GET / SETPEL ENHANCED PERFORMANCE TYPES                            */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* single byte buffer for transfer                                    */
/**********************************************************************/
typedef struct _ONEPELBUFFER { /* opb */
   ULONG    phys_addr;
   #ifdef BPP24
   PULONG   virt_addr;
   #else
   PUSHORT  virt_addr;
   #endif
} ONEPELBUFFER;

#ifdef DCAF                                                               //DCAF
/**********************************************************************/  //DCAF
/* DCAF GetScreenBits scratchpad definition                           */  //DCAF
/**********************************************************************/  //DCAF
typedef struct _GSB_PB {                                                  //DCAF
    PBYTE   pNextFreeDestByte;                                            //DCAF
    ULONG   cbFreeBytesInDestBuffer;                                      //DCAF
    PFN     pfnCompressRow;                                               //DCAF
    PRECTL  prclCurrent;                                                  //DCAF
    ULONG   cbCompressBufferSize;                                         //DCAF
    PBYTE   pTransferBufferVirt;                                          //DCAF
    PBYTE   pTransferBufferPhys;                                          //DCAF
    ULONG   cbTransferBufferSize;                                         //DCAF
    PBYTE   pConvertBuffer1;                                              //DCAF
    PBYTE   pConvertBuffer2;                                              //DCAF
    ULONG   ulDataFieldSize;                                              //DCAF
    ULONG   cyScreenHeight;                                               //DCAF
    ULONG   cScreenBitsPerPel;                                            //DCAF
    ULONG   ulXGAPixOp;                                                   //DCAF
    ULONG   ulPixMapFormatB;                                              //DCAF
} GSB_PB;                                                                 //DCAF
                                                                          //DCAF
/**********************************************************************/  //DCAF
/* DCAF SetScreenBits scratchpad definition                           */  //DCAF
/**********************************************************************/  //DCAF
typedef struct _SSB_PB {                                                  //DCAF
    PBYTE   pNextSrcByte;                                                 //DCAF
    ULONG   fConversionRequired;                                          //DCAF
    PFN     pfnConvertRow;                                                //DCAF
    ULONG   cbBytesPerScanline;                                           //DCAF
    PBYTE   pConvertBuffer1;                                              //DCAF
    PBYTE   pConvertBuffer2;                                              //DCAF
    ULONG   cyRowsToDo;                                                   //DCAF
    ULONG   cPelsPerRow;                                                  //DCAF
    ULONG   cbBytesPerDstRow;                                             //DCAF
    PBYTE   pTopDstRow;                                                   //DCAF
    ULONG   cbEndOfRowInc;                                                //DCAF
    ULONG   cDataFieldsPerRow;                                            //DCAF
    PBYTE   pConvertTable;                                                //DCAF
} SSB_PB;                                                                 //DCAF
#endif                                                                    //DCAF

