/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDHMACR                                       */
/*                                                                    */
/*   Description     = Expressway performance specific macros         */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* probably not necessary...??                                        */
/**********************************************************************/
#ifndef   _8514
#define SetXColors(F,B) ShadowXGARegs.FgCol = (F) ; \
                        ShadowXGARegs.BgCol = (B) ;
#else
#define SetXColors(F,B) Shadow8514Regs.FgCol = (F) ; \
                        Shadow8514Regs.BgCol = (B) ;
#endif

/**********************************************************************/
/* This macro decides whether x,y are inside the guard area.          */
/**********************************************************************/
#define InGuard(A,B)  \
        (((A) > GUARD_MIN_X) && ((A) < GUARD_MAX_X) &&   \
         ((B) > GUARD_MIN_Y) && ((B) < GUARD_MAX_Y))

/**********************************************************************/
/* This macro decides whether x,y are inside a rectangle.             */
/**********************************************************************/
#define InRect(X1,Y1,X2,Y2,X,Y)  \
        (((X) > X1) && ((X) < X2) &&   \
         ((Y) > Y1) && ((Y) < Y2))

/**********************************************************************/
/* This macro loops until the hardware is ready.  At 2.0 flat memory  */
/* model we must call an assembler routine to do this for use because */
/* we can not acccess the memory mapped registers from C.             */
/**********************************************************************/
#ifndef _8514
#define WaitForRealHW WaitForRealHWFunction();
#else
#define WaitForRealHW
#endif

/**********************************************************************/
/* redefinition of the AIxfer parameter block for use by bitblt       */
/**********************************************************************/
#define DstBltParms ((pHACDstBltParm)AIxfer)
#define SrcDstBltParms ((pHACSrcDstBltParm)AIxfer)
#define PatDstBltParms ((pHACPatDstBltParm)AIxfer)
#define SrcPatDstBltParms ((pHACSrcPatDstBltParm)AIxfer)

/**********************************************************************/
/* underpaint macros                                                  */
/**********************************************************************/

#ifdef _8514
 #ifdef S3
  #if 1
    #define UseColorCompare(mix)    (0)
    #define UseSoftwareMix(mix)     (0)
    #define UseSoftwareUnderpaint() (0)
  #else
    #define UseSoftwareMix(mix) (mix == BM_DESTTRANSPARENT ||   \
                                 mix == BM_SRCTRANSPARENT)
    #define UseSoftwareUnderpaint()                             \
        (Shadow8514Regs.Mode.UnderPaint == MD_UP_NE ||          \
         Shadow8514Regs.Mode.UnderPaint == MD_UP_EQ)
  #endif
 #else
    #define UseColorCompare(mix) (mix == BM_SRCTRANSPARENT ||   \
                                  mix == BM_DESTTRANSPARENT)
    #define UseSoftwareMix(mix) (mix == BM_SRCTRANSPARENT)
    #define UseSoftwareUnderpaint()                             \
        (Shadow8514Regs.Mode.UnderPaint == MD_UP_EQ)
 #endif
#else
    #define UseColorCompare(mix) (mix == BM_SRCTRANSPARENT ||   \
                                  mix == BM_DESTTRANSPARENT)
    #define UseSoftwareMix(mix) (mix == BM_SRCTRANSPARENT)
    #define UseSoftwareUnderpaint()                             \
        (ShadowXGARegs.ColCompCond == COLCOMP_SRC_NOT_EQUAL)
#endif

