/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDHDATA                                       */
/*                                                                    */
/*   Description     = Expressway performance specific data           */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/*   CHANGE HISTORY:                                                  */
/*                                                                    */
/*   06/04/93 - DCRTURBO (GAM/KJE) Added TurboStretching function to  */
/*              improve image stretch performance.                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#include <eddinclt.h>

#include <eddtcone.h>
#include <eddhcone.h>
#include <eddhtype.h>

#ifdef _8514
#include <8514.h>
#endif

/**********************************************************************/
/* Pointer to the real hardware memory mapped registers.              */
/**********************************************************************/
#ifndef   _8514
ULONG pRealXGARegs = NULL;
#else
ULONG pReal8514Regs = NULL;
#endif

/**********************************************************************/
/* Pointer to either the real hardware memory mapped registers or to  */
/* the shadow registers (ShadowXGARegs) depending on whether we are   */
/* in software or hardware drawing mode.                              */
/**********************************************************************/
#ifndef   _8514
ULONG pXGARegs = NULL;
#else
ULONG p8514Regs = NULL;
#endif

/**********************************************************************/
/* <DCRTURBO> - Increased size of AIxfer global data area to          */
/* accomodate additional fields added to the BITBLTPB structure.      */
/*                                                                    */
/* !!!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!NOTE!!!! */
/*                                                                    */
/* The size of this global data area is based on the largest size     */
/* of the associated PB data structures defined in EDDHTYPE.H,        */
/* which at this point is BITBLTPB. If, however, other PB structures  */
/* should become larger, then one must change the parameter for the   */
/* sizeof() macro used below.                                         */
/**********************************************************************/
ULONG AIxfer[sizeof(BITBLTPB)] = {0};

/**********************************************************************/
/* <DCRTURBO> - Declare the data area that will be used to determine  */
/* what pixels are to be used from the source bitmap to either        */
/* replicate OR dessimate in creating the destination bitmap.         */
/**********************************************************************/
USHORT usHorPixelVector[MAX_SCANLINE_LENGTH];

/**********************************************************************/
/* <DCRTURBO> - Declare a set of one-byte bit masks that are used by  */
/* the StretchCopyChunkToPhunk routine for handling 1bpp bitmaps.     */
/**********************************************************************/
BYTE  bSrcMaskLeftOR[]   = {0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01};
BYTE  bSrcMaskRightOR[]  = {0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF};
BYTE  bSrcMaskLeftAND[]  = {0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE};
BYTE  bSrcMaskRightAND[] = {0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01, 0x00};

/**********************************************************************/
/* Scratch pad area for individual routines which KNOW WHAT THEY ARE  */
/* DOING!!!.  Declare SPad as an extern structure.                    */
/* The {0} is a place holder as above.                                */
/**********************************************************************/
ULONG SPad[SPAD_SIZE_IN_DWORDS] = {0};

/**********************************************************************/
/* Bitmap header used for outputting cached vector fonts              */
/**********************************************************************/
BitmapHeader       VectCacheBMHeader;

/**********************************************************************/
/* Storage for polyline parameter block.                              */
/**********************************************************************/
USHORT          StaticCoordStore[MAX_STATIC_COORDS*4];

/**********************************************************************/
/* Table of steps for bresenham line drawing.                         */
/**********************************************************************/
BresStep    BresSteps[8] = {
                            {  1,  1,  1,  0 },        /* 0 */
                            {  1,  1,  0,  1 },        /* 1 */
                            {  1, -1,  1,  0 },        /* 2 */
                            {  1, -1,  0, -1 },        /* 3 */
                            { -1,  1, -1,  0 },        /* 4 */
                            { -1,  1,  0,  1 },        /* 5 */
                            { -1, -1, -1,  0 },        /* 6 */
                            { -1, -1,  0, -1 },        /* 7 */
                           };

/**********************************************************************/
/* Note these direction codes are shifted left 5 bits and bit 4 is set*/
/* ready for hardware.                                                */
/**********************************************************************/
PlotStep    PlotSteps[8] = {
                            { 240,  16 },
                            { 240, 208 },
                            {  48,  16 },
                            {  48,  80 },
                            { 176, 144 },
                            { 176, 208 },
                            { 112, 144 },
                            { 112,  80 },
                           };

/**********************************************************************/
/* Table to translate Winthorn mixes to hardware mix values.          */
/**********************************************************************/
#ifndef   _8514
BYTE WinToXway[] =    { 0x00,       /* not used-Winthorn mix 0=default*/
                        0x07,       /* OR                             */
                        0x03,       /* OVERPAINT                      */
                        0x05,       /* not used - LEAVE ALONE ?       */
                        0x06,       /* XOR                            */
                        0x05,       /* LEAVE ALONE                    */
                        0x01,       /* AND                            */
                        0x04,       /* (INV source) AND destination   */
                        0x02,       /* source AND (INV destination)   */
                        0x00,       /* ZEROS                          */
                        0x08,       /* INV (source OR destination)    */
                        0x09,       /* INV (source XOR destination)   */
                        0x0A,       /* invert destination             */
                        0x0B,       /* source OR (INV destination)    */
                        0x0C,       /* INV source                     */
                        0x0D,       /* (INV source) OR destination    */
                        0x0E,       /* INV (source AND destination)   */
                        0x0F };     /* ONES                           */
#else
BYTE WinToXway[] =    { 0x01,       /* not used-Winthorn mix 0=default*/
                        0x0B,       /* OR                             */
                        0x07,       /* OVERPAINT                      */
                        0x03,       /* not used - LEAVE ALONE ?       */
                        0x05,       /* XOR                            */
                        0x03,       /* LEAVE ALONE                    */
                        0x0C,       /* AND                            */
                        0x0E,       /* (INV source) AND destination   */
                        0x0D,       /* source AND (INV destination)   */
                        0x01,       /* ZEROS                          */
                        0x0F,       /* INV (source OR destination)    */
                        0x06,       /* INV (source XOR destination)   */
                        0x00,       /* invert destination             */
                        0x0A,       /* source OR (INV destination)    */
                        0x04,       /* INV source                     */
                        0x09,       /* (INV source) OR destination    */
                        0x08,       /* INV (source AND destination)   */
                        0x02 };     /* ONES                           */

BYTE Conv8514toXGA[] = {0x0A,       /* NOT dest                       */
                        0x00,       /* ZEROS                          */
                        0x0F,       /* ONES                           */
                        0x05,       /* LEAVE ALONE                    */
                        0x0C,       /* INV source                     */
                        0x06,       /* source XOR destination         */
                        0x06,       /* INV (source XOR destination)   */
                        0x03,       /* OVERPAINT                      */
                        0x0E,       /* INV (source AND destination)   */
                        0x0D,       /* (INV source) OR destination)   */
                        0x0B,       /* source OR (INV destination)    */
                        0x07,       /* OR                             */
                        0x01,       /* AND                            */
                        0x02,       /* source AND (INV destination)   */
                        0x04,       /* (INV source) AND destination   */
                        0x08 };     /* INV (source OR destination)    */

BYTE InverseTable[] = { 0x03,
                        0x02,
                        0x01,
                        0x00,
                        0x07,
                        0x06,
                        0x05,
                        0x04,
                        0x0c,
                        0x0d,
                        0x0e,
                        0x0f,
                        0x08,
                        0x09,
                        0x0a,
                        0x0b };
#endif

/**********************************************************************/
/* Table to translate Winthorn rops to hardware mix values            */
/**********************************************************************/
#ifdef _8514

BYTE                RopToHWMix[] =     /* 3-way rops and src-dst rops */
                                  {FUNC_S,           /* Why isn't this FUNC_ZEROS? */
                                   FUNC_NS_AND_ND,
                                   FUNC_NS_AND_D,
                                   FUNC_NS,
                                   FUNC_S_AND_ND,
                                   FUNC_ND,
                                   FUNC_S_XOR_D,
                                   FUNC_NS_OR_ND,
                                   FUNC_S_AND_D,
                                   FUNC_S_XNOR_D,
                                   FUNC_D,
                                   FUNC_NS_OR_D,
                                   FUNC_S,
                                   FUNC_S_OR_ND,
                                   FUNC_S_OR_D,
                                   FUNC_S };         /* Why isn't this FUNC_ONES? */
#else /* XGA */

BYTE                RopToHWMix[] =     /* 3-way rops and src-dst rops */
                                  {HWMIX_SOURCE,
                                   HWMIX_NOTSOURCE_AND_NOTDEST,
                                   HWMIX_NOTSOURCE_AND_DEST,
                                   HWMIX_NOTSOURCE,
                                   HWMIX_SOURCE_AND_NOTDEST,
                                   HWMIX_NOTDEST,
                                   HWMIX_SOURCE_XOR_DEST,
                                   HWMIX_NOTSOURCE_OR_NOTDEST,
                                   HWMIX_SOURCE_AND_DEST,
                                   HWMIX_SOURCE_XOR_NOTDEST,
                                   HWMIX_DEST,
                                   HWMIX_NOTSOURCE_OR_DEST,
                                   HWMIX_SOURCE,
                                   HWMIX_SOURCE_OR_NOTDEST,
                                   HWMIX_SOURCE_OR_DEST,
                                   HWMIX_SOURCE };
#endif /* XGA */

/**********************************************************************/
/* variable holding the value to be written into the hardware pixel   */
/* operation register to control the drawing operation                */
/**********************************************************************/
ULONG       PixelOp;

/**********************************************************************/
/* For lines etc.                                                     */
/**********************************************************************/
ULONG       LinePatternCur;
ULONG       LinePatternSys;
ULONG       LinePatternPhys;
#if !(defined(IBMJ) && defined(XGA))                        
USHORT      LinePatternsBitmap[NUM_LINETYPES] = {
                0x0000,                /* default                     */
                0xAAAA,                /* dotted                      */
                0xF0F0,                /* short dashed                */
                0xFAFA,                /* dash dot                    */
                0xD8D8,                /* double dot                  */
                0xFF00,                /* long dash                   */
                0xFCCC,                /* dash, double dot            */
                0xFFFF,                /* solid                       */
                0x0000,                /* invisible                   */
                0xAAAA };              /* dotted (alternate pel)      */
#else                                                       
ULONG       LinePatternsBitmap[NUM_LINETYPES] = {
                0x00000000,            /* default                     */
                0xF0F0F0F0,            /* dotted                      */
                0x00FF00FF,            /* short dashed                */
                0x00FF0FF0,            /* dash dot                    */
                0x0000F0F0,            /* double dot                  */
                0x00FFFFFF,            /* long dash                   */
                0xF0F0F0FF,            /* dash, double dot            */
                0xFFFFFFFF,            /* solid                       */
                0x00000000,            /* invisible                   */
                0xAAAAAAAA };          /* dotted (alternate pel)      */
#endif                                                      
