;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.xlist
;**********************************************************************/
;*                                                                    */
;*   File            = EDDHCONE                                       */
;*                                                                    */
;*   Description     = Display Device Driver Constants                */
;*                                                                    */
;*   Function        =                                                */
;*                                                                    */
;*   Reference       = Device Driver Interface Specification          */
;*                                                                    */
;*                                                                    */
;**********************************************************************/

; Expressway performance code is written in 80386 assembler
.386c

;/**********************************************************************/
;/*  Defect 73462 - The 8514 only has 10 bits to accommodate the line  */
;/*  length.                                                           */
;/**********************************************************************/
ifndef  _8514
  MAX_LINE_LENGTH         equ     0fffh
else
  MAX_LINE_LENGTH         equ     03ffh
endif

;* Expressway guard area
GUARD_MIN_X             equ     -2048
GUARD_MAX_X             equ     6143
GUARD_MIN_Y             equ     -2048
GUARD_MAX_Y             equ     6143

ifdef NEW_PATTERNS
NUMBER_PATTERNS         equ     19
else ; NEW_PATTERNS
NUMBER_PATTERNS         equ     17
endif ; NEW_PATTERNS

IFDEF IBMJ                                                  
  IFDEF XGA                                                 
LINE_PATTERN_LENGTH     equ     32                          
  ELSE 
LINE_PATTERN_LENGTH     equ     16                          
  ENDIF 
ELSE 
LINE_PATTERN_LENGTH     equ     16
ENDIF 

ifdef DBCS                                                  
;---------------------------------------------------------------------;
;  Values for NLSParsingFlag                                          ;
;                                                                     ;
;  NLSCA_SBCS         Use SBCS parsing rule                           ;
;  NLSCA_MBCS         Use MBCS parsing rule                           ;
;  NLSCA_DBCS         Use DBCS parsing rule                           ;
;                                                                     ;
;  NLSCA_CONCAT       Parsing option. The parser will check whether   ;
;                     the last byte of string is DBCS leading byte    ;
;                     or not. If it is, the parser returns with this  ;
;                     bit kept on. In this case, the last byte is     ;
;                     left unprocessed.                               ;
;                                                                     ;
;  NLSCA_MAP_SBCS     SBCS mapping vector available (= CA_MUST_MAP)   ;
;  NLSCA_MAP_DBCS     DBCS mapping vector available                   ;
;---------------------------------------------------------------------;
NLSCA_SBCS              equ     0001h
NLSCA_DBCS              equ     0002h
NLSCA_MBCS              equ     0004h
NLSCA_CONCAT            equ     0008h


NLSCA_MAP_SBCS          equ     0040h
NLSCA_MAP_DBCS          equ     0080h

;---------------------------------------------------------------------;
;  Values for NLSFontFlag                                             ;
;                                                                     ;
;  NLSCA_FONT_SBCS       font is SBCS font                            ;
;  NLSCA_FONT_DBCS       font is DBCS font                            ;
;  NLSCA_FONT_MBCS       font is MBCS font                            ;
;  NLSCA_FONT_DBCS_USED  DBCS portion of font is used                 ;
;  NLSCA_FONT_CACHED     cached font (SBCS characters aren't resident);
;  NLSCA_FONT_HUGE       less than 256 characrters in FM-cache at once;
;---------------------------------------------------------------------;
NLSCA_FONT_SBCS         equ     0001h
NLSCA_FONT_DBCS         equ     0002h
NLSCA_FONT_MBCS         equ     0004h
NLSCA_FONT_DBCS_USED    equ     0008h

NLSCA_FONT_CACHED       equ     0040h
NLSCA_FONT_HUGE         equ     0080h
endif                                                       
