/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDHCONE                                       */
/*                                                                    */
/*   Description     = Expressway performance specific constants      */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* General purpose                                                    */
/**********************************************************************/
#define ON 1
#define OFF 0

/**********************************************************************/
/* maximum number of bitmaps which can be locked concurrently         */
/* maximum number of KBytes which can be locked concurrently          */
/**********************************************************************/
#define NUMBER_OF_LOCKS   8
#define MAX_LOCKED_MEMORY 600

/**********************************************************************/
/* Expressway guard area                                              */
/**********************************************************************/
#define GUARD_MIN_X     -2048
#define GUARD_MAX_X     6143
#define GUARD_MIN_Y     -2048
#define GUARD_MAX_Y     6143

/**********************************************************************/
/* eddefpdb.c                                                         */
/**********************************************************************/
#ifdef NEW_PATTERNS
#define DEFAULT_PATTERNS_SIZE   61
#else /* NEW_PATTERNS */
#define DEFAULT_PATTERNS_SIZE   55
#endif /* NEW_PATTERNS */

#define DITHER_BUFFER_SIZE      4
#define MONO_DITHER_BUFFER_SIZE 8
#define NUM_LINETYPES           10
#if !(defined(IBMJ) && defined(XGA))                        
#define LINE_PATTERNS_SIZE      NUM_LINETYPES * 2
#else 
#define LINE_PATTERNS_SIZE      NUM_LINETYPES * 4
#endif 

/**********************************************************************/
/* eddlpoly.c                                                         */
/**********************************************************************/
#define MAX_STATIC_COORDS 100
#define BRES_BATCH_SIZE 16

#define X_MAJOR 0
#define Y_MAJOR 1

#define YNEG 2
#define XNEG 4
#define YMAJOR 1

#if !(defined(IBMJ) && defined(XGA))                        
#define LINE_PAT_LENGTH 0x10
#else 
#define LINE_PAT_LENGTH 0x20
#endif 

#define RETURN_OK               0x00
#define ERROR_LINE_NOT_DRAWN    0x01

/**********************************************************************/
/*  Defect 73462 - The 8514 only has 10 bits to accommodate the line  */
/*  length.                                                           */
/**********************************************************************/
#ifndef _8514
  #define MAX_LINE_LENGTH         0x0FFF
#else
  #define MAX_LINE_LENGTH         0x03FF
#endif

/**********************************************************************/
/* !!!! These must be 1 and 2 !!! They are not arbitary constants !!! */
/**********************************************************************/
#define POLYLINE_CALL   1
#define DISJOINT_CALL   2

#define POLYLINE_DEFAULT STEP_FN_LINE_DRAW_WRITE | \
                         DST_PIX_MAP_A | \
                         PAT_PIX_MAP_FORE | \
                         MASK_PIX_MAP_EDGE

#define NEITHER_STEP 0
#define BOTH_STEP 1
#define MAJOR_STEP 2

#define MAX_RUN_LENGTH 15
#define RUN_BATCH_SIZE 16

/**********************************************************************/
/* values for type of bitmap locking                                  */
/**********************************************************************/
#define BMLOCK_LONG  1
#define BMLOCK_SHORT 0

/**********************************************************************/
/* cursors sizes                                                      */
/**********************************************************************/
#define HIGHRESCURSORWIDTH  40
#define HIGHRESCURSORHEIGHT 40
#define LOWRESCURSORWIDTH   32
#define LOWRESCURSORHEIGHT  32

#define SIZEOFANDMASK      (DDT.CursorHeight * DDT.CursorWidth / 8)
#define SIZEOFCURSORBITMAP (SIZEOFANDMASK * DDT.BitCount)

#define SYS_CHAR_CACHE_SIZE     65536
