;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page ,132
;***********************************************************************
;
;   Module          = EDDHAVIO.INC
;
;   Description     = External/Internal Functions, structures,
;                     constants used for AVIO AI routines
;
;   Function        =
;
;   Notes           =
;       This INC file is created based on EDDHAVIO.ASM SBCS
;       version. To make more efficient to maintenance modules,
;       this ASM file has been devided into several files.
;
;
;
;
;    History        =
;
;   Change log:
;   Date      Mark         APAR      Description
;   --------  ------------ --------- -----------------------------------
;
;***********************************************************************


;------------------------------------------------------------------------------;
; External access for this module                                              ;
;------------------------------------------------------------------------------;

ifdef MATROX
extrn _ShadowXGARegs    :dword
; The movxga macro in slightly inappropriate here, so we redefine it as
; the simplest way of doing things.
movxga  macro   address
        lea     esi, _ShadowXGARegs
        endm
endif ; MATROX

AIxfer equ <_AIxfer>

ifndef _8514
extrn _pRealXGARegs     :dword
else 
extrn _pReal8514Regs    :dword                              
extrn _Shadow8514Regs   :dword
ifdef BPP24
extrn _CouldntCache    :dword
;; extrn _Copy24MonoToVRAM    :NEAR
extrn _Copy24MonoToVRAM         :PROC
endif
extrn _DDT              :byte
endif ; _8514
extrn AIxfer            :dword
extrn _pAVIOColorXlate  :dword
extrn _SPad             :dword
extrn _pCurCacheBasePhy :dword
extrn _pbHWPollRegister :dword

ifdef DBCS                                                  
extrn _pFontCacheInfo   :dword
extrn  _AvioForceCharInCache    :PROC
endif 

extrn  _eddt_CacheCharacter     :PROC
extrn  _eddt_LocateCachedFont   :PROC
extrn  _eddt_TidyUpAfterCaching :PROC

;------------------------------------------------------------------------------;
; Constants                                                                    ;
;------------------------------------------------------------------------------;

; Avio exteneded attribute masks
MFI_REV_VIDEO    equ 00400000h
MFI_TRANSPARENT  equ 00100000h
MFI_USCORE       equ 00800000h
;MFI_OSTRIKE     equ 00200000h  ; Austin now use this bit for something else
                                ; so we now need MFI_OSTRIKE to be 0
MFI_OSTRIKE     equ 00000000h

MFI_FONTBITS    equ 03h         ; Mask for font bits (after shifting)

MFI_CHARMASK    equ 000300ffh   ; Mask to remove attributes

OVERPAINT       equ 03h
LEAVE_ALONE     equ 05h
INVERT_DEST     equ 0Ah

AVIO_usblt      equ 08018040h

ifdef DBCS                                                  
ifndef INCL_PMAVIOP
DBCSEvBufSiz    equ       10    ; size in bytes of DBCS Env Vectors
                                ; This is defined in pmaviop.inc, but
                                ; this module doesn't include it, so we
                                ; define here.
endif ; INCL_PMAVIOP

AVIO_NoMaskCharBlt      equ     08012000h
AVIO_MaskCharBlt        equ     08012040h
AVIO_usblt      equ 08018040h
AVIO_vgblt      equ 08018040h
AVIO_hgblt      equ 08018040h

DBCS_SURROGATEMASK  equ 0fffcff00h ; Mask to remove codepoint,lcid
DBCS_CHARMASK   equ 000000ffh   ; Mask to remove attributes
DBCS_CPMASK     equ 0000ffffh   ; Mask for DBCS codepoint
DBCS_FONTMASK   equ 00030000h   ; Mask for font bits
DBCS_DBIT4      equ 01000000h
DBCS_DTBIT4     equ 80000000h
DBCS_DBIT2      equ 00000100h
DBCS_DTBIT2     equ 00000200h
DBCS_HGRID4     equ 00040000h
DBCS_VGRID4     equ 00080000h
DBCS_HGRID2     equ 00002000h
DBCS_VGRID2     equ 00001000h
DBCS_USCORE     equ 00004000h
EPOCH_NO_RED    equ       08h
EPOCH_NO_GREEN  equ       40h
EPOCH_NO_BLUE   equ       80h
EPOCH_REV_VIDEO equ 00000400h
EPOCH_INTENSITY equ 00000800h
EPOCH_INVISIBLE equ 0000CC00h
EPOCH_PHYSHILIGHTED  equ 0000CC00h
endif 


;------------------------------------------------------------------------------;
; Parameter block                                                              ;
;------------------------------------------------------------------------------;

AVIOPB          struc
bColumn             db      ?
bRow                db      ?
bAcross             db      ?
bDown               db      ?
pLVBChars           dd      ?
ifdef DBCS                                                  
pLVBFirst           dd      ?
pLVBLast            dd      ?
endif   
bBufferWidth        db      ?
bSourceColumn       db      ?
bSourceRow          db      ?
bDestColumn         db      ?
bDestRow            db      ?
cClipRects          dw      ?
pFirstClipRect      dd      ?
pCurrentClipRect    dd      ?
usCursorX           dw      ?
usCursorY           dw      ?
usCursorH           dw      ?
usCursorL           dw      ?
pbmhDest            dd      ?
;------------------------------------------------------------------------------;
; These next fields are not present in the C version of this structure         ;
; and should really be local variables rather than in this block               ;
;------------------------------------------------------------------------------;
bFGIndex            db      ?           ; these are VIO indices - ie 0 -> 15
bBGIndex            db      ?           ;    "
sXPosition          dw      ?           ; designated SHORT but may be unsigned ?
sYPosition          dw      ?           ;    "
sRowPosition        dw      ?           ;    "
usXSource           dw      ?
usYSource           dw      ?
usXDest             dw      ?
usYDest             dw      ?
ifdef DBCS                                                  
usFirstRowYAddr     dw      ?
usFirstRowDim2      dw      ?
usNextRowDim2       dw      ?
usLastRowDim2       dw      ?
bClppdRow           db      ?
bClppdColumn        db      ?
bClppdERow          db      ?
bClppdEColumn       db      ?
bNumOfRow           db      ?
bNumOfColumn        db      ?
endif 
AVIOPB          ends

;------------------------------------------------------------------------------;
; Constants and structures for managing Avio Fonts                             ;
;------------------------------------------------------------------------------;

MAX_NUM_CODEPOINTS      equ   256

ifdef DBCS                                                  
MAX_NUM_DBCODEPOINTS    equ 256        ; limit of DBCS char in cache
MAX_TOTAL_CODEPOINTS    equ MAX_NUM_CODEPOINTS + MAX_NUM_DBCODEPOINTS

FcCharDef               struc
fccd_aspace             DW      ?      ; A space for ABC font
fccd_bspace             DW      ?      ; B
fccd_cspace             DW      ?      ; C
FcCharDef               ends

fccd_width              equ     fccd_aspace
                                       ; width field for non-ABC font
endif 

FontCacheInfo           struc
fci_fmFontMetrics         DB      SIZE FOCAMETRICS DUP (?)
fci_usHashMetrics         DW      (?)
fci_usUsageCount          DW      (?)
fci_usFontId              DW      (?)
fci_usCodePage            DW      (?)

ifndef DBCS                                                 
fci_aulCachedCharOffset   DD      MAX_NUM_CODEPOINTS DUP (?)
ifdef   FULL_ADDRESS
fci_apCharDef             DD      MAX_NUM_CODEPOINTS DUP (?)
else  ; FULL_ADDRESS
fci_apCharDef             DW      MAX_NUM_CODEPOINTS DUP (?)
endif ; FULL_ADDRESS
ifdef  _8514                                                
fci_ausFontPlaneOffset    DW      MAX_NUM_CODEPOINTS DUP (?)    
endif 
else
fci_aulCachedCharOffset   DD      MAX_TOTAL_CODEPOINTS DUP (?)

ifdef BPP24                                                 
ifdef   FULL_ADDRESS
fci_apCharDef             DD      MAX_TOTAL_CODEPOINTS DUP (?)
else ;  FULL_ADDRESS
fci_apCharDef             DW      MAX_TOTAL_CODEPOINTS DUP (?)
endif ; FULL_ADDRESS
endif 

fci_aCharDef    DB       (type FcCharDef)*MAX_TOTAL_CODEPOINTS DUP (?)
fci_aCharOffset           DD      MAX_TOTAL_CODEPOINTS DUP (?)  
ifdef  _8514                                                
fci_ausFontPlaneOffset    DW      MAX_TOTAL_CODEPOINTS DUP (?)  
endif 
fci_usDBGITableBottom     DW      ?    ; fields for DBCS cache mgt
fci_usDBGITableNext       DW      ?    ; 
fci_ausDBGIndexTable      DW      MAX_NUM_DBCODEPOINTS + 1 DUP (?)
fci_usFirstGlyph          DW      ?
fci_usLastGlyphOffset     DW      ?
fci_usDefGlyphOffset      DW      ?
endif 
FontCacheInfo           ends

;------------------------------------------------------------------------------;
; Scratch pad block                                                            ;
;------------------------------------------------------------------------------;

AVIOSP          struc
clipx0          dw      ?
clipx1          dw      ?
clipy0          dw      ?
clipy1          dw      ?
fontnum         db      ?
currfontbase    dd      ?
unlockcount     dw      ?
unlockhandle    dd      ?
lockcount       dw      ?
lockpointer     dd      ?
lockheader      dd      ?
AVIOSP          ends


