/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDFMESS                                       */
/*                                                                    */
/*   Description     = MESS code                                      */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DDIMISC
#include <eddinclt.h>

#include <eddhcone.h>
#include <eddfcone.h>

#include <eddhtype.h>
#include <eddftype.h>

#ifdef   _8514
#include <8514.h>
#endif


/**********************************************************************/
/* Function prototypes                                                */
/**********************************************************************/
VOID PASCAL FAR eddf_MESS(VOID);

VOID PASCAL NEAR eddf_MESSDoBresenham_old(VOID) ;
VOID PASCAL NEAR eddf_MESSDoPlotStep(VOID) ;
VOID PASCAL NEAR eddf_MESSDoBitblt(VOID) ;

VOID PASCAL NEAR eddf_MESSMixPel(VOID) ;

/**********************************************************************/
/* Macros for this file..                                             */
/**********************************************************************/
#ifndef   _8514
#define eddf_mIncPatternLine \
    if (ShadowXGARegs.PatXAddr < patPixmap.xLen) \
    { \
        ShadowXGARegs.PatXAddr++ ; \
    } \
    else \
    { \
        ShadowXGARegs.PatXAddr = 0 ; \
    }
#else
#define eddf_mIncPatternLine \
    if (Shadow8514Regs.PatXAddr < patPixmap.xLen) \
    { \
        Shadow8514Regs.PatXAddr++ ; \
    } \
    else \
    { \
        Shadow8514Regs.PatXAddr = 0 ; \
    }
#endif

#define eddf_mWrapUpdate(var, max, inc) \
    var += (inc) ; \
    if (var >= max) \
    { \
        var = 0 ; \
    } \
    else if (var < 0) \
    { \
        var = (max)-1 ; \
    }

#define eddf_mGetPel1(xPos, yPos, xLen, startAddr, pel) \
    { \
        long    tmp1=(yPos)*(xLen)+(xPos) ; \
        pel = (*((startAddr) + tmp1/8) >> (7-tmp1%8)) & 0x01 ; \
    }

#define eddf_mGetPel4(xPos, yPos, xLen, startAddr, pel) \
    { \
        long    tmp1=(yPos)*(xLen)+(xPos) ; \
        pel = (*((startAddr) + tmp1/2) >> (4*(1-tmp1%2))) & 0x0F ; \
    }

#define eddf_mGetPel8(xPos, yPos, xLen, startAddr, pel) \
    { \
        pel = *((startAddr) + (yPos)*(xLen)+(xPos)) ; \
    }

#define eddf_mGetPelAny(xPos, yPos, xLen, startAddr, format, pel) \
    { \
        if ((format)&2) \
        { \
            if ((format)&1) \
            { \
                eddf_mGetPel8(xPos, yPos, xLen, startAddr, pel) \
            } \
            else \
            { \
                eddf_mGetPel4(xPos, yPos, xLen, startAddr, pel) \
            } \
        } \
        else \
        { \
            eddf_mGetPel1(xPos, yPos, xLen, startAddr, pel) \
        } \
    }


#define eddf_mSetPel1(xPos, yPos, xLen, startAddr, pel) \
    { \
        LONG    tmp1=(LONG)(yPos)*(LONG)(xLen)+(LONG)(xPos) ; \
        SHORT   tmp2=7-tmp1%8 ; \
        *((startAddr) + tmp1/8) &= ~(0x01 << tmp2) ; \
        *((startAddr) + tmp1/8) |= (pel) << tmp2 ; \
    }

#define eddf_mSetPel4(xPos, yPos, xLen, startAddr, pel) \
    { \
        LONG    tmp1=(LONG)(yPos)*(LONG)(xLen)+(LONG)(xPos) ; \
        SHORT   tmp2=4*(1-tmp1%2) ; \
        *((startAddr) + tmp1/2) &= ~(0x0f << tmp2) ; \
        *((startAddr) + tmp1/2) |= (pel) << tmp2 ; \
    }

#define eddf_mSetPel8(xPos, yPos, xLen, startAddr, pel) \
    { \
        *((startAddr) + (yPos)*(xLen)+(xPos)) = pel ; \
    }

#define eddf_mSetPelAny(xPos, yPos, xLen, startAddr, format, pel) \
    { \
        if ((format)&2) \
        { \
            if ((format)&1) \
            { \
                eddf_mSetPel8(xPos, yPos, xLen, startAddr, pel) \
            } \
            else \
            { \
                eddf_mSetPel4(xPos, yPos, xLen, startAddr, pel) \
            } \
        } \
        else \
        { \
            eddf_mSetPel1(xPos, yPos, xLen, startAddr, pel) \
        } \
    }

/**********************************************************************/
/* Externals..                                                        */
/**********************************************************************/
extern BresStep                 BresSteps[] ;
extern DevPoint                 MESSPlotStepTable[] ;
extern SHORT                    mixTypeTable[] ;


/**********************************************************************/
/* Globals..                                                          */
/*                                                                    */
/* ShadowXGARegs                                                           */
/* This is the piece of memory used as a parameter block for          */
/* software drawing.                                                  */
/*                                                                    */
/* srcPixmap, dstPixmap, patPixmap, mskPixmap                         */
/* These hold the parameters for the various pixmaps after extracting */
/* them from the Pixel Operations register and the parameter block.   */
/**********************************************************************/
#ifndef   _8514
MMReg                   ShadowXGARegs ;
#else
MM8514Reg               Shadow8514Regs ;
#endif
MESSPixMapDescription   srcPixmap ;
MESSPixMapDescription   dstPixmap ;
MESSPixMapDescription   patPixmap ;
MESSPixMapDescription   mskPixmap ;

#ifdef OMIT
VOID PASCAL FAR eddf_MESS(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/

    /******************************************************************/
    /* Set up the dstPixmap structure                                 */
    /* Dst pixmap field is in high word so adjust for switch          */
    /* There must be a destination.                                   */
    /******************************************************************/
    switch ((SHORT)((ShadowXGARegs.PixOp & DST_PIX_MAP_MASK)>>16))
    {
        case DST_PIX_MAP_A>>16:

            dstPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseA ;
            dstPixmap.xLen = ShadowXGARegs.PixMapWidthA ;
            dstPixmap.yLen = ShadowXGARegs.PixMapHeightA ;
            dstPixmap.format = ShadowXGARegs.PixMapFormatA ;
            break ;

        case DST_PIX_MAP_B>>16:
            dstPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseB ;
            dstPixmap.xLen = ShadowXGARegs.PixMapWidthB ;
            dstPixmap.yLen = ShadowXGARegs.PixMapHeightB ;
            dstPixmap.format = ShadowXGARegs.PixMapFormatB ;
            break ;

        case DST_PIX_MAP_C>>16:
            dstPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseC ;
            dstPixmap.xLen = ShadowXGARegs.PixMapWidthC ;
            dstPixmap.yLen = ShadowXGARegs.PixMapHeightC ;
            dstPixmap.format = ShadowXGARegs.PixMapFormatC ;
            break ;

        default:
            /**********************************************************/
            /* This is a terminal error - what shall we do            */
            /**********************************************************/
            return ;
    }

    dstPixmap.xStartPos = ShadowXGARegs.DstXAddr ;
    dstPixmap.bitsPerPel = 0x01 << (dstPixmap.format & 0x07) ;

    /******************************************************************/
    /* Check whether a source is required.                            */
    /* Note that this does not check for source as pattern mode as    */
    /* the driver doesn't use that.                                   */
    /******************************************************************/
    if (((ShadowXGARegs.PixOp & BACK_SRC_MASK) == BACK_SRC_SRC_PIX_MAP) ||
        ((ShadowXGARegs.PixOp & FORE_SRC_MASK) == FORE_SRC_SRC_PIX_MAP))
    {
        /**************************************************************/
        /* There is a src being used so set it up.                    */
        /* Src pixmap field is in high word so adjust for switch      */
        /**************************************************************/
        switch ((SHORT)((ShadowXGARegs.PixOp & SRC_PIX_MAP_MASK)>>16))
        {
            case SRC_PIX_MAP_A>>16:
                srcPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseA ;
                srcPixmap.xLen = ShadowXGARegs.PixMapWidthA ;
                srcPixmap.yLen = ShadowXGARegs.PixMapHeightA ;
                srcPixmap.format = ShadowXGARegs.PixMapFormatA ;
                break ;

            case SRC_PIX_MAP_B>>16:
                srcPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseB ;
                srcPixmap.xLen = ShadowXGARegs.PixMapWidthB ;
                srcPixmap.yLen = ShadowXGARegs.PixMapHeightB ;
                srcPixmap.format = ShadowXGARegs.PixMapFormatB ;
                break ;

            case SRC_PIX_MAP_C>>16:
                srcPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseC ;
                srcPixmap.xLen = ShadowXGARegs.PixMapWidthC ;
                srcPixmap.yLen = ShadowXGARegs.PixMapHeightC ;
                srcPixmap.format = ShadowXGARegs.PixMapFormatC ;
                break ;

            default:
                /******************************************************/
                /* This is a terminal error - what shall we do        */
                /******************************************************/
                return ;
        }

        /**************************************************************/
        /* Set up the flag to tell rest of routines whether there is  */
        /* a source...                                                */
        /**************************************************************/
        srcPixmap.isUsed = TRUE ;
        srcPixmap.xStartPos = ShadowXGARegs.SrcXAddr ;
        srcPixmap.bitsPerPel = 0x01 << (srcPixmap.format & 0x07) ;
    }
    else
    {
        /**************************************************************/
        /* ...or not as the case may be.                              */
        /**************************************************************/
        srcPixmap.isUsed = FALSE ;
    }

    /******************************************************************/
    /* Check if a pattern is being used                               */
    /******************************************************************/
    if ((ShadowXGARegs.PixOp & PAT_PIX_MAP_MASK) != PAT_PIX_MAP_FORE)
    {
        /**************************************************************/
        /* There is a source (or at least, the pattern is not fixed   */
        /* to the foreground - if we're being picky we should maybe   */
        /* test that one of the three pixmaps is selected).           */
        /**************************************************************/
        switch ((SHORT)(ShadowXGARegs.PixOp & PAT_PIX_MAP_MASK))
        {
            case PAT_PIX_MAP_A:
                patPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseA ;
                patPixmap.xLen = ShadowXGARegs.PixMapWidthA ;
                patPixmap.yLen = ShadowXGARegs.PixMapHeightA ;
                patPixmap.format = ShadowXGARegs.PixMapFormatA ;
                break ;

            case PAT_PIX_MAP_B:
                patPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseB ;
                patPixmap.xLen = ShadowXGARegs.PixMapWidthB ;
                patPixmap.yLen = ShadowXGARegs.PixMapHeightB ;
                patPixmap.format = ShadowXGARegs.PixMapFormatB ;
                break ;

            case PAT_PIX_MAP_C:
                patPixmap.startAddr = (PBYTE)ShadowXGARegs.PixMapBaseC ;
                patPixmap.xLen = ShadowXGARegs.PixMapWidthC ;
                patPixmap.yLen = ShadowXGARegs.PixMapHeightC ;
                patPixmap.format = ShadowXGARegs.PixMapFormatC ;
                break ;

            default:
                /******************************************************/
                /* Here, this may be acceptable if generated from     */
                /* source is used.  The driver doesn't use this so    */
                /* we will return - its an error.                     */
                /******************************************************/
                return ;
        }

        /**************************************************************/
        /* Set up the flag to tell rest of routines whether there is  */
        /* a pattern...                                               */
        /**************************************************************/
        patPixmap.isUsed = TRUE ;
        patPixmap.xStartPos = ShadowXGARegs.PatXAddr ;
        patPixmap.yStartPos = ShadowXGARegs.PatYAddr ;
        patPixmap.bitsPerPel = 0x01 << (patPixmap.format & 0x07) ;
    }
    else
    {
        /**************************************************************/
        /* ...or not as the case may be.                              */
        /**************************************************************/
        patPixmap.isUsed = FALSE ;
    }

    /******************************************************************/
    /* If boundary clipping is on then set up mask map                */
    /******************************************************************/
    if ((ShadowXGARegs.PixOp & MSK_PIX_MAP_MASK) == MASK_PIX_MAP_EDGE)
    {
        /**************************************************************/
        /* Boundary clipping is enabled so set mskPixmap...           */
        /**************************************************************/
        mskPixmap.xLen = ShadowXGARegs.PixMapWidthM ;
        mskPixmap.yLen = ShadowXGARegs.PixMapHeightM ;
        mskPixmap.isUsed = TRUE ;
    }
    else
    {
        /**************************************************************/
        /* ...or otherwise                                            */
        /**************************************************************/
        mskPixmap.isUsed = FALSE ;
    }


    /******************************************************************/
    /* The dst/src/pat/msk pixmap parameters are now set up so        */
    /* call off to the appropriate rendering routine.                 */
    /* Step function field is in hi word so allow for switch.         */
    /******************************************************************/
    switch ((SHORT)((ShadowXGARegs.PixOp & STEP_FN_MASK)>>16))
    {
        case STEP_FN_LINE_DRAW_WRITE>>16:
            eddf_MESSDoBresenham() ;
            break ;

        case STEP_FN_DRAW_AND_STEP_WRITE>>16:
            eddf_MESSDoPlotStep() ;
            break ;

        case STEP_FN_PXBLT>>16:
            eddf_MESSDoBitblt() ;
            break ;

        default:
            /**********************************************************/
            /* One of the functions which is not emulated has been    */
            /* called - this is a grave error                         */
            /**********************************************************/
            return ;
    }

    /******************************************************************/
    /* Rendering function has returned - do any tidying up and exit   */
    /******************************************************************/

    /******************************************************************/
    /* Restore the registers saved on entry                           */
    /******************************************************************/
/*  eddf_RESTORE_REGS() ;   */

    return ;
}


/**********************************************************************/
/* The bresenham rendering routine                                    */
/* Note that bresenham is not used with a source so this does not     */
/* handle source - only pattern.                                      */
/**********************************************************************/
VOID PASCAL NEAR eddf_MESSDoBresenham_old(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    SHORT       direction ;
    DevPoint    bothStep ;
    DevPoint    majorStep ;
    SHORT       pelsToDo ;
    SHORT       drawLoop ;


    /******************************************************************/
    /* Get offsets (+/- 1) for doing the steps depending on the       */
    /* octant we're in.                                               */
    /******************************************************************/
    direction = (SHORT)ShadowXGARegs.PixOp & DIR_OCT_MASK ;
    bothStep = BresSteps[direction].Both ;
    majorStep = BresSteps[direction].Major ;

    /******************************************************************/
    /* Handle first pel null case                                     */
    /******************************************************************/
    if ((ShadowXGARegs.PixOp & DRAW_MODE_MASK) == DRAW_MODE_NO_FIRST_PEL)
    {
        /**************************************************************/
        /* Take one step along the line without doing anything        */
        /**************************************************************/
        if (ShadowXGARegs.BresErrTerm >= 0)
        {
            ShadowXGARegs.DstXAddr += bothStep.X ;
            ShadowXGARegs.DstYAddr += bothStep.Y ;
            ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK2 ;
        }
        else
        {
            ShadowXGARegs.DstXAddr += majorStep.X ;
            ShadowXGARegs.DstYAddr += majorStep.Y ;
            ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK1 ;
        }

        /**************************************************************/
        /* Lines are drawn using OpDim1 for their length              */
        /**************************************************************/
        ShadowXGARegs.OpDim1 -= 1 ;

        if (patPixmap.isUsed == TRUE)
        {
            /**********************************************************/
            /* Update the pattern position                            */
            /* (this is a macro!)                                     */
            /**********************************************************/
            eddf_mIncPatternLine
        }
    }

    /******************************************************************/
    /* Now do the rest of the line                                    */
    /******************************************************************/
    pelsToDo = ShadowXGARegs.OpDim1 ;

    if (pelsToDo < 0)
    {
        /**************************************************************/
        /* That was a short line wasn't it!  Exit for a one pel line  */
        /* with first pel null.                                       */
        /**************************************************************/
        return ;
    }

    if ((ShadowXGARegs.PixOp & DRAW_MODE_MASK) == DRAW_MODE_NO_LAST_PEL)
    {
        /**************************************************************/
        /* Decrease the pel count by one to allow for this (but note  */
        /* that we will have to allow for this in the positions after */
        /* the line has been drawn)                                   */
        /**************************************************************/
        pelsToDo -= 1 ;

        if (pelsToDo < 0)
        {
            /**********************************************************/
            /* This is another very short line!  Exit for a one pel   */
            /* line with last pel null.  But, remember that we need   */
            /* to update positions first.                             */
            /**********************************************************/
            if (ShadowXGARegs.BresErrTerm >= 0)
            {
                ShadowXGARegs.DstXAddr += bothStep.X ;
                ShadowXGARegs.DstYAddr += bothStep.Y ;
                ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK2 ;
            }
            else
            {
                ShadowXGARegs.DstXAddr += majorStep.X ;
                ShadowXGARegs.DstYAddr += majorStep.Y ;
                ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK1 ;
            }

            if (patPixmap.isUsed == TRUE)
            {
                /**********************************************************/
                /* Update the pattern position                            */
                /**********************************************************/
                eddf_mIncPatternLine
            }

            return ;
        }
    }

    /******************************************************************/
    /* OK, pelsToDo is at least 0 (which indicates one more pel to    */
    /* draw) so go into a loop to draw the line.                      */
    /******************************************************************/
    for (drawLoop = pelsToDo+1 ; drawLoop-- ; )
    {
        /**************************************************************/
        /* Mix this pel..                                             */
        /**************************************************************/
        eddf_MESSMixPel() ;

        /**************************************************************/
        /* Take a step unless that was the last pel                   */
        /**************************************************************/
        if (drawLoop != 0)
        {
            if (ShadowXGARegs.BresErrTerm >= 0)
            {
                ShadowXGARegs.DstXAddr += bothStep.X ;
                ShadowXGARegs.DstYAddr += bothStep.Y ;
                ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK2 ;
            }
            else
            {
                ShadowXGARegs.DstXAddr += majorStep.X ;
                ShadowXGARegs.DstYAddr += majorStep.Y ;
                ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK1 ;
            }

            if (patPixmap.isUsed == TRUE)
            {
                /*******************************************************/
                /* Update the pattern position                         */
                /*******************************************************/
                eddf_mIncPatternLine
            }
        }
    }

    /******************************************************************/
    /* OK, all pels mixed now sort out last pel status.               */
    /******************************************************************/
    if ((ShadowXGARegs.PixOp & DRAW_MODE_MASK) == DRAW_MODE_NO_LAST_PEL)
    {
        /**************************************************************/
        /* This is a last pel null line so we need to update the      */
        /* dst position and the pattern position.                     */
        /**************************************************************/
        if (ShadowXGARegs.BresErrTerm >= 0)
        {
            ShadowXGARegs.DstXAddr += bothStep.X ;
            ShadowXGARegs.DstYAddr += bothStep.Y ;
            ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK2 ;
        }
        else
        {
            ShadowXGARegs.DstXAddr += majorStep.X ;
            ShadowXGARegs.DstYAddr += majorStep.Y ;
            ShadowXGARegs.BresErrTerm += ShadowXGARegs.BresK1 ;
        }

        if (patPixmap.isUsed == TRUE)
        {
            /**********************************************************/
            /* Update the pattern position                            */
            /**********************************************************/
            eddf_mIncPatternLine
        }
    }
}

#endif /* OMIT */


/**********************************************************************/
/* The plotstep rendering routine                                     */
/**********************************************************************/
VOID PASCAL NEAR eddf_MESSDoPlotStep(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    #ifndef _8514
    PBYTE       drawCodes = (PBYTE)(&ShadowXGARegs.DirSteps) ;
    #else
    PBYTE       drawCodes = (PBYTE)(&Shadow8514Regs.ShortStroke) ;
    #endif
    DevPoint    steps ;
    BYTE        code ;
    SHORT       direction ;
    SHORT       pelsToDo ;
    SHORT       drawLoop ;

    /******************************************************************/
    /* Until we've done all the draw codes or we get a null code      */
    /* which is the end code.  (the 'fifth' code will always be null  */
    /* - see death function)                                          */
    /******************************************************************/
    while ((code = *drawCodes++) != 0)
    {
        /**************************************************************/
        /* Get the direction index and count of pels from the code.   */
        /**************************************************************/
        direction = (code & PLOT_STEP_DIR_MASK) >> 5 ;
        pelsToDo = code & PLOT_STEP_COUNT_MASK ;

        /**************************************************************/
        /* Get offsets (+/- 1) for the direction.                     */
        /**************************************************************/
        steps = MESSPlotStepTable[direction] ;

        /**************************************************************/
        /* Handle first pel null mode                                 */
        /**************************************************************/
        #ifndef   _8514
        if ((ShadowXGARegs.PixOp & DRAW_MODE_MASK) == DRAW_MODE_NO_FIRST_PEL)
        {
            pelsToDo-- ;
            if (pelsToDo < 0)
            {
                /******************************************************/
                /* That was a short plot step - don't update          */
                /* positions, just return.                            */
                /******************************************************/
                return ;
            }

            /**********************************************************/
            /* Take a step to omit the first position                 */
            /**********************************************************/
            ShadowXGARegs.DstXAddr += steps.X ;
            ShadowXGARegs.DstYAddr += steps.Y ;

            if (patPixmap.isUsed == TRUE)
            {
                /******************************************************/
                /* Update the pattern position                        */
                /******************************************************/
                eddf_mIncPatternLine
            }
        }

        /**************************************************************/
        /* Now do the rest of the pels - we can do this with by       */
        /* stepping and plotting and remembering not to plot the last */
        /* pel if appropriate.                                        */
        /**************************************************************/
        for ( drawLoop = pelsToDo+1 ; drawLoop-- ; )
        {
            if ((drawLoop != 0) ||
                ((ShadowXGARegs.PixOp & DRAW_MODE_MASK) !=
                                             DRAW_MODE_NO_LAST_PEL))
            {
                /******************************************************/
                /* This pel must be mixed                             */
                /******************************************************/
                eddf_MESSMixPel() ;
            }

            if (drawLoop != 0)
            {
                /******************************************************/
                /* That wasn't the last pel so take a step.           */
                /******************************************************/
                ShadowXGARegs.DstXAddr += steps.X ;
                ShadowXGARegs.DstYAddr += steps.Y ;

                if (patPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Update the pattern position                    */
                    /**************************************************/
                    eddf_mIncPatternLine
                }
            }
        }
        #else
        if ((Shadow8514Regs.PixOp & DRAW_MODE_MASK) == DRAW_MODE_NO_FIRST_PEL)
        {
            pelsToDo-- ;
            if (pelsToDo < 0)
            {
                /******************************************************/
                /* That was a short plot step - don't update          */
                /* positions, just return.                            */
                /******************************************************/
                return ;
            }

            /**********************************************************/
            /* Take a step to omit the first position                 */
            /**********************************************************/
            Shadow8514Regs.DstXAddr += steps.X ;
            Shadow8514Regs.DstYAddr += steps.Y ;

            if (patPixmap.isUsed == TRUE)
            {
                /******************************************************/
                /* Update the pattern position                        */
                /******************************************************/
                eddf_mIncPatternLine
            }
        }

        /**************************************************************/
        /* Now do the rest of the pels - we can do this with by       */
        /* stepping and plotting and remembering not to plot the last */
        /* pel if appropriate.                                        */
        /**************************************************************/
        for ( drawLoop = pelsToDo+1 ; drawLoop-- ; )
        {
            if ((drawLoop != 0) ||
                ((Shadow8514Regs.PixOp & DRAW_MODE_MASK) !=
                                             DRAW_MODE_NO_LAST_PEL))
            {
                /******************************************************/
                /* This pel must be mixed                             */
                /******************************************************/
                eddf_MESSMixPel() ;
            }

            if (drawLoop != 0)
            {
                /******************************************************/
                /* That wasn't the last pel so take a step.           */
                /******************************************************/
                Shadow8514Regs.DstXAddr += steps.X ;
                Shadow8514Regs.DstYAddr += steps.Y ;

                if (patPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Update the pattern position                    */
                    /**************************************************/
                    eddf_mIncPatternLine
                }
            }
        }
        #endif

    }
}


#ifdef OMIT

/**********************************************************************/
/* The bitblt rendering routine                                       */
/**********************************************************************/
VOID PASCAL NEAR eddf_MESSDoBitblt(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    SHORT       linesLoop ;
    SHORT       pelsLoop ;
    SHORT       horizInc = 1 ;
    SHORT       vertInc = 1 ;

    /******************************************************************/
    /* Determine which direction the blt is in..                      */
    /* (Default is top left to bottom right)                          */
    /******************************************************************/
    if (ShadowXGARegs.PixOp & BLTDIR_RIGHTTOLEFT)
    {
        horizInc = -1 ;
    }

    if (ShadowXGARegs.PixOp & BLTDIR_BOTTOMTOTOP)
    {
        vertInc = -1 ;
    }

    /******************************************************************/
    /* Loop through every pel in the bitblt                           */
    /******************************************************************/
    for ( linesLoop=ShadowXGARegs.OpDim2+1 ; linesLoop-- ; )
    {
        for ( pelsLoop=ShadowXGARegs.OpDim1+1 ; pelsLoop-- ; )
        {
            eddf_MESSMixPel() ;

            /**********************************************************/
            /* Update positions horizontally..                        */
            /**********************************************************/
            ShadowXGARegs.DstXAddr += horizInc ;

            if (srcPixmap.isUsed == TRUE)
            {
                eddf_mWrapUpdate(ShadowXGARegs.SrcXAddr, srcPixmap.xLen+1,
                                 horizInc)
            }

            if (patPixmap.isUsed == TRUE)
            {
                eddf_mWrapUpdate(ShadowXGARegs.PatXAddr, patPixmap.xLen+1,
                                 horizInc)
            }
        }

        /**************************************************************/
        /* Update positions vertically and reset horizontal positions */
        /**************************************************************/
        ShadowXGARegs.DstYAddr += vertInc ;
        ShadowXGARegs.DstXAddr = dstPixmap.xStartPos ;

        if (srcPixmap.isUsed == TRUE)
        {
            eddf_mWrapUpdate(ShadowXGARegs.SrcYAddr, srcPixmap.yLen+1, vertInc)

            ShadowXGARegs.SrcXAddr = srcPixmap.xStartPos ;
        }

        if (patPixmap.isUsed == TRUE)
        {
            eddf_mWrapUpdate(ShadowXGARegs.PatYAddr, patPixmap.yLen+1, vertInc)

            ShadowXGARegs.PatXAddr = patPixmap.xStartPos ;
        }
    }
}

#endif /* OMIT */

/**********************************************************************/
/* Pixel mixing routine..                                             */
/**********************************************************************/
VOID PASCAL NEAR eddf_MESSMixPel(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    BYTE        srcPel ;
    BYTE        dstPel ;
    BYTE        patPel ;
    SHORT       mixToUse ;
    SHORT       mixType ;

    #ifndef   _8514
    if ((ShadowXGARegs.DstXAddr < 0) ||
        (ShadowXGARegs.DstXAddr > dstPixmap.xLen) ||
        (ShadowXGARegs.DstYAddr < 0) ||
        (ShadowXGARegs.DstYAddr > dstPixmap.yLen))
    {
        /**************************************************************/
        /* Pel is outside destination bitmap - destination scissor    */
        /* excludes it so just return.                                */
        /**************************************************************/
        return ;
    }

    if (mskPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* The boundary scissor is being used so clip pel to that..   */
        /**************************************************************/
        if ((ShadowXGARegs.DstXAddr < ShadowXGARegs.MaskXOffset) ||
            (ShadowXGARegs.DstXAddr >
                             (ShadowXGARegs.MaskXOffset + mskPixmap.xLen)) ||
            (ShadowXGARegs.DstYAddr < ShadowXGARegs.MaskYOffset) ||
            (ShadowXGARegs.DstYAddr >
                             (ShadowXGARegs.MaskYOffset + mskPixmap.yLen)))

        {
            /**********************************************************/
            /* Pel is outside mask map boundary - it is excluded so   */
            /* just return.                                           */
            /**********************************************************/
            return ;
        }
    }

    if (patPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* The pattern is in use so get the current pel from it.      */
        /**************************************************************/
        eddf_mGetPel1(ShadowXGARegs.PatXAddr, ShadowXGARegs.PatYAddr,
                      patPixmap.xLen+1, patPixmap.startAddr, patPel)

        if (patPel == 1)
        {
            /**********************************************************/
            /* Fetch the foreground mix and find out what type it is  */
            /**********************************************************/
            mixToUse = ShadowXGARegs.FgMix ;
            mixType = mixTypeTable[mixToUse] ;

            /**********************************************************/
            /* Only fetch the source if the mix uses a source.        */
            /**********************************************************/
            if (mixType & MIX_USES_SRC)
            {
                /******************************************************/
                /* The pattern indicates foreground so either fetch   */
                /* a pel from the source or use the foreground colour.*/
                /* Note that if the srcPixmap is in use it will be in */
                /* use for the foreground AND the background as this  */
                /* is how the PM driver uses it.                      */
                /******************************************************/
                if (srcPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Source pixmap is in use so get a pel from it.  */
                    /**************************************************/
                    eddf_mGetPelAny(ShadowXGARegs.SrcXAddr, ShadowXGARegs.SrcYAddr,
                                    srcPixmap.xLen+1, srcPixmap.startAddr,
                                    srcPixmap.format, srcPel)
                }
                else
                {
                    /**************************************************/
                    /* Simply use the foreground colour for the source*/
                    /**************************************************/
                    srcPel = (BYTE)ShadowXGARegs.FgCol ;
                }
            }
        }
        else
        {
            /**********************************************************/
            /* fetch the background mix and find out what type it is  */
            /**********************************************************/
            mixToUse = ShadowXGARegs.BgMix ;
            mixType = mixTypeTable[mixToUse] ;

            /**********************************************************/
            /* Only fetch a source pel if the mix uses a source       */
            /**********************************************************/
            if (mixType & MIX_USES_SRC)
            {
                /******************************************************/
                /* The pattern indicates a background pel so either   */
                /* fetch a pel from the source or use background      */
                /* colour.                                            */
                /******************************************************/
                if (srcPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Source is in use so get the source pel from it */
                    /**************************************************/
                    eddf_mGetPelAny(ShadowXGARegs.SrcXAddr, ShadowXGARegs.SrcYAddr,
                                    srcPixmap.xLen+1, srcPixmap.startAddr,
                                    srcPixmap.format, srcPel)
                }
                else
                {
                    /**************************************************/
                    /* Use the background colour for the source pel   */
                    /**************************************************/
                    srcPel = (BYTE)ShadowXGARegs.BgCol ;
                }
            }
        }
    }
    else if (srcPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* There is no pattern but there is a source so get the       */
        /* foreground mix first                                       */
        /**************************************************************/
        mixToUse = ShadowXGARegs.FgMix ;
        mixType = mixTypeTable[mixToUse] ;

        /**************************************************************/
        /* And then fetch a source pel if necessary (more than likely */
        /* but who knows?)                                            */
        /**************************************************************/
        if (mixType & MIX_USES_SRC)
        {
            eddf_mGetPelAny(ShadowXGARegs.SrcXAddr, ShadowXGARegs.SrcYAddr,
                            srcPixmap.xLen+1, srcPixmap.startAddr,
                            srcPixmap.format, srcPel)
        }
    }
    else
    {
        /**************************************************************/
        /* There is no pattern or source so just use the foreground   */
        /* colour and mix.  Don't try to be clever about not fetching */
        /* the source 'cos it ain't worth it.                         */
        /**************************************************************/
        srcPel = (BYTE)ShadowXGARegs.FgCol ;
        mixToUse = ShadowXGARegs.FgMix ;
        mixType = mixTypeTable[mixToUse] ;
    }

    /******************************************************************/
    /* Now we have the srcPel (if we need it) and we know the         */
    /* mixToUse and the mixType.  Now see if we need to fetch a pel   */
    /* from the destination.                                          */
    /******************************************************************/
    if (mixType & MIX_USES_DST)
    {
        /**************************************************************/
        /* Indeed we do, so get hold of one.                          */
        /**************************************************************/
        eddf_mGetPelAny(ShadowXGARegs.DstXAddr, ShadowXGARegs.DstYAddr,
                        dstPixmap.xLen+1, dstPixmap.startAddr,
                        dstPixmap.format, dstPel)
    }
    #else    // _8514
    if ((Shadow8514Regs.DstXAddr < 0) ||
        (Shadow8514Regs.DstXAddr > dstPixmap.xLen) ||
        (Shadow8514Regs.DstYAddr < 0) ||
        (Shadow8514Regs.DstYAddr > dstPixmap.yLen))
    {
        /**************************************************************/
        /* Pel is outside destination bitmap - destination scissor    */
        /* excludes it so just return.                                */
        /**************************************************************/
        return ;
    }

    if (mskPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* The boundary scissor is being used so clip pel to that..   */
        /**************************************************************/
        if ((Shadow8514Regs.DstXAddr < Shadow8514Regs.MaskXOffset) ||
            (Shadow8514Regs.DstXAddr >
                             (Shadow8514Regs.MaskXOffset + mskPixmap.xLen)) ||
            (Shadow8514Regs.DstYAddr < Shadow8514Regs.MaskYOffset) ||
            (Shadow8514Regs.DstYAddr >
                             (Shadow8514Regs.MaskYOffset + mskPixmap.yLen)))

        {
            /**********************************************************/
            /* Pel is outside mask map boundary - it is excluded so   */
            /* just return.                                           */
            /**********************************************************/
            return ;
        }
    }

    if (patPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* The pattern is in use so get the current pel from it.      */
        /**************************************************************/
        eddf_mGetPel1(Shadow8514Regs.PatXAddr, Shadow8514Regs.PatYAddr,
                      patPixmap.xLen+1, patPixmap.startAddr, patPel)

        if (patPel == 1)
        {
            /**********************************************************/
            /* Fetch the foreground mix and find out what type it is  */
            /**********************************************************/
            mixToUse = Shadow8514Regs.Function_1.Mix ;
            mixType = mixTypeTable[mixToUse] ;

            /**********************************************************/
            /* Only fetch the source if the mix uses a source.        */
            /**********************************************************/
            if (mixType & MIX_USES_SRC)
            {
                /******************************************************/
                /* The pattern indicates foreground so either fetch   */
                /* a pel from the source or use the foreground colour.*/
                /* Note that if the srcPixmap is in use it will be in */
                /* use for the foreground AND the background as this  */
                /* is how the PM driver uses it.                      */
                /******************************************************/
                if (srcPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Source pixmap is in use so get a pel from it.  */
                    /**************************************************/
                    eddf_mGetPelAny(Shadow8514Regs.SrcXAddr, Shadow8514Regs.SrcYAddr,
                                    srcPixmap.xLen+1, srcPixmap.startAddr,
                                    srcPixmap.format, srcPel)
                }
                else
                {
                    /**************************************************/
                    /* Simply use the foreground colour for the source*/
                    /**************************************************/
                    srcPel = (BYTE)Shadow8514Regs.Color_1 ;
                }
            }
        }
        else
        {
            /**********************************************************/
            /* fetch the background mix and find out what type it is  */
            /**********************************************************/
            mixToUse = Shadow8514Regs.Function_0.Mix ;
            mixType = mixTypeTable[mixToUse] ;

            /**********************************************************/
            /* Only fetch a source pel if the mix uses a source       */
            /**********************************************************/
            if (mixType & MIX_USES_SRC)
            {
                /******************************************************/
                /* The pattern indicates a background pel so either   */
                /* fetch a pel from the source or use background      */
                /* colour.                                            */
                /******************************************************/
                if (srcPixmap.isUsed == TRUE)
                {
                    /**************************************************/
                    /* Source is in use so get the source pel from it */
                    /**************************************************/
                    eddf_mGetPelAny(Shadow8514Regs.SrcXAddr, Shadow8514Regs.SrcYAddr,
                                    srcPixmap.xLen+1, srcPixmap.startAddr,
                                    srcPixmap.format, srcPel)
                }
                else
                {
                    /**************************************************/
                    /* Use the background colour for the source pel   */
                    /**************************************************/
                    srcPel = (BYTE)Shadow8514Regs.Color_0 ;
                }
            }
        }
    }
    else if (srcPixmap.isUsed == TRUE)
    {
        /**************************************************************/
        /* There is no pattern but there is a source so get the       */
        /* foreground mix first                                       */
        /**************************************************************/
        mixToUse = Shadow8514Regs.Function_1.Mix ;
        mixType = mixTypeTable[mixToUse] ;

        /**************************************************************/
        /* And then fetch a source pel if necessary (more than likely */
        /* but who knows?)                                            */
        /**************************************************************/
        if (mixType & MIX_USES_SRC)
        {
            eddf_mGetPelAny(Shadow8514Regs.SrcXAddr, Shadow8514Regs.SrcYAddr,
                            srcPixmap.xLen+1, srcPixmap.startAddr,
                            srcPixmap.format, srcPel)
        }
    }
    else
    {
        /**************************************************************/
        /* There is no pattern or source so just use the foreground   */
        /* colour and mix.  Don't try to be clever about not fetching */
        /* the source 'cos it ain't worth it.                         */
        /**************************************************************/
        srcPel = (BYTE)Shadow8514Regs.Color_1 ;
        mixToUse = Shadow8514Regs.Function_1.Mix ;
        mixType = mixTypeTable[mixToUse] ;
    }

    /******************************************************************/
    /* Now we have the srcPel (if we need it) and we know the         */
    /* mixToUse and the mixType.  Now see if we need to fetch a pel   */
    /* from the destination.                                          */
    /******************************************************************/
    if (mixType & MIX_USES_DST)
    {
        /**************************************************************/
        /* Indeed we do, so get hold of one.                          */
        /**************************************************************/
        eddf_mGetPelAny(Shadow8514Regs.DstXAddr, Shadow8514Regs.DstYAddr,
                        dstPixmap.xLen+1, dstPixmap.startAddr,
                        dstPixmap.format, dstPel)
    }
    #endif   // _8514

    /******************************************************************/
    /* Now apply mixToUse to the src and dst pels, special casing a   */
    /* straight copy as it is a frequent operation and leavealone as  */
    /* we don't have to update the destination for that one.          */
    /******************************************************************/
    if (mixToUse == HWMIX_SOURCE)
    {
        dstPel = srcPel ;
    }
    else if (mixToUse == HWMIX_DEST)
    {
        return ;
    }
    else
    {
        switch (mixToUse)
        {
            #ifndef  _8514
            case HWMIX_ZEROS:
                dstPel = 0 ;
                break ;
            case HWMIX_SOURCE_AND_DEST:
                dstPel = srcPel & dstPel ;
                break ;
            case HWMIX_SOURCE_AND_NOTDEST:
                dstPel = srcPel & ~dstPel ;
                break ;
            case HWMIX_SOURCE:
                dstPel = srcPel ;
                break ;
            case HWMIX_NOTSOURCE_AND_DEST:
                dstPel = ~srcPel & dstPel ;
                break ;
            case HWMIX_DEST:
                break ;
            case HWMIX_SOURCE_XOR_DEST:
                dstPel = srcPel ^ dstPel ;
                break ;
            case HWMIX_SOURCE_OR_DEST:
                dstPel = srcPel | dstPel ;
                break ;
            case HWMIX_NOTSOURCE_AND_NOTDEST:
                dstPel = ~srcPel & ~dstPel ;
                break ;
            case HWMIX_SOURCE_XOR_NOTDEST:
                dstPel = srcPel ^ ~dstPel ;
                break ;
            case HWMIX_NOTDEST:
                dstPel = ~dstPel ;
                break ;
            case HWMIX_SOURCE_OR_NOTDEST:
                dstPel = srcPel | ~dstPel ;
                break ;
            case HWMIX_NOTSOURCE:
                dstPel = ~srcPel ;
                break ;
            case HWMIX_NOTSOURCE_OR_DEST:
                dstPel = ~srcPel | dstPel ;
                break ;
            case HWMIX_NOTSOURCE_OR_NOTDEST:
                dstPel = ~srcPel | ~dstPel ;
                break ;
            case HWMIX_ONES:
                dstPel = 0xFF ;
                break ;
            #else
            case FUNC_ZEROS:
                dstPel = 0 ;
                break ;
            case FUNC_S_AND_D:
                dstPel = srcPel & dstPel ;
                break ;
            case FUNC_S_AND_ND:
                dstPel = srcPel & ~dstPel ;
                break ;
            case FUNC_S:
                dstPel = srcPel ;
                break ;
            case FUNC_NS_AND_D:
                dstPel = ~srcPel & dstPel ;
                break ;
            case FUNC_D:
                break ;
            case FUNC_S_XOR_D:
                dstPel = srcPel ^ dstPel ;
                break ;
            case FUNC_S_OR_D:
                dstPel = srcPel | dstPel ;
                break ;
            case FUNC_NS_AND_ND:
                dstPel = ~srcPel & ~dstPel ;
                break ;
            case FUNC_S_XNOR_D:
                dstPel = srcPel ^ ~dstPel ;
                break ;
            case FUNC_ND:
                dstPel = ~dstPel ;
                break ;
            case FUNC_S_OR_ND:
                dstPel = srcPel | ~dstPel ;
                break ;
            case FUNC_NS:
                dstPel = ~srcPel ;
                break ;
            case FUNC_NS_OR_D:
                dstPel = ~srcPel | dstPel ;
                break ;
            case FUNC_NS_OR_ND:
                dstPel = ~srcPel | ~dstPel ;
                break ;
            case FUNC_ONES:
                dstPel = 0xFF ;
                break ;
            #endif
        }
    }

    /******************************************************************/
    /* Done the mixing, now put back the pel                          */
    /******************************************************************/
    #ifndef   _8514
    eddf_mSetPelAny(ShadowXGARegs.DstXAddr, ShadowXGARegs.DstYAddr,
                    dstPixmap.xLen+1, dstPixmap.startAddr,
                    dstPixmap.format, dstPel)
    #else
    eddf_mSetPelAny(Shadow8514Regs.DstXAddr, Shadow8514Regs.DstYAddr,
                    dstPixmap.xLen+1, dstPixmap.startAddr,
                    dstPixmap.format, dstPel)
    #endif

    /******************************************************************/
    /* And now go home..                                              */
    /******************************************************************/
    return ;
}
