;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***********************************************************************
;
;   Module          = EDDFMACR
;
;   Description     = macros for MESS 386 code
;
;
;***********************************************************************

IF1

; First saving the registers before calling the mess
; The mess already saves esi,edi,ebx as required by C calling.
; Under FLAT model ds,es should not change
; By convention XGA uses fs to access the hardware.(no need to save gs)

saveregs        macro
        push    eax
        push    ecx
        push    edx
        push    fs
                endm

; Then restoring the registers after calling the mess

restoreregs     macro
        pop     fs
        pop     edx
        pop     ecx
        pop     eax
                endm


mixTrashSource8AllRops  macro
        not     bl              ; +0    S & ~D
        and     bl, al          ; +2    S & D
        jmp     short @f

        not     bl              ; +6    S | ~D
        or      bl, al          ; +8    S | D
        jmp     short @f

        not     bl              ; +12   S ^ ~D
        xor     bl, al          ; +14   S ^ D
        jmp     short @f

        or      bl, al          ; +18   ~S & ~D = ~(S | D)
        not     bl
        jmp     short @f

        and     bl, al          ; +24   ~S | ~D = ~(S & D)
        not     bl
        jmp     short @f

        not     al              ; +30   ~S | D
        or      bl, al
        jmp     short @f

        not     al              ; +36   ~S & D
        and     bl, al
        jmp     short @f

        mov     bl, al          ; +42   ~S
        not     bl              ; +44   ~D
        jmp     short @f

        mov     bl, al          ; +48   S
        jmp     short @f

        mov     bl, 0           ; +52   ZEROES
        jmp     short @f

        mov     bl, 0FFh        ; +56   ONES
                                ; +58   Do nothing

@@:
                        endm


clip_lower_major macro clip_lower
        ; 
        ;on entry: ax=major dx=minor
        ;             (Y)      (X)
        ; 
        ;on exit : si=minor ax=deltaMinor
        ;             (X)      (delta X)

        mov     di, clip_lower
        sub     ax, di          ;find how many pels away from clipy1 (deltaY)
        neg     ax              ;ax = deltaY

        mov     cx, AIShadow.bres_k1
        mov     si, dx                  ;si=X
        imul    cx                      ;dx:ax=deltaY*k1

        sub     cx, AIShadow.bres_k2    ;cx=k1-k2

        shl     ax,1                    ;dx:ax = 2*(dx:ax) =2*(deltaY*k1)
        rcl     dx,1

        idiv    cx                      ;ax=(2*deltaY*k1)/(k1-k2) =2*deltaX
        inc     ax                      ;round up result of division
        shr     ax,1                    ;ax=deltaX (rounded to nearest int)

endM


clip_lower_minor macro clip_lower
        ; 
        ;on entry: ax=minor dx=major
        ;             (Y)      (X)
        ; 
        ;on exit : si=major ax=deltaMajor
        ;             (X)      (delta X)

        mov     si, dx          ;si=X
        mov     di, clip_lower
        sub     ax, di          ;find how many pels away from clipy1 (deltaY)
        neg     ax              ;ax = deltaY
        cwde                    ;eax= deltaY

        movsx   ecx, AIShadow.bres_k2
        imul    ecx                     ;edx:eax=deltaY*k2

        shl     eax,1                   ;edx:eax=2*(deltaY*k2)
        rcl     edx,1

        movsx   ecx, AIShadow.bres_k1
        idiv    ecx                     ;eax=(2*deltaY*k2)/k1
        dec     eax                     ;round down result of division
        shr     eax,1                   ;ax=deltaY*k2/k1

        inc     eax
        neg     eax                     ;ax=1-(deltaY*k2/k1) =deltaX

        test    eax, 0ffff0000h
        jz      @F
        mov     ax,  8fffh
endM

ENDIF
