/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDFDATA                                       */
/*                                                                    */
/*   Description     = MESS data                                      */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_DDIMISC
#include <eddinclt.h>

#include <eddhcone.h>
#include <eddfcone.h>

#include <eddhtype.h>
#include <eddftype.h>

VOID NEAR eddh_DestOnlyBlt();
VOID NEAR eddh_DrawText();
VOID NEAR eddh_PatDestBlt();
/* PMHIMAGEDATA removed */
/* PMHLINE removed */
/* PMHSCANLINE removed */
VOID NEAR eddh_PMIMAGEDATA();
VOID NEAR eddh_PMLINES();
VOID NEAR eddh_PMPLOTSTEP();
VOID NEAR eddh_PMSCANLINE();
VOID NEAR eddh_PMSHORTLINES();
VOID NEAR eddh_SrcDestBlt();

VOID NEAR eddf_DestOnlyBlt();
VOID NEAR eddf_DrawText();
VOID NEAR eddf_PatDestBlt();
/* PMHIMAGEDATA removed */
/* PMHLINE removed */
/* PMHSCANLINE removed */
VOID NEAR eddf_PMIMAGEDATA();
VOID NEAR eddf_PMLINES();
VOID NEAR eddf_PMPLOTSTEP();
VOID NEAR eddf_PMSCANLINE();
VOID NEAR eddf_PMSHORTLINES();
VOID NEAR eddf_SrcDestBlt();

#ifdef USEAA
VOID NEAR eddh_DrawAAChar();
VOID NEAR eddf_DrawAAChar();
#endif /* USAAA */

SHORT           softDrawInUse = 0 ;
SHORT           foregroundSession = 1 ;
SHORT           useSD = 1 ;

/**********************************************************************/
/* The PlotStepTable                                                  */
/**********************************************************************/
DevPoint    MESSPlotStepTable[8] = {
            { 1, 0 },
            { 1, -1 },
            { 0, -1 },
            { -1, -1 },
            { -1, 0 },
            { -1, 1 },
            { 0, 1 },
            { 1, 1 } } ;

/**********************************************************************/
/* The mix type table                                                 */
/**********************************************************************/
SHORT       mixTypeTable[16] = {
            0,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC,
            MIX_USES_SRC | MIX_USES_DST,
            MIX_USES_SRC | MIX_USES_DST,
            0 } ;

/**********************************************************************/
/* Tables for accessing hardware or software versions of the 386      */
/* code.                                                              */
/* hardDrawTable are for Xway                                         */
/* softDrawTable for software drawing                                 */
/* drawFunctions is the table which is actually used (a copy of one   */
/* of the other tables)                                               */
/**********************************************************************/
drawFunctionsTable hardDrawTable = {
        eddh_DestOnlyBlt,
#ifdef USEAA
        eddh_DrawAAChar,
#else /* USEAA */
        0,
#endif /* USAAA */
        eddh_DrawText,
        eddh_PatDestBlt,
        NULL,               /* was PMHIMAGEDATA */
        NULL,               /* was PMHLINE      */
        NULL,               /* was PMHSCANLINE  */
        eddh_PMIMAGEDATA,
        eddh_PMLINES,
        eddh_PMPLOTSTEP,
        eddh_PMSCANLINE,
        eddh_PMSHORTLINES,
        eddh_SrcDestBlt,
        } ;


drawFunctionsTable softDrawTable = {
        eddf_DestOnlyBlt,
#ifdef USEAA
        eddf_DrawAAChar,
#else /* USEAA */
        0,
#endif /* USAAA */
        eddf_DrawText,
        eddf_PatDestBlt,
        NULL,               /* was PMHIMAGEDATA */
        NULL,               /* was PMHLINE      */
        NULL,               /* was PMHSCANLINE  */
        eddf_PMIMAGEDATA,
        eddf_PMLINES,
        eddf_PMPLOTSTEP,
        eddf_PMSCANLINE,
        eddf_PMSHORTLINES,
        eddf_SrcDestBlt,
        } ;

/**********************************************************************/
/* This is a pointer to a table like those above.  It is used to make */
/* the switching more efficient at the cost of an extra level of      */
/* indirection when calling the functions.                            */
/**********************************************************************/
pDrawFunctionsTable pDrawFunctions ;

/**********************************************************************/
/* saveAddresses is used for holding the banks of addresses which     */
/* have to be swapped during death and ressurection.                  */
/* They are initialised to the virtual ones and swapped on each death */
/* or ressurection thereafter.                                        */
/**********************************************************************/
ULONG saveAddresses[NUM_ADDRESSES] ;
