/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDEVRAM                                       */
/*                                                                    */
/*   Description     = Enable : subfunction initialise VRAM           */
/*                                                                    */
/*   Function        = stores default data in adapter VRAM            */
/*                     (patterns, font, markers, etc.)                */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DOSRESOURCES
#define INCL_DOSMEMMGR
#define INCL_DDIMISC
#define INCL_ERRORS
#include <eddinclt.h>

#include <eddhcone.h>
#include <eddacone.h>
#include <eddccone.h>
#include <eddecone.h>
#include <eddvcone.h>

#include <edddtypt.h>
#include <eddetypt.h>
#include <eddhtype.h>

#include <eddeextf.h>
#include <eddhextf.h>

#include <eddhmacr.h>

#include <eddfcone.h>

#include <cursor.h>
#include <hwaccess.h>

#ifdef _8514
#include <8514.h>
#include <eddncach.h>
#include <cacheman.h>
extern PHWMAP           pHWMap;
extern PCACHEMAP        pCacheMap;
#endif

/**********************************************************************/
/* globals                                                            */
/**********************************************************************/
extern BitmapHeader         NewPatternTable[];
extern BYTE                 Pattern[];
extern BltSPad              SPad;
extern ULONG                FreeVRAM;
extern ULONG                DefaultFontPhysicalAddress;
extern ULONG                ColorPatPhysical;
extern ULONG                MonoPatPhysical;

extern CURSORDATA           cursor_data;
extern ONEPELBUFFER         get_and_set_pel_buffer;
extern RGB2                 LastRGBDithered;

extern ULONG                pVRAMCacheStart;
extern ULONG                offNextFree11Pos;
extern ULONG                offLastFree81Pos;
extern ULONG                pSysCacheStartPhy ;

extern BYTE                 ColorPat[DITHMATRIX_XSIZE][DITHMATRIX_YSIZE];
extern BYTE                 MonoPat[MONODITH_XSIZE][MONODITH_YSIZE];

extern ULONG                LinePatternCur;
extern ULONG                LinePatternSys;
extern ULONG                MarkerCur;
extern ULONG                pPhunkPhys;
extern PVOID                pPhunkVirt;

extern ULONG                LinePatternPhys;
extern USHORT               LinePatternsBitmap[];
extern ULONG                MarkerPhys;
extern ULONG                MarkerSys;
extern BYTE                 MarkerDefaultSet[];
extern DDTType              DDT;
extern BitmapHeader         DirectListEntry;

#ifndef _8514

BOOL InitialiseVRAM() /* XGA Version */
{

    /******************************************************************/
    /* Split this into 2 sections - one for non VRAM bits, and one    */
    /* for the real VRAM bits.                                        */
    /******************************************************************/

    /******************************************************************/
    /* We will never dither black (rbg = 0x00000000) so setting the   */
    /* LastRGBDithered to 0L ensures that the next time we try and    */
    /* dither we will not match the last color dithered (and thus we  */
    /* will be forced to create the dither pattern and copy it down   */
    /* into VRAM).                                                    */
    /******************************************************************/
    *((PULONG)&LastRGBDithered) = 0L;

    /******************************************************************/
    /* Now set up the bitmap header in the pattern bitmaps table for  */
    /* the dithered patterns - first the logical address              */
    /******************************************************************/
    NewPatternTable[PATSYM_DITHERED].Bitmap = (lpBitmap)ColorPat;
    NewPatternTable[PATSYM_MONODITH].Bitmap = (lpBitmap)MonoPat;

    /******************************************************************/
    /* We will use the PHUNK as the one pel buffer.                   */
    /******************************************************************/
    get_and_set_pel_buffer.virt_addr = pPhunkVirt;

    MarkerSys       = (ULONG)(PBYTE)MarkerDefaultSet;
    LinePatternSys  = (ULONG)(PBYTE)LinePatternsBitmap;

#ifdef MATROX
    if (RunningOnMatrox())
    {
        /**************************************************************/
        /* Set up the colour cursor pointers in locked memory         */
        /* Note these pointers are only valid in the C code           */
        /* (the assembler code used at interrupt time will be         */
        /* using the data directly without indirection).              */
        /**************************************************************/
        cursor_data.software_cursor.andmask = &cursor_data.cursor_andmask;
        cursor_data.software_cursor.xormask = &cursor_data.cursor_xormask;
        cursor_data.software_cursor.bm      = &cursor_data.cursor_bm;
        cursor_data.software_cursor.screen  = &cursor_data.cursor_screen;

        /**************************************************************/
        /* Thats all we need for Matrox !                             */
        /**************************************************************/
        return (TRUE);
    }
#endif /* MATROX */


/**********************************************************************/
/* Now for the real VRAM initialization                               */
/**********************************************************************/

    /******************************************************************/
    /* The free VRAM starts after the screen.                         */
    /******************************************************************/
    FreeVRAM = (ULONG)DirectListEntry.BMPhys +
               ((ULONG)DDT.ScreenWidth * (ULONG)DDT.ScreenHeight *
                (ULONG)DDT.BitCount / 8 );

    /******************************************************************/
    /* Copy the default patterns into VRAM.                           */
    /******************************************************************/
    CopyMemoryToVRAM( Pattern,
                      FreeVRAM,
                      (8 * DEFAULT_PATTERNS_SIZE) - 1,
                      0,
                      ONE_BPP);

    /******************************************************************/
    /* Set up the pointers to the pattern bitmaps.                    */
    /******************************************************************/
    (ULONG)NewPatternTable[ 0].BMPhys = FreeVRAM;
    (ULONG)NewPatternTable[ 1].BMPhys = FreeVRAM +  8;
    (ULONG)NewPatternTable[ 2].BMPhys = FreeVRAM + 12;
    (ULONG)NewPatternTable[ 3].BMPhys = FreeVRAM + 14;
    (ULONG)NewPatternTable[ 4].BMPhys = FreeVRAM + 18;
    (ULONG)NewPatternTable[ 5].BMPhys = FreeVRAM + 20;
    (ULONG)NewPatternTable[ 6].BMPhys = FreeVRAM + 24;
    (ULONG)NewPatternTable[ 7].BMPhys = FreeVRAM + 26;
    (ULONG)NewPatternTable[ 8].BMPhys = FreeVRAM + 30;
    (ULONG)NewPatternTable[ 9].BMPhys = FreeVRAM + 31;
    (ULONG)NewPatternTable[10].BMPhys = FreeVRAM + 35;
    (ULONG)NewPatternTable[11].BMPhys = FreeVRAM + 39;
    (ULONG)NewPatternTable[12].BMPhys = FreeVRAM + 43;
    (ULONG)NewPatternTable[13].BMPhys = FreeVRAM + 47;
    (ULONG)NewPatternTable[14].BMPhys = FreeVRAM + 51;
    (ULONG)NewPatternTable[15].BMPhys = FreeVRAM + 52;
    (ULONG)NewPatternTable[16].BMPhys = FreeVRAM + 53;
#ifdef NEW_PATTERNS
    (ULONG)NewPatternTable[17].BMPhys = FreeVRAM + 55;
    (ULONG)NewPatternTable[18].BMPhys = FreeVRAM + 57;
#endif /* NEW_PATTERNS */

    (ULONG)NewPatternTable[PATSYM_DITHERED].BMPhys =
                                     FreeVRAM + DEFAULT_PATTERNS_SIZE;
    (ULONG)NewPatternTable[PATSYM_MONODITH].BMPhys =
                                     FreeVRAM + DEFAULT_PATTERNS_SIZE +
                                                DITHER_BUFFER_SIZE;

    /******************************************************************/
    /* Set the FreeVRAM pointer to point past the patterns and the    */
    /* dithered pattern buffer.                                       */
    /******************************************************************/
    FreeVRAM += DEFAULT_PATTERNS_SIZE +
                DITHER_BUFFER_SIZE + MONO_DITHER_BUFFER_SIZE;

    /******************************************************************/
    /* Now for the get and set pel buffer: this is a one byte area    */
    /* for transferring from a bitmap to an address which has a       */
    /* selector                                                       */
    /******************************************************************/
    /******************************************************************/
    /* We will use the PHUNK as the one pel buffer.                   */
    /******************************************************************/
    get_and_set_pel_buffer.phys_addr = pPhunkPhys;

    /******************************************************************/
    /* Copy the default markers to VRAM.                              */
    /******************************************************************/
    MarkerPhys = FreeVRAM;
    MarkerCur = MarkerPhys;
    FreeVRAM += DEF_MARKER_LENGTH*11;

    /******************************************************************/
    /* The width of the blt is the bit length of each marker          */
    /* times number of markers.                                       */
    /******************************************************************/
    CopyMemoryToVRAM( MarkerDefaultSet,
                      MarkerPhys,
                      (8 * (DEF_MARKER_LENGTH * 11)) - 1,
                      0,
                      ONE_BPP);

    /******************************************************************/
    /* reserve space in VRAM for the coloured cursor definition       */
    /******************************************************************/
    cursor_data.software_cursor.andmask = FreeVRAM;
    FreeVRAM += SIZEOFANDMASK;

    cursor_data.software_cursor.xormask = FreeVRAM;
    FreeVRAM += SIZEOFANDMASK;

    cursor_data.software_cursor.bm = FreeVRAM;
    FreeVRAM += SIZEOFCURSORBITMAP;

    cursor_data.software_cursor.screen = FreeVRAM;
    FreeVRAM += SIZEOFCURSORBITMAP;

    /******************************************************************/
    /* Now for the line patterns 'bitmap'.  Put this in VRAM          */
    /******************************************************************/
    LinePatternPhys = FreeVRAM;
    LinePatternCur  = LinePatternPhys;
    FreeVRAM += LINE_PATTERNS_SIZE;

    CopyMemoryToVRAM( LinePatternsBitmap,
                      LinePatternPhys,
                      (8 * LINE_PATTERNS_SIZE) - 1,
                      0,
                      ONE_BPP );

    /******************************************************************/
    /* We use the remaining VRAM for a character cache.  NB we are    */
    /* boldly assuming that there will always be at least             */
    /* charCacheLength memory available after this point.             */
    /******************************************************************/
    /******************************************************************/
    /* Check if there is enough VRAM for the character cache - there  */
    /* is not for 800x600 with a 0.5M card, for example. If           */
    /* insufficient VRAM then set the VRAMCacheStart pointer to the   */
    /* system memory cache.                                           */
    /******************************************************************/
    if ( (aiXGAAdapter.lMemorySize -
            (FreeVRAM - DirectListEntry.BMPhys)) < SYS_CHAR_CACHE_SIZE )
    {
      pVRAMCacheStart = pSysCacheStartPhy;
    }
    else
    {
      pVRAMCacheStart = FreeVRAM;
      FreeVRAM += SYS_CHAR_CACHE_SIZE;
    }

    return(TRUE);

} /* InitialiseVRAM */

#else

BOOL InitialiseVRAM() /* 8514 Version */
{

    /******************************************************************/
    /* Split this into 2 sections - one for non VRAM bits, and one    */
    /* for the real VRAM bits.                                        */
    /******************************************************************/

    /******************************************************************/
    /* We will never dither black (rbg = 0x00000000) so setting the   */
    /* LastRGBDithered to 0L ensures that the next time we try and    */
    /* dither we will not match the last color dithered (and thus we  */
    /* will be forced to create the dither pattern and copy it down   */
    /* into VRAM).                                                    */
    /******************************************************************/
    *((PULONG)&LastRGBDithered) = 0L;

    /******************************************************************/
    /* Now set up the bitmap header in the pattern bitmaps table for  */
    /* the dithered patterns - first the logical address              */
    /******************************************************************/
    NewPatternTable[PATSYM_DITHERED].Bitmap = (lpBitmap)ColorPat;
    NewPatternTable[PATSYM_MONODITH].Bitmap = (lpBitmap)MonoPat;

    /******************************************************************/
    /* We will use the PHUNK as the one pel buffer.                   */
    /******************************************************************/
    get_and_set_pel_buffer.virt_addr = pPhunkVirt;

    MarkerSys       = (ULONG)(PBYTE)MarkerDefaultSet;
    LinePatternSys  = (ULONG)(PBYTE)LinePatternsBitmap;


/**********************************************************************/
/* Now for the real VRAM initialization                               */
/**********************************************************************/

    /******************************************************************/
    /* The free VRAM starts after the screen.                         */
    /******************************************************************/

    //FreeVRAM = (ULONG)DirectListEntry.BMPhys +
    //           ((ULONG)DDT.ScreenWidth * (ULONG)DDT.ScreenHeight *
    //            (ULONG)DDT.BitCount / 8 );

    FreeVRAM = (ULONG)DDT.ScreenHeight;

    /******************************************************************/
    /* Copy the default patterns into VRAM.                           */
    /******************************************************************/
//    CopyMemoryToVRAM( Pattern,
//                      FreeVRAM,
//                      (8 * DEFAULT_PATTERNS_SIZE) - 1,
//                      0,
//                      ONE_BPP);

    /******************************************************************/
    /* Set up the pointers to the pattern bitmaps.                    */
    /******************************************************************/
    (ULONG)NewPatternTable[ 0].BMPhys = NULL;
    (ULONG)NewPatternTable[ 1].BMPhys = NULL;
    (ULONG)NewPatternTable[ 2].BMPhys = NULL;
    (ULONG)NewPatternTable[ 3].BMPhys = NULL;
    (ULONG)NewPatternTable[ 4].BMPhys = NULL;
    (ULONG)NewPatternTable[ 5].BMPhys = NULL;
    (ULONG)NewPatternTable[ 6].BMPhys = NULL;
    (ULONG)NewPatternTable[ 7].BMPhys = NULL;
    (ULONG)NewPatternTable[ 8].BMPhys = NULL;
    (ULONG)NewPatternTable[ 9].BMPhys = NULL;
    (ULONG)NewPatternTable[10].BMPhys = NULL;
    (ULONG)NewPatternTable[11].BMPhys = NULL;
    (ULONG)NewPatternTable[12].BMPhys = NULL;
    (ULONG)NewPatternTable[13].BMPhys = NULL;
    (ULONG)NewPatternTable[14].BMPhys = NULL;
    (ULONG)NewPatternTable[15].BMPhys = NULL;
    (ULONG)NewPatternTable[16].BMPhys = NULL;
#ifdef NEW_PATTERNS
    (ULONG)NewPatternTable[17].BMPhys = NULL;
    (ULONG)NewPatternTable[18].BMPhys = NULL;
#endif /* NEW_PATTERNS */

    (ULONG)NewPatternTable[PATSYM_DITHERED].BMPhys = pCacheMap->color_dither;
    (ULONG)NewPatternTable[PATSYM_MONODITH].BMPhys = pCacheMap->mono_dither;
    ColorPatPhysical = pCacheMap->color_dither;

//    (ULONG)NewPatternTable[ 0].BMPhys = FreeVRAM;
//    (ULONG)NewPatternTable[ 1].BMPhys = FreeVRAM +  8;
//    (ULONG)NewPatternTable[ 2].BMPhys = FreeVRAM + 12;
//    (ULONG)NewPatternTable[ 3].BMPhys = FreeVRAM + 14;
//    (ULONG)NewPatternTable[ 4].BMPhys = FreeVRAM + 18;
//    (ULONG)NewPatternTable[ 5].BMPhys = FreeVRAM + 20;
//    (ULONG)NewPatternTable[ 6].BMPhys = FreeVRAM + 24;
//    (ULONG)NewPatternTable[ 7].BMPhys = FreeVRAM + 26;
//    (ULONG)NewPatternTable[ 8].BMPhys = FreeVRAM + 30;
//    (ULONG)NewPatternTable[ 9].BMPhys = FreeVRAM + 31;
//    (ULONG)NewPatternTable[10].BMPhys = FreeVRAM + 35;
//    (ULONG)NewPatternTable[11].BMPhys = FreeVRAM + 39;
//    (ULONG)NewPatternTable[12].BMPhys = FreeVRAM + 43;
//    (ULONG)NewPatternTable[13].BMPhys = FreeVRAM + 47;
//    (ULONG)NewPatternTable[14].BMPhys = FreeVRAM + 51;
//    (ULONG)NewPatternTable[15].BMPhys = FreeVRAM + 52;
//    (ULONG)NewPatternTable[16].BMPhys = FreeVRAM + 53;
//#ifdef NEW_PATTERNS
//    (ULONG)NewPatternTable[17].BMPhys = FreeVRAM + 55;
//    (ULONG)NewPatternTable[18].BMPhys = FreeVRAM + 57;
//#endif /* NEW_PATTERNS */
//
//    (ULONG)NewPatternTable[PATSYM_DITHERED].BMPhys =
//                                     FreeVRAM + DEFAULT_PATTERNS_SIZE;
//    (ULONG)NewPatternTable[PATSYM_MONODITH].BMPhys =
//                                     FreeVRAM + DEFAULT_PATTERNS_SIZE +
//                                                DITHER_BUFFER_SIZE;

    /******************************************************************/
    /* Now for the get and set pel buffer: this is a one byte area    */
    /* for transferring from a bitmap to an address which has a       */
    /* selector                                                       */
    /******************************************************************/
    /******************************************************************/
    /* We will use the PHUNK as the one pel buffer.                   */
    /******************************************************************/
    get_and_set_pel_buffer.phys_addr = pPhunkPhys;

    /******************************************************************/
    /* For the 8514, markers are NOT cached.                          */
    /******************************************************************/
    MarkerPhys = NULL;
    MarkerCur = MarkerPhys;

    /******************************************************************/
    /* Nor are Line Patterns                                          */
    /******************************************************************/
    LinePatternPhys = NULL;
    LinePatternCur  = LinePatternPhys;

    /******************************************************************/
    /* reserve space in VRAM for the coloured cursor definition       */
    /******************************************************************/
    cursor_data.software_cursor.bm      = pHWMap->color_cursor;
    cursor_data.software_cursor.screen  = pHWMap->save_area;
    cursor_data.software_cursor.andmask = pHWMap->and_mask;
    cursor_data.software_cursor.xormask = pHWMap->xor_mask;
    cursor_data.cursor_hwscan           = pHWMap->hw_cursor_Y1024;
    cursor_data.cursor_hwvram           = pHWMap->hw_cursor;

    /******************************************************************/
    /* We use the remaining VRAM for a character cache.  NB we are    */
    /* boldly assuming that there will always be at least             */
    /* charCacheLength memory available after this point.             */
    /******************************************************************/
    /******************************************************************/
    /* Check if there is enough VRAM for the character cache - there  */
    /* is not for 800x600 with a 0.5M card, for example. If           */
    /* insufficient VRAM then set the VRAMCacheStart pointer to the   */
    /* system memory cache.                                           */
    /******************************************************************/
    //****************************************************************/
    // @RCW
    //
    // For now, we will hard wire each font cache to start at (896,0).
    // This starts each font cache on the beginning of the 128th row of
    // off-screen VRAM.  Basically, the bottom half of off-screen VRAM
    // is used for the font cache.  However, when seamless enters the
    // picture, we give them the bottom 64K for their font cache and
    // limit ourselves to the third quadrant of off-screen VRAM.
    //****************************************************************/
    {
       USHORT i;

       for (i=0; i<pHWMap->num_font_planes; i++ ) {
          p8514FontCache[i] = pCacheMap->font_cache_start;
       }
    }
    pVRAMCacheStart = FreeVRAM;
    // Add in y offset of the cache
    //FreeVRAM += SYS_CHAR_CACHE_SIZE;
    FreeVRAM += (USHORT)(pCacheMap->font_cache_bottom - pCacheMap->font_cache_top);

    return(TRUE);

} /* InitialiseVRAM */

#endif
