/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDETERM                                       */
/*                                                                    */
/*   Description     = Enable function Termination                    */
/*                                                                    */
/*   Function        = Handles error Termination of the Device Driver */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DOSPROCESS
#define INCL_DOSERRORS

#include <eddinclt.h>

#include <eddecone.h>
#include <eddetypt.h>
#include <eddeextf.h>
#include <eddgextf.h>

#ifdef FIREWALLS
ULONG   TidyUpReason;
ULONG   UnlockReason;
#endif /* FIREWALLS */

/**********************************************************************/
/*                                                                    */
/* Two functions are called on termination                            */
/* 1. Unlock called immediately on termination to allow the device    */
/* driver to free any semaphores locked by the terminating process    */
/* 2. TidyUp called after the appl and engine exit list processing to */
/* allow the driver to tidy up anything not done by the engine        */
/*                                                                    */
/**********************************************************************/

VOID Unlock_Termination (ULONG Reason)

{
    /******************************************************************/
    /* This process is terminating, so we must release the driver     */
    /* semaphore as many times as this process has grabbed it.        */
    /******************************************************************/
    while (ReleaseDriverSemaphore() == NO_ERROR);

#ifdef FIREWALLS
    /******************************************************************/
    /* Save the reason for debugging.                                 */
    /******************************************************************/
    UnlockReason = Reason;
#endif /* FIREWALLS */

    /******************************************************************/
    /* Signal DosExit termination function complete to DOS            */
    /******************************************************************/
    DosExitList(EXLST_EXIT, FNULL);
}

VOID TidyUp_Termination (ULONG Reason)

{
#ifdef FIREWALLS
    /******************************************************************/
    /* Save the reason for debugging.                                 */
    /******************************************************************/
    TidyUpReason = Reason;
#endif /* FIREWALLS */

    /******************************************************************/
    /* Throw away this processes use of the driver semaphore          */
    /******************************************************************/
    CloseDriverSemaphore();

    /******************************************************************/
    /* signal DosExit termination function complete to DOS            */
    /******************************************************************/
    DosExitList(EXLST_EXIT, FNULL);
}

