/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDERRE                                        */
/*                                                                    */
/*   Description     = Display Device Driver Error Constants          */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Definition of Display Device Driver Return and Error codes.        */
/**********************************************************************/

#define OK                      1
#define OK_CORR                 2
#define OK_ZERO                 0
#define WIN_OK                  1
#define ENG_OK                  0
#define DOS_OK                  0
#define ENG_CALL                0xFFFE

#define ERROR_NEG               -1
#define ERROR_MINUS_2           -2
#define ERROR_MINUS_4           -4
#define ERROR_ZERO              0

#define EDD_ERROR               0x400
#define ERROR_NO_MEMORY         EDD_ERROR
#define ERROR_INVALID_DC        EDD_ERROR + 1
#define ERROR_INVALID_PARM      EDD_ERROR + 2
#define ERROR_CONVERT_FAILED    EDD_ERROR + 3
#define ERR_NO_SOURCE           EDD_ERROR + 4
#define ERR_INVALID_SOURCE      EDD_ERROR + 5
#define ERR_INVALID_TARGET      EDD_ERROR + 6
#define ERR_IN_DOSCALL          EDD_ERROR + 7
#define ERR_NO_SELECTED_BITMAP  EDD_ERROR + 8
#define ERR_INVALID_COUNT       EDD_ERROR + 9


/**********************************************************************/
/* Device Driver Error Codes                                          */
/**********************************************************************/

#define PMERROR                   0x400
#define PMERROR_ENABLE            PMERROR + 0x20
#define PMERROR_BITMAPS           PMERROR + 0x40
#define PMERROR_ATTRIBUTES        PMERROR + 0x60
#define PMERROR_GENERAL           PMERROR + 0x80

#define PMERR_BAD_SUBFUNCTION     PMERROR_ENABLE
#define PMERR_AI_OPEN_FAILED      PMERROR_ENABLE + 1
#define PMERR_INVALID_DC_TYPE     PMERROR_ENABLE + 2
#define PMERR_INVALID_POP_NUMBER  PMERROR_ENABLE + 3
#define PMERR_INVALID_SOURCE      PMERROR_ENABLE + 4
#define PMERR_FONT_OPEN_FAILED    PMERROR_ENABLE + 5
#define PMERR_NO_MODULE_HANDLE    PMERROR_ENABLE + 6
#define PMERR_INVALID_CONFIG      PMERROR_ENABLE + 7
#define PMERR_FONTS_MISSING       PMERROR_ENABLE + 8

#define PMERR_INVALID_MIX_OPTION  PMERROR_BITMAPS
#define PMERR_NOT_DIRECT_DC       PMERROR_BITMAPS + 1

#define PMERR_SHAPE_DEVICE_FONT   PMERROR_ATTRIBUTES
#define PMERR_SHAPE_VECTOR_FONT   PMERROR_ATTRIBUTES + 1
#define PMERR_SHAPE_BITMAP        PMERROR_ATTRIBUTES + 2

#define PMERR_NO_HEAP_SEG         PMERROR_GENERAL

