/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDENABL                                       */
/*                                                                    */
/*   Description     = Enable Main Entry Point                        */
/*                                                                    */
/*   Function        = Enable directs processing to a given           */
/*                     subfunction.                                   */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#include <eddinclt.h>

#include <eddecone.h>
#include <eddetypt.h>
#include <eddeextf.h>

/**********************************************************************/
/* This count helps us with debugging.                                */
/* NB. This is a global value, but it is NOT protected by the enter   */
/* driver semaphore.  We do not grab the enter driver semaphore in    */
/* this file because it is not needed for all enable sub functions.   */
/* Those that do need it grab it at a lower level.                    */
/**********************************************************************/
ULONG   EnableCount = 0;

/**********************************************************************/
/* Enable just switches to the required Enable subfunction.           */
/**********************************************************************/

ULONG EXPENTRY OS2_PM_DRV_ENABLE (ULONG subfunc,
                                  PVOID param1,
                                  PVOID param2)
{
#define TFUNC "OS2_PM_DRV_ENBL"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    ULONG       Result;                /* result of subfunction       */

    /******************************************************************/
    /* WARNING, no tracing is allowed before FillLdb is called as that*/
    /* is where trace file is initialized. In addition no tracing is  */
    /* allowed after DisablePdb which closes the trace file.          */
    /******************************************************************/

    /******************************************************************/
    /* Knowing how many times we have been called help debugging.     */
    /******************************************************************/
    EnableCount++;

    /******************************************************************/
    /* Switch according to subfunction                                */
    /******************************************************************/
    switch  (subfunc)
    {

    case EN_FILL_LDB:
        Result = FillLdb((pFLParamsLst)param1,
                         (pFLReturnsLst)param2);
        break;

    case EN_FILL_PDB:
    case EN_FILL_IPDB:
        /**************************************************************/
        /* Use the same routine to fill the physical device block     */
        /* whatever DC Type it may be called from.                    */
        /**************************************************************/
        return FillPdb();

    case EN_ENABLE_DC:
        return EnableDC((pEDCParamsLst)param1);

    case EN_DISABLE_DC:
        Result = DisableDC((PDC)param1);
        break;

    case EN_SAVE_DC:
        Result = SaveDC((PDC) param1);
        break;

    case EN_RESTORE_DC:
        Result = RestoreDC((PDC) param1,
                           (LONG)param2);
        break;

    case EN_RESET_DC:
        Result = ResetDC((PDC) param1);
        break;

    case EN_DISABLE_PDB:
    case EN_COMPLETE_OPEN:
    case EN_BEGIN_CLOSE:
        /**************************************************************/
        /* These are no-ops for displays so just return success.      */
        /*                                                            */
        /* In theory we thought DisablePdb could never be used on the */
        /* display (since the display never terminates), but in       */
        /* practice brute force printer drivers call it.              */
        /**************************************************************/
        Result = OK;
        break;

    default:
        LOGERR(TFUNC, "Bad subfunction",
                                    &subfunc, 1, PMERR_BAD_SUBFUNCTION);
        Result = (USHORT)ERROR_ZERO;
        break;

    }                                  /* subfunction switch          */

    /******************************************************************/
    /* At this point Result should contain either 1 (OK) or 0 (error).*/
    /* These are the internal error codes used throughout the device  */
    /* driver. However Enable is required to return 0 (DOS_OK) or -1  */
    /* (error) so a conversion is made.                               */
    /******************************************************************/
    if (Result == OK)
    {
        return(DOS_OK);
    }
    else
    {
        return(ERROR_NEG);
    }
}
#undef TFUNC
