/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDEEDC                                        */
/*                                                                    */
/*   Description     = Enable : subfunction Enable Device Context     */
/*                                                                    */
/*   Function        = Enable allocates memory for and initialises a  */
/*                     new DC.                                        */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DOSDEVICES
#define INCL_DDICOMFLAGS
#define INCL_WINP_MISC
#include <eddinclt.h>

#include <eddconty.h>
#include <eddacone.h>
#include <eddecone.h>

#include <edddtypt.h>
#include <eddetypt.h>

#include <eddaextf.h>
#include <eddeextf.h>
#include <eddgextf.h>

#include <memman.h>

/**********************************************************************/
/* private functions                                                  */
/**********************************************************************/
BOOL initialise_dc(VOID);

/**********************************************************************/
/* globals                                                            */
/**********************************************************************/
extern DDTType             DDT;
extern USHORT              DefaultFontListIndex;
extern BitmapHeader        DirectListEntry;
extern BitmapHeader        DummyInfoBitmap;

#ifdef MATROX
extern BitmapHeader        VRAMBitmap;
extern ADAPTERINFO         aiXGAAdapter;
#endif /* MATROX */

/**********************************************************************/
/* EnableDC allocates memory for and initialises a new DC.            */
/**********************************************************************/
ULONG EnableDC (pEDCParamsLst  param1)
{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    PDC                 pdcNew;        /* DC instance data pointer    */


    /******************************************************************/
    /* We are going to update the global pdc and so need to grab the  */
    /* drivers semaphore                                              */
    /******************************************************************/
    EnterDriver(NULL, FUNN_UNKNOWN, EDF_EXCLUSIVE | EDF_DC_NULL);

    /******************************************************************/
    /* Check for a valid DC type. Only supported types are Direct,    */
    /* Information and Memory.                                        */
    /******************************************************************/
    if (param1->DcType != OD_DIRECT &&
        param1->DcType != OD_MEMORY &&
        param1->DcType != OD_INFO)
    {
        LogError(PMERR_INV_DC_TYPE);
        goto ENABLEDC_FAST_ERR_EXIT;
    }

    /******************************************************************/
    /* Allocate memory for the DC instance data.                      */
    /******************************************************************/
    /******************************************************************/
    /* This (and subsequent operations) do not need protection, as    */
    /* DCs are single-threaded.                                       */
    /******************************************************************/
    pdcNew = AllocateMemory( sizeof(DC),
                             MT_DC,
                             MO_PRIVATE );
    if (pdcNew == NULL)
    {
        /**************************************************************/
        /* The allocation failed so we must return an error.          */
        /**************************************************************/
        goto ENABLEDC_FAST_ERR_EXIT;
    }

    /******************************************************************/
    /* Put the PDC in our global copy in case we call any subroutines */
    /* which use the global copy                                      */
    /******************************************************************/
    pdc = pdcNew;

    /******************************************************************/
    /* Save the DC Type and handle. The latter is used for            */
    /* subsequent call-backs.                                         */
    /******************************************************************/
    pdc->DCIDCType = param1->DcType;
    pdc->DCIhdc    = param1->DcH;

    /******************************************************************/
    /* Set count of saved DC states to zero and NextEntry pointer to  */
    /* null as the DC cannot have been saved yet.                     */
    /******************************************************************/
    pdc->DCISaveCount = 0;
    pdc->DCINextEntry = NULL;

    /******************************************************************/
    /* Reset 'dirty' flag to indicate that clip regions are valid     */
    /******************************************************************/
    pdc->DCIIsDirty = FALSE;

    /******************************************************************/
    /* we want to prevent any drawing to INFO_DCs                     */
    /******************************************************************/
    if (param1->DcType == OD_INFO)
    {
        pdc->DCICommandMask = ~((USHORT)(COM_DRAW >> 16));
    }
    else
    {
        /**************************************************************/
        /* Set the Command mask to all ones so that it has no effect  */
        /**************************************************************/
        pdc->DCICommandMask = 0xFFFF;
    }

    /******************************************************************/
    /* Get the default codepage and set the appropriate code page     */
    /* address for the base font in the DC Data                       */
    /******************************************************************/
    pdc->DCICodePage = WinQueryProcessCP();

#ifdef DBCS                                                 
    pdc->DCIOriginalCodePage = pdc->DCICodePage;
                                       /* save enable-time codepage   */
#endif 

    pdc->CurrentFont.usCodePage = 0;

    /******************************************************************/
    /* Current attributes bundles are initialised to the global       */
    /* defaults - done by calling SetAttributes subroutines           */
    /* requesting that all values are set to defaults in subroutine   */
    /* set_dc_defaults.                                               */
    /******************************************************************/
    pdc->DCIChanged =  NOTDEFAULT_TextAttrs |
                       NOTDEFAULT_LineAttrs |
                       NOTDEFAULT_MarkAttrs |
                       NOTDEFAULT_PtrnAttrs |
                       NOTDEFAULT_ImagAttrs |
                       NEW_MARKER_SYMBOL |
                       NEW_PATTERN_SYMBOL;

    /******************************************************************/
    /* select the default colour format                               */
    /* this will cause the colour table to be reset when              */
    /* set_dc_defaults is called (via initialise_dc)                  */
    /******************************************************************/
    pdc->DCIColFormat = LCOLF_RGB;
    pdc->Palette      = NULL;

    /******************************************************************/
    /* No need to allocate memory for a pool of clip rectangles since */
    /* we have a fixed sized cache which is located within the        */
    /* instance data                                                  */
    /******************************************************************/

    /******************************************************************/
    /* Mark that there is memory for clip rectangles available but    */
    /* none for correlation rectangles yet. This is allocated as      */
    /* required.                                                      */
    /******************************************************************/
    pdc->DCICorrSize = 0;

    /******************************************************************/
    /* Set the defaults in the DC Instance Data                       */
    /******************************************************************/
    if ( !initialise_dc() )
    {
        goto ENABLEDC_SETDEF_ERR_EXIT;
    }

    /******************************************************************/
    /* Clear the pointer to the pattern. This is needed to tell the   */
    /* set attributes routine that temp pattern does not point to a   */
    /* valid bitmap header                                            */
    /******************************************************************/
    pdc->TempPattern = 0;

    /******************************************************************/
    /* Clear the pointer to the marker.                               */
    /******************************************************************/
    pdc->DCIMarker = 0;

    /******************************************************************/
    /* Now release the driver semaphore                               */
    /******************************************************************/
    ExitDriver(NULL, FUNN_UNKNOWN, EDF_EXCLUSIVE | EDF_DC_NULL);

    /******************************************************************/
    /* DC enabled. Return OK.                                         */
    /******************************************************************/
    return((ULONG)pdcNew);

ENABLEDC_SETDEF_ERR_EXIT:
    /******************************************************************/
    /* Release the DC instance data memory.                           */
    /******************************************************************/
    FreeMemory( pdc );

ENABLEDC_FAST_ERR_EXIT:
    /******************************************************************/
    /* No memory to release. Just return - but first release the      */
    /* driver semaphore.                                              */
    /******************************************************************/
    ExitDriver(NULL, FUNN_UNKNOWN, EDF_EXCLUSIVE | EDF_DC_NULL);

    return((LONG)ERROR_NEG);
} /* edde_enabledc */







/**********************************************************************/
/* Initialises DC values at enable DC time.                           */
/**********************************************************************/
BOOL initialise_dc(VOID)
{
    ULONG   i;

    /**************************************************************/
    /* Set the DC origin                                          */
    /**************************************************************/
    pdc->DCIOrigin.X =
    pdc->DCIOrigin.Y = 0;

    /**************************************************************/
    /* Set the initial transformation                             */
    /**************************************************************/
    pdc->DCITransform.fxM11 =
    pdc->DCITransform.fxM22 = 1;
    pdc->DCITransform.fxM12 =
    pdc->DCITransform.fxM21 =
    pdc->DCITransform.lM41  =
    pdc->DCITransform.lM42  = 0;

    /**************************************************************/
    /* Set the initial transformation type                        */
    /**************************************************************/
    pdc->DCIXFrmSimple = TRUE;

    /**************************************************************/
    /* Set the bounding clip rectangle and initial bitmap type.   */
    /**************************************************************/
    pdc->DCIBoundingClip[0].X =
    pdc->DCIBoundingClip[0].Y = 0;

    if (pdc->DCIDCType == OD_DIRECT)
    {
        /**************************************************************/
        /* If direct DC set clip to screen                            */
        /**************************************************************/
        pdc->DCIBoundingClip[1].X = DirectListEntry.Info.HWWidth;
        pdc->DCIBoundingClip[1].Y =
               pdc->DCIConvFactor = DirectListEntry.Info.HWHeight;
        pdc->DCIBitmapType        = BITMAP_IS_SCREEN;
        pdc->DCISelListEntry      = &DirectListEntry;
    }
    else if (pdc->DCIDCType == OD_MEMORY)
    {
        /**************************************************************/
        /* If memory DC set clip to zero as no bitmap selected.       */
        /**************************************************************/
        pdc->DCIBoundingClip[1].X =
        pdc->DCIBoundingClip[1].Y =
               pdc->DCIConvFactor = 0;
        pdc->DCIBitmapType        = BITMAP_NOT_SELECTED;
        pdc->DCISelListEntry      = NULL;
    }
    else if (pdc->DCIDCType == OD_INFO)
    {
        /**************************************************************/
        /* Info DC's are strange - to avoid crashes when someone      */
        /* tries to draw to them we make sure they have a valid, but  */
        /* dummy bitmap selected into it.                             */
        /**************************************************************/
        pdc->DCIBoundingClip[1].X = DummyInfoBitmap.Info.HWWidth;
        pdc->DCIBoundingClip[1].Y =
               pdc->DCIConvFactor = DummyInfoBitmap.Info.HWHeight;
        pdc->DCIBitmapType        = BITMAP_IS_DUMMY;
        pdc->DCISelListEntry      = &DummyInfoBitmap;
    }

    /**************************************************************/
    /* set the default clip region                                */
    /**************************************************************/
    pdc->DCIClipNum       = 1;
    pdc->DCIClipRects->X0 = pdc->DCIBoundingClip[0].X;
    pdc->DCIClipRects->Y0 = pdc->DCIBoundingClip[0].Y;
    pdc->DCIClipRects->X1 = pdc->DCIBoundingClip[1].X;
    pdc->DCIClipRects->Y1 = pdc->DCIBoundingClip[1].Y;

    pdc->DCIEngineClips = 1;
    pdc->DCIClipOrder   = (USHORT)RECTDIR_LFRT_TOPBOT;

    /**************************************************************/
    /* Reset the user bounds. These are not reset on ResetDC      */
    /**************************************************************/
    pdc->DCIDefUserBounds = TRUE;

    /**************************************************************/
    /* Set the font ID to an invalid value                        */
    /**************************************************************/
    pdc->CurrentFont.usFontID = (USHORT) -1;

    /**************************************************************/
    /* Do equivalent for the AVIO fonts                           */
    /**************************************************************/
    for ( i = 0 ; i <= CNT_LOADABLE_LCIDS ; i++ )
    {
        pdc->DCIAvioFonts[i].pFocaFont = NULL;
        pdc->DCIAvioFonts[i].usFontID  = (USHORT)-1;
    }

    /**************************************************************/
    /* now set the dc defaults values, ie. those reset on resetDC */
    /**************************************************************/
    return( set_dc_defaults() );

} /* initialise_dc */
