/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDDLG                                         */
/*                                                                    */
/*   Description     = Display Device Dialog Box constants & types    */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/* start at 256 since system commands etc use values upto 255 */

#define DLG_FONTBOX           258
#define DLG_RESBOX            259
#define DLG_ON                260
#define DLG_OFF               261
#define DLG_HIGH              262
#define DLG_LOW               263
#define DLG_ENTER             264
#define DLG_CANCEL            265
#define DLG_HELP              266

#define HighAA256             270
#define High256               271
#define LowAA256              272
#define Low256                273
#define High16                274
#define Low16                 275

#define LowAA64Mono           280
#define Low64Mono             281
#define LowAA16Mono           282
#define Low16Mono             283

#define XWAY_HIGHONLY         290
#define XWAY_HIGHORLOW        291
#define XWAY_LOWONLY          292
#define XWAY_LOWSTANDARD      293
#define XWAY_MONOEIGHT        294
#define XWAY_MONOFOUR         295
#define XWAY_HELP             296

#define DSS_CONFIG            300
#define BOSTON_CONFIG         301
#define NOAA_BOSTON_CONFIG    302

#define BostonHighStandard    305
#define BostonHighReadEasy    306
#define BostonLowStandard     307
#define BostonLowReadEasy     308

#define IDM_REBOOT            0x2200
#define IDM_NOTE              0x2201
#define IDM_NO_SETUP1         0x2202
#define IDM_NO_SETUP2         0x2203
#define IDS_GROUP_TITLE       0x2204
#define IDS_FONT_SELECTION    0x2205
#define IDS_SCREEN_CONFIG     0x2206
#define IDM_HELP              0x2207
#define IDM_1M_STRING         0x2208
#define IDM_1M_HELP           0x2209

/**********************************************************************/
/* OS2.INI Data types                                                 */
/**********************************************************************/

typedef struct
    {
        BYTE    AntiAliasFlag;         /* 0 = OFF, 1 = ON             */
        BYTE    Resolution;            /* H = High, L = Low           */
        BYTE    MonoColourFlag;        /* M = Mono, C = Colour        */
        BYTE    MonitorType;           /* see EDDECONE.H for meaning  */
        BYTE    BoardType;             /* X = XWAY, D = DSS           */
        BYTE    VRAMSize[4];           /* size of VRAM in K bytes     */
        BYTE    Terminator;            /* NULL terminator of string   */
    } OS2INIFlags;


#define MAXPATHLENGTH 128
