/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifdef EDD_DEBUG
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDDEBUG                                       */
/*                                                                    */
/*   Description     = Display Device Driver debugger functions       */
/*                                                                    */
/*   Function        = Communicate with the debugger.                 */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* The functions available all write to the debug terminal and only   */
/* work if the value of the global variable DebugOn is TRUE           */
/* (non-zero). This can be changed using the debugger to easily turn  */
/* on or off the output.                                              */
/*                                                                    */
/* CrLf(VOID)  -  Writes a carriage return/line feed sequence to the  */
/*                the debug terminal.                                 */
/*                                                                    */
/* OutputValue(ULONG Value,USHORT Base) -                             */
/*                Writes the value to the debug terminal in the       */
/*                specified base.                                     */
/*                Note: the base is specified as a numeric value      */
/*                                                                    */
/*                e.g. OutputValue(DecimalValue, 10);                 */
/*                e.g. OutputValue(BinaryValue, 2);                   */
/*                                                                    */
/* OutputString(PCHAR String) -                                       */
/*                Outputs the specified string to the debug terminal, */
/*                followed by a CrLf.                                 */
/*                                                                    */
/* OutputPair(PCHAR String,ULONG Value,USHORT Base) -                 */
/*                This combines the above two functions by            */
/*                writing the specified string, along with the given  */
/*                value in the given base(s), followed by a CrLf.     */
/*                                                                    */
/*                Note that the bases are specified by pre-defined    */
/*                constants( BINARY, DECIMAL, HEX) and they can       */
/*                be combined using a binary OR.                      */
/*                e.g. OutputPair("Number = ", Number, DECIMAL);      */
/*                e.g. OutputPair("Address = ", Address, BINARY|HEX); */
/*                                                                    */
/**********************************************************************/
#define  EDDDEBUG
#include <eddinclt.h>

BOOL DebugOn = 1;
BOOL WaitForKey = 0;

VOID FAR PASCAL CrLf(VOID);
VOID FAR PASCAL OutputValue(ULONG, USHORT);
VOID FAR PASCAL OutputPair(PCHAR,ULONG,USHORT);
VOID FAR PASCAL OutputString(PCHAR);

VOID FAR PASCAL CrLf(VOID)
{
    if (DebugOn)
        DebugOutput("\n\r");
}

VOID FAR PASCAL OutputValue(ULONG  Value,
                            USHORT Base)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    CHAR     Digit;
    CHAR     String[2];

    if ( (Base == 10) && ((LONG)Value < 0) )
    {
        DebugOutput("-");
        OutputValue( -(LONG)Value,10 );
        return;
    }

    if (Value > Base-1)
    {
        OutputValue(Value/Base,Base);
    }

    Digit = (CHAR)(Value % Base);
    String[0] = (Digit < 10) ? (Digit + '0') : (Digit + 'A'-10);
    String[1] = 0;
    DebugOutput(String);
}



VOID FAR PASCAL OutputString(PCHAR String)
{
    if (DebugOn)
    {
        DebugOutput(String);
        CrLf();
    }
}



VOID FAR PASCAL OutputPair(PCHAR  String,
                           ULONG  Value,
                           USHORT Base)
{
    if (DebugOn)
    {
        DebugOutput(String);
        DebugOutput("  ");
        if (Base & DECIMAL)
        {
            OutputValue(Value,10);
            DebugOutput("  ");
        }
        if (Base & HEX)
        {
            DebugOutput("0x");
            OutputValue(Value,16);
            DebugOutput("  ");
        }
        if (Base & BINARY)
        {
            DebugOutput("0b");
            OutputValue(Value,2);
        }
        CrLf();
    }
}
#endif /* EDD_DEBUG */
