/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDCONSE                                       */
/*                                                                    */
/*   Description     = Display Device Driver constants                */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* We used to have to distinguish FNULL and NULL, but now they are    */
/* the same in 32bit flat model                                       */
/**********************************************************************/
#define FNULL   NULL

/**********************************************************************/
/* COORD_* are co-ordinate identifiers as used by convert.            */
/**********************************************************************/
#define COORDS_TYPE           0x0F
#define COORDS_ARE_WORDS      0x10
#define COORDS_ARE_AI         0x20

#define COORD_WORLD           0x01
#define COORD_MODEL           0x02
#define COORD_DEFAULT_PAGE    0x03
#define COORD_PAGE            0x04
#define COORD_DEVICE          0x05

#define COORD_WORLD_WORD      0x11
#define COORD_DEVICE_WORD     0x15

#define COORD_AI              0x35

#define CALLED_FROM_BLT       0x80

/**********************************************************************/
/* DC bitmap type constants                                           */
/**********************************************************************/
#define BITMAP_NOT_SELECTED       1
#define BITMAP_IS_SMALL           2
#define BITMAP_IS_DUMMY           3
#define BITMAP_IS_SCREEN          8

/**********************************************************************/
/* Guard area size. Currently the screen size. Defined as being       */
/* inclusive of the edges i.e. only clip when an point is > 639 say.  */
/* Temporary Usage : values hard-coded for a particular mode          */
/**********************************************************************/
#define GUARD_LOW_X               0
#define GUARD_HIGH_X           2000
#define GUARD_LOW_Y               0
#define GUARD_HIGH_Y           2000

/**********************************************************************/
/* constants for anti aliased text interpolation routines             */
/**********************************************************************/
#define numberoflevels 8

/**********************************************************************/
/* Flags used when allocating memory with AllocSeg and AllocHuge      */
/**********************************************************************/
#define    ZERO_ALLOC_GROWTH        0
#define    SHAREABLE_WITH_GETSEG    2

/**********************************************************************/
/* Constant for the size of clip and pick rectangles memory saved     */
/**********************************************************************/
#define    NUM_RECTANGLES           8

/**********************************************************************/
/* Constant for the size of the PolyScanLine data                     */
/**********************************************************************/
#define   SCAN_SIZE                 500

/**********************************************************************/
/* pattern table constants                                            */
/**********************************************************************/
#ifdef NEW_PATTERNS
#define NUMBER_PATTERNS         19      /* No. of predefined patterns */
#define PATSYM_DITHERED         19      /* index for dither pattern   */
#define PATSYM_MONODITH         20      /* index for mono dith pattern*/
#else /* NEW_PATTERNS */
#define NUMBER_PATTERNS         17      /* No. of predefined patterns */
#define PATSYM_DITHERED         17      /* index for dither pattern   */
#define PATSYM_MONODITH         18      /* index for mono dith pattern*/
#endif /* NEW_PATTERNS */

#ifdef DBCS                                                 
/**********************************************************************/
/* string limit for CharString.. functions                            */
/*      we put it here since we want to use it in EDDTYPET.H          */
/**********************************************************************/
#define MAX_CHARSTRING_LENGTH   512
                                       /* We will handle only this    */
                                       /* length of string.  This     */
                                       /* enables us to make a lot of */
                                       /* buffers for DBCS handling   */
                                       /* static, rather than getting */
                                       /* them dynamic.  This limit   */
                                       /* is same to ATLAS/VGA DBCS.  */
#endif 
