/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDCEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     Color routines                                 */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Hooked functions.                                                  */
/**********************************************************************/
DDIENTRY eddc_QueryColorData (HDC       hdc,
                              ULONG     ArgCount,
                              PULONG    ArgArray,
                              PDC       pdcArg,
                              ULONG     FunN);

DDIENTRY eddc_QueryLogColorTable (HDC           hdc,
                                  ULONG         ArgOptions,
                                  ULONG         ArgStart,
                                  ULONG         ArgCount,
                                  PULONG        ArgArray,
                                  PDC           pdcArg,
                                  ULONG         FunN);

DDIENTRY eddc_CreateLogColorTable (HDC           hdc,
                                   ULONG         ArgOptions,
                                   ULONG         ArgFormat,
                                   ULONG         ArgStart,
                                   ULONG         ArgCount,
                                   PULONG        ArgData,
                                   PDC           pdcArg,
                                   ULONG         FunN);

DDIENTRY eddc_RealizeColorTable (HDC          hdc,
                                 PDC          pdcArg,
                                 ULONG        FunN);

DDIENTRY eddc_UnrealizeColorTable (HDC          hdc,
                                   PDC          pdcArg,
                                   ULONG        FunN);

DDIENTRY eddc_QueryRealColors (HDC           hdc,
                               ULONG         ArgOptions,
                               ULONG         ArgStart,
                               ULONG         ArgCount,
                               PULONG        ArgArray,
                               PDC           pdcArg,
                               ULONG         FunN);

DDIENTRY eddc_QueryNearestColor (HDC          hdc,
                                 ULONG        ArgOptions,
                                 ULONG        ArgRGBColorIn,
                                 PDC          pdcArg,
                                 ULONG        FunN);

DDIENTRY eddc_QueryColorIndex (HDC          hdc,
                               ULONG        ArgOptions,
                               ULONG        ArgRGBColor,
                               PDC          pdcArg,
                               ULONG        FunN);

DDIENTRY eddc_QueryRGBColor (HDC           hdc,
                             ULONG         ArgOptions,
                             LONG          lLogIndex,
                             PDC           pdcArg,
                             ULONG         FunN);

/**********************************************************************/
/* Internal routines.                                                 */
/**********************************************************************/
VOID DRIVERCALL InitDefaultColorTables (VOID);

ULONG DRIVERCALL  LogToPhyIndex(LONG LogIndex);

ULONG DRIVERCALL rgb2_diff (RGB2 rgb1,
                            RGB2 rgb2);

RGB2 DRIVERCALL NearestDefaultPhysicalColor (RGB2  RGBColor);

ULONG DRIVERCALL NearestDefaultPhysicalIndex (RGB2  RGBColor);

ULONG DRIVERCALL NearestDirectDefaultPhysicalIndex (RGB2  RGBColor);

ULONG DRIVERCALL NearestMemoryDefaultPhysicalIndex (RGB2  RGBColor);

ULONG DRIVERCALL NearestRealizableIndex(RGB2  RGBColor);

ULONG DRIVERCALL NearestLogicalColor (ULONG     Options,
                                      RGB2      RGBColor);

ULONG DRIVERCALL SearchRealizedLCTPalette (RGB2  RGBColor);

ULONG DRIVERCALL InnerSearchRealizedLCTPalette (RGB2  RGBColor);

VOID DRIVERCALL eddc_PropagateSysColorChanges(VOID);

VOID DRIVERCALL eddc_ResetLogColorTable(VOID);

BOOL DRIVERCALL eddc_SetDithColourAndPattern(ULONG Colour);

VOID DRIVERCALL eddc_UpdateAttributes(VOID);

ULONG DRIVERCALL eddc_AlterSysColorTable (ULONG         ulFormat,
                                          LONG          lStart,
                                          ULONG         ulCount,
                                          PULONG        pData);


#ifndef _8514
VOID DRIVERCALL LoadPaletteEntries(ULONG   start,
                                   ULONG   count,
                                   PRGB2   lpPaletteEntries);

VOID DRIVERCALL LoadPaletteEntriesWorker(ULONG   start,
                                         ULONG   count,
                                         PRGB2   lpPaletteEntries);

VOID DRIVERCALL LoadDirectPalette(VOID);

#else
VOID DRIVERCALL Load8514PaletteEntries(ULONG   start,
                                    ULONG   count,
                                    PRGB2   lpPaletteEntries);

VOID DRIVERCALL Load8514DirectPalette(VOID);

#endif

VOID DRIVERCALL LoadDirectPaletteWorker(VOID);

VOID DRIVERCALL plasma_type_worker(VOID);

ULONG DRIVERCALL PhyToLogIndex(ULONG   ulPhyIndex);

ULONG DRIVERCALL ExactDefaultPhysicalIndex(ULONG RGBColor);

VOID DRIVERCALL CalculateColorTablePhysicalIndices(VOID);

ULONG InnerNearestDefaultPhysicalIndex(RGB2  RGBColor,
                                       PRGB2 DeviceDefaultPalette,
                                       ULONG ulDeviceDefaultPaletteSize);

VOID FudgePalettesAndGenerateTables(VOID);

VOID MakePalettesISOCompliant(VOID);
