/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDBEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     Bitmap routines                                */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

DSPENTRY eddb_DrawBorder(HDC            hdc,
                         pWcsRect       ArgFrame,
                         ULONG          ArgBorderWidth,
                         ULONG          ArgBorderHeight,
                         ULONG          ArgBorderColor,
                         ULONG          ArgInteriorColor,
                         ULONG          ArgOptions,
                         PDC            pdcArg,
                         ULONG          FunN);

DSPENTRY eddb_PolyMarker (HDC        hdc,
                          PPOINTL    Points,
                          ULONG      NoOfPoints,
                          PDC        pdcArg,
                          ULONG      FunN);

DSPENTRY eddb_DeviceCreateBitmap (HDC                   hdc,
                                  PBITMAPINFOHEADER     ArgBitmapInfo,
                                  ULONG                 ArgUsage,
                                  lpBitmap              ArgInitBits,
                                  PBITMAPINFO           ArgInitInfo,
                                  PDC                   pdcArg,
                                  ULONG                 FunN);

DSPENTRY eddb_DeviceDeleteBitmap (HDC              hdc,
                                  pBitmapHeader    ArgHandle,
                                  PDELETERETURN    ArgReturns,
                                  ULONG            ArgUsage,
                                  PDC              pdcArg,
                                  ULONG            FunN);

DSPENTRY eddb_DeviceSelectBitmap (HDC             hdc,
                                  lpBitmap        ArgHandle,
                                  PDC             pdcArg,
                                  ULONG           FunN);

DSPENTRY GetBitmapBits (HDC          hdc,
                        HBITMAP      hBitmap,
                        LONG         lScanStart,
                        LONG         clScanCount,
                        PBYTE        pAddress,
                        PBITMAPINFO2 pInfo,
                        PDC          pdcArg,
                        ULONG        FunN);

DSPENTRY SetBitmapBits (HDC          hdc,
                        HBITMAP      hBitmap,
                        LONG         lScanStart,
                        LONG         clScanCount,
                        PBYTE        pAddress,
                        PBITMAPINFO2 pInfo,
                        PDC          pdcArg,
                        ULONG        FunN);

DSPENTRY eddb_SetPel (HDC        hdc,
                      PPOINTL    ArgPoint,
                      PDC        pdcArg,
                      ULONG      FunN);

DSPENTRY eddb_GetPel (HDC        hdc,
                      PPOINTL    ArgPoint,
                      PDC        pdcArg,
                      ULONG      FunN);

DSPENTRY eddb_ImageData (HDC           hdc,
                         PBYTE         ArgData,
                         ULONG         ArgNumber,
                         ULONG         ArgRow,
                         PDC           pdcArg,
                         ULONG         FunN);

DSPENTRY eddb_BitBlt (HDC                  hdc,
                      LHANDLE              ArgSource,
                      ULONG                ArgCount,
                      PLONG                ArgCoords,
                      ULONG                ArgRop,
                      ULONG                ArgOptions,
                      PBITBLTATTRS         ArgAttrs,
                      PDC                  pdcArg,
                      ULONG                FunN);

/**********************************************************************/
/* Internal Routines                                                  */
/**********************************************************************/
VOID PASCAL NEAR eddb_FastDrawRectangle(VOID);

USHORT PASCAL eddb_AllocMemForBitmap (pBitmapHeader  pHeader);

VOID PASCAL eddb_FreeMemForBitmap (pBitmapHeader        ListEntry);

VOID ConvertExtToInt( PBYTE         pbSourceBitmap,
                      PBITMAPINFO2  pSourceHeader,
                      pBitmapHeader pbhTargetBitmap,
                      PPOINTL       pptlScanStart,
                      LONG          lScanLines);

VOID PASCAL ConvertIntToExt( PBYTE         pbTargetBitmap,
                             PBITMAPINFO2  pTargetHeader,
                             pBitmapHeader pbhSourceBitmap,
                             PPOINTL       pptlScanStart,
                             LONG          lScanLines);

pBitmapHeader PASCAL BMConvIntToInt (PDC           pdcSource,
                                     pBitmapHeader pbhSourceBitmap,
                                     USHORT        usColour,
                                     USHORT        usBackColour);

VOID PASCAL eddb_FillBitmap(pBitmapHeader   BMHeader,
                            BYTE            BackgroundColour);

pBitmapHeader PASCAL eddb_AllocBitmapHeader(VOID);

VOID PASCAL NEAR eddb_BltToDestination(VOID);

VOID PASCAL NEAR eddb_BltSourceToDestination(VOID);

#ifdef DCAF                                                               //DCAF
SHORT PASCAL NEAR blt_one_pel(POINTS  pel_coord,                          //DCAF
                              USHORT  Mix,                                //DCAF
                              ULONG   FunN);                              //DCAF
#else                                                                     //DCAF
SHORT PASCAL NEAR blt_one_pel(POINTS  pel_coord,
                              USHORT  Mix);
#endif                                                                    //DCAF

VOID PASCAL PixBltThroughClips(VOID);

VOID PASCAL PixBltThroughClipsViaPHUNK(VOID);

VOID PASCAL FAR eddb_DrawThroughClips(VOID (PASCAL NEAR *Function)(),
                                      USHORT *           pNumClips);

VOID PASCAL NEAR eddb_BltThroughGiantClips(VOID (PASCAL NEAR *BltFunction)());

#ifdef SDBM20
VOID PASCAL FAR eddb_CreatePhunk(VOID);

VOID PASCAL NEAR eddb_PhunkThatBitmap(pBitmapHeader pLockThis);

VOID PASCAL NEAR eddb_KnuhpThatBitmap(pBitmapHeader pUnLockThis);

VOID PASCAL FAR eddb_far_PhunkThatBitmap(pBitmapHeader pLockThis);

VOID PASCAL FAR eddb_far_KnuhpThatBitmap(pBitmapHeader pUnLockThis);

VOID PASCAL NEAR eddb_PhunkThatScreen(VOID);

VOID SimpleSourceDestPixBlt( VOID );
#endif /* SDBM20 */

#ifdef PALETTE_MGR
VOID PASCAL NEAR eddb_CreatePalMapping(PDC   pdcSrc);

VOID PASCAL NEAR eddb_ConvertPhunk(ULONG PhunkSize);

VOID PASCAL NEAR HWPaletteChanged( VOID );

VOID PASCAL NEAR ChangedPalette ( PDEVPAL pPalette);

VOID PASCAL NEAR ChangedColorTable ( PCOLORTABLE pColorTable);
#endif /* PALETTE_MGR */

#ifdef BMHEADER2
BOOL uncompress_bitmap(PBITMAPINFO2 FAR * ArgInfo2,
                       PBYTE FAR *        ArgBits,
                       PBOOL              converted);

BOOL validate_header(PBITMAPINFOHEADER ArgInfo);
#endif /* BMHEADER2 */

VOID convert_BMix_to_ColComp(ULONG ArgOptions,
                             PBITBLTATTRS  ArgAttrs);

VOID ExtToIntConversionSetUp( PBITMAPINFO2  pSourceHeader );
