/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/


/**********************************************************************/
/*                                                                    */
/*   File            = EDDBCONE                                       */
/*                                                                    */
/*   Description     = Display Device Driver Bitmap constants         */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* GetPel return value (-254) when no  index exists corresponding     */
/* to the colour                                                      */
/**********************************************************************/
#define NO_COLOUR_INDEX 0xffffff02L

/**********************************************************************/
/* ImageData constants                                                */
/**********************************************************************/
#define MAX_IMAGE_LENGTH  2040

/**********************************************************************/
/* Constants used for HSPATT                                          */
/**********************************************************************/
#define COLOURED_PATTERN     0x80
#define HSPATT_PACKED        0x40
#define HSPATT_MONO_LENGTH   0x0a
#define HSPATT_COLOUR_LENGTH 0x0e

/**********************************************************************/
/* Constants used for HBMC                                            */
/**********************************************************************/
#define HBMC_LENGTH          34        /* length with no pattern      */
#define HBMC_PATT_LENGTH     48        /* length with pattern         */

#define HBMC_DST_PC        0x4000      /* destination in PC RAM       */
#define HBMC_DST_VRAM      0x8000      /* destination in VRAM         */
#define HBMC_SRC_PC        0x1000      /* source in PC RAM            */
#define HBMC_SRC_VRAM      0x2000      /* source in VRAM              */
#define HBMC_PAT_PC        0x0400      /* pattern in PC RAM           */
#define HBMC_PAT_VRAM      0x0800      /* pattern in VRAM             */

/**********************************************************************/
/* Format constants used for HBBW and HBBR                            */
/**********************************************************************/
#define ACROSS_THE_PLANES_FORMAT   0x00
#define PACKED_FORMAT              0x01
#define THROUGH_THE_PLANES_FORMAT  0x08

/**********************************************************************/
/* Length constants for bitmap reads and writes                       */
/**********************************************************************/
#define HBBW_SUBRECT_LENGTH     18     /* length with sub-rectangle   */
#define HBBR_SUBRECT_LENGTH     20     /* length with sub-rectangle   */
#define HBBR_WHOLERECT_LENGTH   12     /* length with whole bitmap    */
#define HBBCHN_LENGTH            6


/**********************************************************************/
/* Standard Winthorn Bitmap Formats                               */
/**********************************************************************/
#define  STANDARD_FORMAT_PLANES          1
#define  STANDARD_FORMAT_BITCOUNT_1      1
#define  STANDARD_FORMAT_BITCOUNT_4      4
#define  STANDARD_FORMAT_BITCOUNT_8      8
#define  STANDARD_FORMAT_BITCOUNT_24     24

/**********************************************************************/
/* Size constants                                                     */
/**********************************************************************/
#define  CONSTANT_64K    0x10000
#define  CONSTANT_32K    0x8000

/**********************************************************************/
/* Constant to mask off the high bit in a byte                        */
/**********************************************************************/
#define  LOW_BIT         (Byte)0x01
#define  LOW_BIT_PAIR    (Byte)0x03
#define  HIGH_NIBBLE     (Byte)0xF0
#define  LOW_NIBBLE      (Byte)0x0F
#define  NIBBLE_SHIFT             4

/**********************************************************************/
/* Constants defining the type of a bitmap conversion                 */
/**********************************************************************/
#define  INTERNAL_TO_EXTERNAL     1
#define  TARGET_DATA_AT_ORIGIN    2
#define  SOURCE_DATA_AT_ORIGIN    4

/**********************************************************************/
/* Constants defining AI mixes                                        */
/**********************************************************************/
#define AIMIX_XOR       0x04

/**********************************************************************/
/* if bit 15 of the rop passed to bitblt is set then use grey rop     */
/**********************************************************************/
#define ROP_GREYROP_FLAG 0x8000
#define ROP_GREYROP      0xfa

/**********************************************************************/
/* constants for the three way blt instruction table                  */
/**********************************************************************/
#define BT_DEST  0
#define BT_WORK  1
#define BT_SRC   2
#define BT_PAT   3
#define BT_NONE  4

/**********************************************************************/
/* size of the marker coordinate buffer in the ds                     */
/**********************************************************************/
#define MAX_MARKERS 150

/**********************************************************************/
/* constants relating to the pattern table                            */
/**********************************************************************/
#define ENTRIES_IN_PATTERN_TABLE 18

/**********************************************************************/
/* PHUNK constants                                                    */
/* END_BYTES_PHUNK_OFFSET allows for addressing off the ends of a     */
/* bitmap stored in the PHUNK when doing bitblts. It is (a multiple   */
/* of) 4 so that the start address of the usable portion of the PHUNK */
/* will be DWORD aligned if the whole PHUNK is DWORD aligned. Also it */
/* is a multiple of 4 so that the actual PHUNK_SIZE is also a multiple*/
/* of 4 as assumed by eddb_ConvertPhunk in EDDPHUNK.ASM.              */
/* The usable PHUNK_SIZE must be greater than the size of a scan line */
/* as required by UpdateRectangle in UPDATE.ASM.                      */
/**********************************************************************/
#define EXTENDED_PHUNK_SIZE         65536
#define END_BYTES_PHUNK_OFFSET      4
#define PHUNK_SIZE                  (EXTENDED_PHUNK_SIZE -             \
                                            2 * END_BYTES_PHUNK_OFFSET)
#define HALF_OF_PHUNK_SIZE          (PHUNK_SIZE / 2)
