/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDASETB                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function           */
/*                     DeviceSetAttributes                            */
/*                                                                    */
/*   Function        = DeviceSetAttributes sets attributes in a given */
/*                     bundle type to either their default or a given */
/*                     value. It calls a separate subroutine for each */
/*                     bundle to perform this operation.              */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DOSSEMAPHORES
#include <eddinclt.h>
#include <eddacone.h>
#include <eddaextf.h>
#include <eddgextf.h>

#include <semaphor.h>

/**********************************************************************/
/* DeviceSetAttributes directs processing to one of the above         */
/* routines according to the bundle type.                             */
/**********************************************************************/

DDIENTRY edda_DeviceSetAttributes (HDC            hdc,
                                   ULONG          ArgBundleType,
                                   ULONG          ArgDefsMask,
                                   ULONG          ArgAttrsMask,
                                   PVOID          ArgAttributes,
                                   PDC            pdcArg,
                                   ULONG          FunN)

{
#define TFUNC "edda_DevSetAttr"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG              Result;         /* result of routine call      */

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* Apply the DC command mask to the command bits                  */
    /******************************************************************/
    COMMANDBITS(FunN) &= pdc->DCICommandMask;

    PROFILE_ENTER(23);

    /******************************************************************/
    /* Check for quick exit if nothing is being set!                  */
    /******************************************************************/
    if (!ArgAttrsMask)
    {
        Result = OK;
        goto SETATTRS_OK_EXIT;
    }

    /******************************************************************/
    /* Switch to appropriate subroutine according to bundle type.     */
    /******************************************************************/
    switch (ArgBundleType)
    {
    case PRIM_LINE:
        Result = SetLineAttributes(ArgDefsMask, ArgAttrsMask,
                                   (PDLINEBUNDLE)ArgAttributes);
        break;

    case PRIM_CHAR:
        Result = SetTextAttributes(ArgDefsMask, ArgAttrsMask,
                                   (PDCHARBUNDLE)ArgAttributes);
        break;

    case PRIM_MARKER:
        Result = SetMarkerAttributes(ArgDefsMask, ArgAttrsMask,
                                     (PDMARKERBUNDLE)ArgAttributes);
        break;

    case PRIM_AREA:
        Result = SetPatternAttributes(ArgDefsMask, ArgAttrsMask,
                                      (PDAREABUNDLE)ArgAttributes);
        break;

    case PRIM_IMAGE:
        Result = SetImageAttributes(ArgDefsMask, ArgAttrsMask,
                                    (PDIMAGEBUNDLE)ArgAttributes);
        break;

    default:
        LOGERR(TFUNC, "Unknown bundle", &ArgBundleType,1,UNKNOWN_PARM);
        Result = ERROR_ZERO;
        break;
    }

SETATTRS_OK_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    PROFILE_EXIT(23);
    return(Result);
}
#undef TFUNC
