/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDARFNT                                       */
/*                                                                    */
/*   Description     = Display Device Driver Realize Font             */
/*                                                                    */
/*   Function        = Called when the engine attempts to realize a   */
/*                     font. Returns indicating whether the driver    */
/*                     can realize the font.                          */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_DEV
#define INCL_DDIMISC
#define INCL_DDIMISC2                                       
#include <eddinclt.h>
#include <edddtypt.h>
#include <eddhcone.h>
#include <eddhtype.h>
#include <eddacone.h>
#include <edddcone.h>
#include <eddtcone.h>
#include <eddaextf.h>
#include <eddgextf.h>
#include <eddtextf.h>
#include <memman.h>

#ifdef DBCS                                                 
#include <eddjdef.h>
#include <eddjfm.h>
#include <eddjinit.h>
#include <eddjfont.h>
#endif                                                      

//#define INCL_GRE_FONTS
//#include <pmddim.h>

extern DDTType                DDT;

extern USHORT                 ResidentFonts;
extern USHORT                 DefaultFontListIndex;
#ifndef DBCS                                                
extern PINTFONT               pDefaultFont;
extern PVOID                  pResourceFont;
#else 
extern PFOCAFONT              pDefaultFont;
extern PFOCAFONT              pResourceFont;
#endif 


/**********************************************************************/
/* RealizeFont is called when:-                                       */
/* 1 The engine asks the driver if it can realize a device font for   */
/*   the logical font request.                                        */
/* 2 The driver is asked to turn an engine font into a device font.   */
/* 3 The driver is asked to delete a device font.                     */
/**********************************************************************/

#ifndef DBCS                                                
DDIENTRY edda_RealizeFont (HDC         hdc,
                           ULONG       ArgCommand,
                           ULONG       ArgLogFont,
                           ULONG       ArgEngFont,
                           PDC         pdcArg,
                           ULONG       FunN)


{
#define TFUNC "edda_RealizeFont"

    /******************************************************************/
    /* The engine is managing our font for us - we just return no     */
    /* match for realizing a font                                     */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(ArgCommand);
    IgnoreParam(ArgLogFont);
    IgnoreParam(ArgEngFont);
    IgnoreParam(pdcArg);
    IgnoreParam(FunN);

    return(NO_FONT_MATCH);
}
#undef TFUNC

#else                                                                   /*YOJN*/
                                                                        /*YOJN*/
ULONG MatchFont (PFATTRS ArgFont);                                      /*YOJN*/
                                                                        /*YOJN*/
DDIENTRY edda_RealizeFont (HDC         hdc,                             /*YOJN*/
                           ULONG       ArgCommand,                      /*YOJN*/
                           ULONG       ArgLogFont,                      /*YOJN*/
                           ULONG       ArgEngFont,                      /*YOJN*/
                           PDC         pdcArg,                          /*YOJN*/
                           ULONG       FunN)                            /*YOJN*/
{                                                                       /*YOJN*/
#define TFUNC "edda_RealizeFont"                                        /*YOJN*/
    /******************************************************************//*YOJN*/
    /* Local variables                                                *//*YOJN*/
    /******************************************************************//*YOJN*/
    ULONG            Result;           /* result to be returned       *//*YOJN*/
                                                                        /*YOJN*/
    /******************************************************************//*YOJN*/
    /* Get driver semaphore and perform entry checks                  *//*YOJN*/
    /******************************************************************//*YOJN*/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);           /*YOJN*/
                                                                        /*YOJN*/
    PROFILE_ENTER(26);                                                  /*YOJN*/
                                                                        /*YOJN*/
    /******************************************************************//*YOJN*/
    /* select option according to which bit is set in command         *//*YOJN*/
    /******************************************************************//*YOJN*/
                                                                        /*YOJN*/
    switch (ArgCommand)                                                 /*YOJN*/
    {                                                                   /*YOJN*/
    case RF_DEVICE_FONT:                                                /*YOJN*/
                                                                        /*YOJN*/
        /**************************************************************//*YOJN*/
        /* Is a match with a display resident font possible ?         *//*YOJN*/
        /**************************************************************//*YOJN*/
        /* Resident fonts can be used with direct or memory DC's.     *//*YOJN*/
        /**************************************************************//*YOJN*/
        Result = MatchFont((PFATTRS)ArgLogFont);                        /*YOJN*/
        break;                                                          /*YOJN*/
                                                                        /*YOJN*/
    case RF_LOAD_ENGINE_FONT:                                           /*YOJN*/
                                                                        /*YOJN*/
        Result = NO_FONT_MATCH;                                         /*YOJN*/
        break;                                                          /*YOJN*/
                                                                        /*YOJN*/
    case RF_DELETE_ENGINE_FONT:                                         /*YOJN*/
                                                                        /*YOJN*/
        Result = GPI_OK;                                                /*YOJN*/
        break;                                                          /*YOJN*/
                                                                        /*YOJN*/
    case RF_DELETE_FONT:                                                /*YOJN*/
                                                                        /*YOJN*/
        OutputPair("RealizeFont: Delete font",                          /*YOJN*/
                                     ArgEngFont-FTB_LCID_BASE, DECIMAL); /*YOJN*/
                                                                        /*YOJN*/
        if (CHECKENV(ENV_DBCS_CAPABLE) && ArgEngFont)                   /*YOJN*/
          {                            /* only when DBCS-OS/2         *//*YOJN*/
                                       /* Note: ArgEngFont may be NULL*//*YOJN*/
                                       /*  (means device default font)*//*YOJN*/
            eddj_UnrealizeFont( (PFOCAFONT)ArgEngFont );                /*YOJN*/
                                       /* may be DBCS FM font...      *//*YOJN*/
          }                            /* end of if:                  *//*YOJN*/
                                                                        /*YOJN*/
        Result = GPI_OK;                                                /*YOJN*/
        break;                                                          /*YOJN*/
                                                                        /*YOJN*/
    default:                                                            /*YOJN*/
        Result = GPI_ERROR;                                             /*YOJN*/
        break;                                                          /*YOJN*/
    }                                                                   /*YOJN*/
                                                                        /*YOJN*/
    /******************************************************************//*YOJN*/
    /* Release driver semaphore                                       *//*YOJN*/
    /******************************************************************//*YOJN*/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);            /*YOJN*/
                                                                        /*YOJN*/
    PROFILE_EXIT(26);                                                   /*YOJN*/
    return(Result);                                                     /*YOJN*/
}                                                                       /*YOJN*/
#undef TFUNC                                                            /*YOJN*/
                                                                        /*YOJN*/
/**********************************************************************//*YOJN*/
/* MatchFont examines the available resident fonts and attempts to    *//*YOJN*/
/* match the given attributes                                         *//*YOJN*/
/**********************************************************************//*YOJN*/
                                                                        /*YOJN*/
ULONG MatchFont (PFATTRS ArgFont)                                       /*YOJN*/
{                                                                       /*YOJN*/
#define TFUNC "MatchFont"                                               /*YOJN*/
    ULONG Result;                                                       /*YOJN*/
                                                                        /*YOJN*/
    /******************************************************************//*YOJN*/
    /* Test match number.                                             *//*YOJN*/
    /******************************************************************//*YOJN*/
    if ((LONG)ArgFont->lMatch > 0)                                      /*YOJN*/
    {                                                                   /*YOJN*/
      return NO_FONT_MATCH;            /* this is engine font         *//*YOJN*/
    }                                                                   /*YOJN*/
                                                                        /*YOJN*/
/*--------------------------------------------------------------------*//*YOJN*/
/* Below part has been moved to eddj_RealizeFont                      *//*YOJN*/
/*--------------------------------------------------------------------*//*YOJN*/
//  if ( ArgFont->lMatch == LMATCH_SYS_SBCS )                           /*YOJN*/
//  {                                                                   /*YOJN*/
//      /**************************************************************//*YOJN*/
//      /* Only honour the match number if the facenames are also the *//*YOJN*/
//      /* same - if they are different then fall through to the full *//*YOJN*/
//      /* matching process                                           *//*YOJN*/
//      /* strcmp returns 0 if the strings are the same               *//*YOJN*/
//      /**************************************************************//*YOJN*/
//      /*============================================================*//*YOJN*/
//      /* if facename does not match, further process (full-matching)*//*YOJN*/
//      /* will be done in eddj_RealizeFont() routine.                *//*YOJN*/
//      /*============================================================*//*YOJN*/
//      if (!strcmp(ArgFont->szFacename,                                /*YOJN*/
//                  pResourceFont->fmMetrics.szFacename))               /*YOJN*/
//      {                                                               /*YOJN*/
//        return (ULONG)pResourceFont; /* SBCS res font matched       *//*YOJN*/
//      }                                                               /*YOJN*/
//  }                                                                   /*YOJN*/
                                                                        /*YOJN*/
    /**************************************************************/    /*YOJN*/
    /* If all fields are null means we should match the default   */    /*YOJN*/
    /* font.                                                      */    /*YOJN*/
    /**************************************************************/    /*YOJN*/
    if (ArgFont->lMatch          == 0 &&                                /*YOJN*/
        ArgFont->idRegistry      == 0 &&                                /*YOJN*/
        ArgFont->fsSelection     == 0 &&                                /*YOJN*/
        ArgFont->lMaxBaselineExt == 0 &&                                /*YOJN*/
        ArgFont->lAveCharWidth   == 0 &&                                /*YOJN*/
        ArgFont->fsType          == 0 &&                                /*YOJN*/
        ArgFont->szFacename[0]   == 0 &&                                /*YOJN*/
        ArgFont->fsFontUse       == 0 )                                 /*YOJN*/
    {                                                                   /*YOJN*/
      return (ULONG)pDefaultFont;      /*                             *//*YOJN*/
    }                                                                   /*YOJN*/
                                                                        /*YOJN*/
    /*================================================================*//*YOJN*/
    /* Note: DBCS Font Manager has DBCS proportional font, therefore  *//*YOJN*/
    /*  we also have proportional device font, but no vector font.    *//*YOJN*/
    /*================================================================*//*YOJN*/
    if (ArgFont->fsFontUse & (FATTR_FONTUSE_OUTLINE |                   /*YOJN*/
                              FATTR_FONTUSE_TRANSFORMABLE))             /*YOJN*/
    {                                                                   /*YOJN*/
      return NO_FONT_MATCH;                                             /*YOJN*/
    }                                                                   /*YOJN*/
                                                                        /*YOJN*/
    /**************************************************************/    /*YOJN*/
    /* also check the size of the font descriptor                 */    /*YOJN*/
    /**************************************************************/    /*YOJN*/
    if (ArgFont->usRecordLength != sizeof(FATTRS))                      /*YOJN*/
    {                                                                   /*YOJN*/
      return NO_FONT_MATCH;                                             /*YOJN*/
    }                                                                   /*YOJN*/
                                                                        /*YOJN*/
    /*================================================================*//*YOJN*/
    /* If falls down to this point, we will check DBCS Font Manager   *//*YOJN*/
    /* for match...                                                   *//*YOJN*/
    /*================================================================*//*YOJN*/
    if (CHECKENV(ENV_DBCS_CAPABLE))                                     /*YOJN*/
      {                                                                 /*YOJN*/
        Result = (ULONG)eddj_RealizeFont( ArgFont );                    /*YOJN*/
                                       /* try to realize;SBCS resource*//*YOJN*/
                                       /* font is also checked here.  *//*YOJN*/
        if (Result == 0)               /* 0 is returned if no match   *//*YOJN*/
          {                            /*                             *//*YOJN*/
            return NO_FONT_MATCH;      /* translate for caller        *//*YOJN*/
          }                            /* end of if:                  *//*YOJN*/
        else                           /*                             *//*YOJN*/
          {                            /*                             *//*YOJN*/
            return Result;             /*                             *//*YOJN*/
          }                            /* end of else:                *//*YOJN*/
      }                                /* end of if:                  *//*YOJN*/
                                                                        /*YOJN*/
    return NO_FONT_MATCH;              /* gave up finally!            *//*YOJN*/
}                                                                       /*YOJN*/
#undef TFUNC                                                            /*YOJN*/
#endif                                                                  /*YOJN*/
