/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDAKERN                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function           */
/*                     GetPairKerningTable.                           */
/*                                                                    */
/*   Function        = GetPairKerningTable returns the kerning pairs  */
/*                     in the current font.                           */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_GRE_DEVMISC1
#include <eddinclt.h>

#include <eddttypt.h>
#include <eddtcone.h>
#include <eddaextf.h>
#include <eddgextf.h>

extern PPFNL               EnginesDispatchTable;

/**********************************************************************/
/*                                                                    */
/* GetPairKerningTable returns the kerning pairs in the currently     */
/* selected font.                                                     */
/*                                                                    */
/**********************************************************************/
DDIENTRY edda_GetPairKerningTable (HDC            hdc,
                                   ULONG          ArgCount,
                                   PKERNINGPAIRS  ArgKernPairs,
                                   PDC            pdcArg,
                                   ULONG          FunN)
{
    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* If this is the drivers default font then we must handle the    */
    /* call.                                                          */
    /* We would also have to handle any AA fonts if that support is   */
    /* put back in.                                                   */
    /******************************************************************/
    if (pdc->DCICurTxtAts.cbnd.usSet == 0)
    {
        /**************************************************************/
        /* We know in advance that the driver default font does not   */
        /* have any kerning pairs                                     */
        /**************************************************************/

        /**************************************************************/
        /* Release driver semaphore                                   */
        /**************************************************************/
        ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

        return(0);
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* The engine does all the work for non-default fonts.            */
    /******************************************************************/
    return (EnginesDispatchTable[NGreGetPairKerningTable & 0xff](
                                                          hdc,
                                                          ArgCount,
                                                          ArgKernPairs,
                                                          pdcArg,
                                                          FunN) );
}
