/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDAEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     Attributes routines                            */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

DDIENTRY edda_DeviceSetDCOrigin (HDC           hdc,
                                 PPOINTL       ArgOrigin,
                                 PDC           pdcArg,
                                 ULONG         FunN);

DDIENTRY edda_GetDCOrigin (HDC           hdc,
                           pWcsPoint     ArgOrigin,
                           PDC           pdcArg,
                           ULONG         FunN);

DDIENTRY edda_GetPairKerningTable (HDC            hdc,
                                   ULONG          ArgCount,
                                   PKERNINGPAIRS  ArgKernPairs,
                                   PDC            pdcArg,
                                   ULONG          FunN);

DDIENTRY edda_DeviceSetAttributes (HDC            hdc,
                                   ULONG          ArgBundleType,
                                   ULONG          ArgDefsMask,
                                   ULONG          ArgAttrsMask,
                                   PVOID          ArgAttributes,
                                   PDC            pdcArg,
                                   ULONG          FunN);

DDIENTRY edda_DeviceGetAttributes (HDC            hdc,
                                   ULONG          ArgBundleType,
                                   ULONG          ArgAttrsMask,
                                   PVOID          ArgAttributes,
                                   PDC            pdcArg,
                                   ULONG          FunN);

DDIENTRY edda_DeviceSetGlobalAttribute (HDC           hdc,
                                        ULONG         ArgAttrType,
                                        ULONG         ArgAttrValue,
                                        ULONG         ArgOptions,
                                        PDC           pdcArg,
                                        ULONG         FunN);

DDIENTRY edda_NotifyClipChange(HDC          hdc,
                               pWcsRect     ArgBoundClip,
                               ULONG        ArgComplexity,
                               ULONG        ArgClipPath,
                               PDC          pdcArg,
                               ULONG        FunN);

USHORT PASCAL edda_GetClipRectangles (VOID);

DDIENTRY edda_DeviceInvalidateVisRegion(HDC          hdc,
                                        ULONG        ArgArraySize,
                                        PDC_BLOCK    ArgDCArray,
                                        PDC          pdcArg,
                                        ULONG        FunN);

DDIENTRY edda_RealizeFont (HDC         hdc,
                           ULONG       ArgCommand,
                           ULONG       ArgLogFont,
                           ULONG       ArgEngFont,
                           PDC         pdcArg,
                           ULONG       FunN);

DDIENTRY edda_DeviceQueryFontAttributes (HDC           hdc,
                                         ULONG         ArgSize,
                                         PFONTMETRICS  ArgMetrics,
                                         PDC           pdcArg,
                                         ULONG         FunN);

DDIENTRY edda_DeviceQueryFonts (HDC           hdc,
                                ULONG         ArgOptions,
                                PCHAR         ArgFilter,
                                PFONTMETRICS  ArgMetrics,
                                ULONG         ArgSize,
                                PULONG        ArgCount,
                                PDC           pdcArg,
                                ULONG         FunN);

DDIENTRY edda_SetCodePage (HDC             hdc,
                           ULONG           ArgCodePage,
                           PDC             pdcArg,
                           ULONG           FunN);

DDIENTRY edda_GetCodePage (HDC             hdc,
                           PDC             pdcArg,
                           ULONG           FunN);

ULONG SetTextAttributes (ULONG          DefMask,
                         ULONG          AttrMask,
                         PDCHARBUNDLE   Attributes);

ULONG SetLineAttributes (ULONG          DefMask,
                         ULONG          AttrMask,
                         PDLINEBUNDLE   Attributes);

ULONG SetMarkerAttributes (ULONG          DefMask,
                           ULONG          AttrMask,
                           PDMARKERBUNDLE Attributes);

ULONG SetPatternAttributes (ULONG          DefMask,
                            ULONG          AttrMask,
                            PDAREABUNDLE   Attributes);

ULONG SetImageAttributes (ULONG          DefMask,
                          ULONG          AttrMask,
                          PDIMAGEBUNDLE  Attributes);

USHORT PASCAL edda_PatternSetUp (VOID);

USHORT PASCAL edda_MarkerSetUp (VOID);

VOID PASCAL destroy_character_bitmap(pBitmapHeader pBitmapHdr);

VOID PASCAL NEAR make_dc_origin_adjustments(PDC     pdcAdjust,
                                            PPOINTL new_origin);

/**********************************************************************/
/* assembly routines                                                  */
/**********************************************************************/

VOID FAR PASCAL xform_metrics(HDC             hdc,
                              PFONTMETRICS    lpMetrics);
