;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
		.286p
;***********************************************************************
;    Module	      : DRIVER.INC
;
;    Description      : This file contains miscellaneous definitions for
;			XGA PM DBCS Driver.  It is the replacement for
;			DRIVER.INC for VGA DBCS Driver.
;
;    Created	      : 11/26/91
;    Author	      : Yohji Nakamura (JL04328 at YMTVM6)
;
;    Notes	      :
;
;    History	      :
;
;			OCO Source Materials
;			XXXX-XXX
;***********************************************************************
;-----------------------------------------------------------------------;
; Runtime Options				(from OPTIONS.INC)
;-----------------------------------------------------------------------;

; Display driver logical configuration options (for swFlags).
; The configuration is checked at initialization time.
; The significance of the bits in the flags is described below:

SW_OPTIONS	equ	0003h		; sw options field
SW_SYSTEM_DBCS	equ	0001h		; system default codepage is DBCS
SW_DISPLAY_DBCS equ	0002h		; driver can display DBCS font set

;======================================================================
; segment definition
;	Purpose of this part is to deceive assembler source files
;	(such as DBCSINIT, DBCSFONT, etc...) to fit in segment structs
;	which XGA 32-bit driver employes, without changing them.
;======================================================================
	createSeg _CODE16IOPL, DbcsSeg,   WORD, PUBLIC, CODE
	createSeg _CODE16IOPL, Code,	  WORD, PUBLIC, CODE
	createSeg _CODE16,     VioSeg,	  WORD, PUBLIC, CODE
	createSeg _CODE16,     Ring3Code, WORD, PUBLIC, CODE

	createSeg _DATA16, Data,      WORD, PUBLIC, DATA
	createSeg _DATA16,     Ring3Data, WORD, PUBLIC, DATA

;======================================================================
; macro definitions
;======================================================================
;--------------------------------------------------------------------------;
; Processor selection macros
;
; Enable assembly of a particular processor's instructions, and set a flag
; which can be read for conditional assembly.
;
; Parameters:
;	which_proc
; Entry:
;	none
; Returns:
;	none
; Error Returns:
;	none
; Registers Destroyed:
;	none
; Registers Preserved:
;	all
; Calls:
;	none
; History:
;  Mon 03-Apr-1989 13:09:55 -by-  Greg Hitchcock [gregh]
; Copied MACRO from Base BASEMACA.INC.
;--------------------------------------------------------------------------;

?cpumode = 286

;*** CPUMode - put a wrapper around .processor directives
;

CPUMode macro cpu
    ifidn <cpu>,<8086>
	?cpumode = 8086
	.8086
    elseifidn <cpu>,<8088>
	?cpumode = 8086
	.8086
    elseifidn <cpu>,<286>
	?cpumode = 286
	.286p
    elseifidn <cpu>,<386>
	?cpumode = 386
	.386p
    elseifidni <cpu>,<reset>
	if ?cpumode eq 386
	    .386p
	elseif ?cpumode eq 286
	    .286p
	elseif ?cpumode eq 8086
	    .8086
	endif
    else
	%out Unknown processor type cpu
	.err
    endif
endm

;---------------------------Macro---------------------------------------;
; errcode is a simple macro to define a symbol as being an absolute
; external value, which we can resolve at link time.
;
; Usage:
;	errcode <list>
; Where:
;	list - the error codes to be defined.  ERROR_ is prepended
;	       to the error name
; Restrictions:
;	None
;-----------------------------------------------------------------------;

errcode macro	list
	endm


;---------------------------Macro---------------------------------------;
; save_error_code
;
; Calls the appropriate routine to save the error code.
;
; Entry:
;	AX = error code
; Returns:
;	nothing
; Registers Destroyed:
;	!!!
; History:
;  Fri Jun 05, 1987 08:39:14a  -by-  Charles Whitmer [chuckwh]
; Created.
;-----------------------------------------------------------------------;

save_error_code macro
endm

;---------------------------Macro---------------------------------------;
; save_warning_code
;
; Calls the appropriate routine to save the warning code.
;
; Entry:
;	AX = error code
; Returns:
;	nothing
; Registers Destroyed:
;	!!!
; History:
;  Fri Jun 24, 1988 10:36:00	-by-	Kent Settle	[kentse]
; Created.
;-----------------------------------------------------------------------;

save_warning_code	macro
endm

save_unrecoverable_code macro
endm


;---------------------------------Macro---------------------------------;
; out16
;
; out16 is a macro used wherever any 16-bit output is performed.
; The macro is intended to serve as documentation for those machines
; which do not perform 16-bit outputs correctly (where correctly is
; defined as the way the IBM AT does it).
;
; usage
;
;     out16   d,a
;
; where
;
;     d   -   I/O address register. Included as documentation
;	      only.  Must always be DX (lower case).
;
;     a   -   Register to output.  Included as documentation
;	      only.  Must always be AX (lower case).
;
; Entry:
;	AX	= data to output
;	DX	= I/O port address
; Returns:
;	none
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS
; Registers Preserved:
;	AX,BX,CX,DX,SI,DI,BP,DS,ES
; Calls:
;	none
; History:
;	Fri 16-Jan-1987 16:49:03 -by-  Walt Moore [waltm]
;	Initial version
;-----------------------------------------------------------------------;

ifndef	IO8				;;If normal 16 bit outputs
  out16   equ	  out
else					;;If 8-bit outputs
  out16 macro d,a
	ifdif <a>,<ax>
	%out out16 - invalid register, must be ax
	.err
	endif
	ifdif	<d>,<dx>
	%out	out16 - invalid register, must be dx
	.err
	endif
	ifdif <is>,<cli>		;;  If interrupts not off
	cli				;;    then turn them off
	endif				;;
	out	dx,al			;;  Output LSB portion
	inc	dx			;;  --> next address
	xchg	al,ah			;;  Get MSB of output value
	out	dx,al			;;  Output MSB portion
	ifdif <ie>,<cli>		;;  If not explicitly told to leave
	sti				;;    interrupts off, turn them on
	endif				;;
	ifdif <rd>,<dont_save_DL>	;;  If not explicitly told to trash DX,
	dec	dx			;;    restore it.
	xchg	al,ah
	endif
	endm
endif



;-----------------------------------------------------------------------;
; odd	--- macro for odd alignment, counterpart for masm's "even".
;
; Arguments:
;	none
; Returns:
;	nothing
; Alters:
;	nothing
; Calls:
;	nothing
; History:
;
;  Sun Mar 01, 1987 07:48:01p	-by-	Wesley O. Rupel   [wesleyr]
; Wrote it!
;-----------------------------------------------------------------------;

odd	macro
	ife (offset $) AND 1
	nop
	endif
	endm

;-----------------------------------------------------------------------;
; ret_near --- macro for generating a near return instruction
;
; Arguments:
;	none
; Returns:
;	nothing
; Alters:
;	nothing
; Calls:
;	nothing
; History:
;	12-Feb-88 [stevewo] Wrote it!
;-----------------------------------------------------------------------;

ret_near	macro
	db	0C3h			;Near return, no parameters popped
	endm

;-----------------------------------------------------------------------;
; ret_far --- macro for generating a far return instruction
;
; Arguments:
;	none
; Returns:
;	nothing
; Alters:
;	nothing
; Calls:
;	nothing
; History:
;	12-Feb-88 [stevewo] Wrote it!
;-----------------------------------------------------------------------;

ret_far 	macro
	db	0CBh			;Far return, no parameters popped
	endm

;-----------------------------------------------------------------------;
; pushem
; popem
;
; Allows giving a list of registers to push/pop on a single line.
; Also allows easy verificaton that pushes and pops are balanced
; because arguements are given in the same order:
;
;	pushem	ax,bx,cx   goes with
;	popem	ax,bx,cx
;
; Arguments:
;	registers to push/pop
; Returns:
;	nothing
; Alters:
;	nothing
; Calls:
;	nothing
; History:
;
;  Mon Mar 09, 1987 06:12:32p	-by-	Wesley O. Rupel   [wesleyr]
; Wrote it!
;-----------------------------------------------------------------------;

pushem	macro	r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
	irp	x,<r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12>
	ifnb	<x>
	push	x
	endif
	endm
	endm

popem	macro	r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
	irp	x,<r12,r11,r10,rF,rE,rD,rC,rB,rA,r9,r8,r7,r6,r5,r4,r3,r2,r1>
	ifnb	<x>
	pop	x
	endif
	endm
	endm


;--------------------------------------------------------------------------;
; abs_ax
;	takes absolute value of AX
; Entry:
;	AX	= integer
; Returns:
;	AX	= abs(AX)
; Error Returns:
;	none
; Registers Destroyed:
;	DX,FLAGS
; Registers Preserved:
;	BX,CX,SI,DI,DS,ES,BP
; Calls:
;	none
; History:
;  Thu Mar 05, 1987 06:15:46p	-by-  Tony Pisculli	[tonyp]
; wrote it
;--------------------------------------------------------------------------;

abs_ax	macro
	cwd
	xor	ax,dx
	sub	ax,dx
	endm


;--------------------------------------------------------------------------;
; usmin_ax
;	returns unsigned min of AX and REG/MEM
; Entry:
;	AX	= unsigned integer
;	REG/MEM = unsigned integer
; Returns:
;	AX	= min(AX,REG/MEM)
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS
; Registers Preserved:
;	BX,CX,DX,SI,DI,DS,ES,BP
; Calls:
;	none
; History:
;  Mon Apr 04 14:14:19 1988	-by-	Hock Lee	[hockl]
; wrote it
;--------------------------------------------------------------------------;

usmin_ax	macro	REG
	local	got_it
	cmp	ax,REG
	jb	got_it
	mov	ax,REG
got_it:
	endm


;--------------------------------------------------------------------------;
; usmax_ax
;	returns unsigned max of AX and REG/MEM
; Entry:
;	AX	= unsigned integer
;	REG/MEM = unsigned integer
; Returns:
;	AX	= max(AX,REG/MEM)
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS
; Registers Preserved:
;	BX,CX,DX,SI,DI,DS,ES,BP
; Calls:
;	none
; History:
;  Mon Apr 04 14:14:19 1988	-by-	Hock Lee	[hockl]
; wrote it
;--------------------------------------------------------------------------;

usmax_ax	macro	REG
	local	got_it
	cmp	ax,REG
	ja	got_it
	mov	ax,REG
got_it:
	endm


;--------------------------------------------------------------------------;
; smin_ax
;	returns signed min of AX and REG/MEM
; Entry:
;	AX	= signed integer
;	REG/MEM = signed integer
; Returns:
;	AX	= min(AX,REG/MEM)
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS
; Registers Preserved:
;	BX,CX,DX,SI,DI,DS,ES,BP
; Calls:
;	none
; History:
;  Mon Apr 04 14:14:19 1988	-by-	Hock Lee	[hockl]
; wrote it
;--------------------------------------------------------------------------;

smin_ax macro	REG
	local	got_it
	cmp	ax,REG
	jl	got_it
	mov	ax,REG
got_it:
	endm


;--------------------------------------------------------------------------;
; smax_ax
;	returns signed max of AX and REG/MEM
; Entry:
;	AX	= signed integer
;	REG/MEM = signed integer
; Returns:
;	AX	= max(AX,REG/MEM)
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS
; Registers Preserved:
;	BX,CX,DX,SI,DI,DS,ES,BP
; Calls:
;	none
; History:
;  Mon Apr 04 14:14:19 1988	-by-	Hock Lee	[hockl]
; wrote it
;--------------------------------------------------------------------------;

smax_ax macro	REG
	local	got_it
	cmp	ax,REG
	jg	got_it
	mov	ax,REG
got_it:
	endm


;---------------------------------Macro---------------------------------;
; jmpnext
; jmpnext stop
;
; jmpnext is used in the generation of fall through chains.  It
; generates the opcode used to swallow the next two bytes of object
; code (cmp ax,immediate word), and performs error checking to
; ensure that only two bytes of object code exist between any
; use of jmpnext.
;
; The chain is terminated by use of an optional parameter to jmpnext.
; If this optional field is non-blank, the chain is terminated.
;
; WARNING:  jmpnext destroys your flags!
;
; Usage:
;
;	dog:
;	     mov    al,34
;	     jmpnext
;	foo:
;	     mov     al,0
;	     jmpnext
;	bar:
;	     mov     al,1
;	     jmpnext stop			;End of the chain
;-----------------------------------------------------------------------;
; jmpcl
; jmpcl  stop
;
; jmpcl is used like jmpnext, except that it skips over only one byte.
; WARNING:  jmpcl destroys your CL!  (But not your flags.)
;
; Usage:
;	     clc
;	     jmpcl
;	other_way:
;	     stc
;	     jmpcl  stop
;-----------------------------------------------------------------------;
; jmpcx
; jmpcx  stop
;
; jmpcx is used like jmpnext, except that it destroys CX instead of
; the flags.
;
; Entry:
;	none
; Returns:
;	none
; Error Returns:
;	none
; Registers Destroyed:
;	FLAGS or CL or CX
; Registers Preserved:
;	AX,BX,CX,DX,SI,DI,BP,DS,ES
; Calls:
;	none
; History:
;  Sun 14-Feb-1988 22:34:14  -by-  Charles Whitmer [chuckwh]
; Added JMPCL and JMPCX.
;
;  Fri 13-Mar-1987 12:03:16 -by-  Walt Moore [waltm]
; Initial version.
;-----------------------------------------------------------------------;

??ji	=	0			;;Initial index value

jmpcl	macro e 			;;mov cl,<next byte>
jn %??ji,%(??ji+1),0B1h,+1,e		;;Set next label
endm

jmpcx	macro e 			;;mov cx,<next word>
jn %??ji,%(??ji+1),0B9h,+2,e		;;Set next label
endm

jmpnext macro e 			;;cmp ax,<next two bytes>
jn %??ji,%(??ji+1),03Dh,+2,e		;;Set next label
endm

jn macro i,j,c,d,e
.sall
??ji&i:
.xall
ifb <e> 				;;If not the end of the chain
	db	c
errn$	??ji&j,d			;;next lable must be two bytes away
endif
??ji=j					;;increment counter
endm


;---------------------------------Macro---------------------------------;
; missing_code
;
; missing_code is a macro which will display a message on the screen
; at assembly time.  It is used to flag code sequences which have not
; been completed.
;
; usage
;
;	missing_code	<text>
;
; Entry:
;	none
; Returns:
;	none
; Error Returns:
;	none
; Registers Destroyed:
;	none
; Registers Preserved:
;	ALL
; Calls:
;	none
; History:
;	Sun 22-Mar-1987 18:21:34 -by-  Walt Moore [waltm]
;	Initial version
;-----------------------------------------------------------------------;

missing_code	macro	x
	if1
	??_out	<&! Missing Code &!  x>
	endif
	endm

;-------------------------------Public-Macro-----------------------------;
; check
;
;  checks whether the given function has the correct parameters
;
; usage:
;
;  check  FunctionName,<parm1,parm2,parm3>
;
; History:
;  Wed 06-Apr-1988		-by-   Martin Picha	   [martinpi]
; Wrote it.
;------------------------------------------------------------------------;

check	macro	funcname,parms
	inner_check	%prm_&funcname,<parms>
	endm

inner_check macro string1,string2
	.errdif <string1>,<string2>
	endm


;---------------------------Macro---------------------------------------;
; rip is the macro which invokes the error processor to perform the
; call to WinSetErrorInfo to abort the process.
;
; Usage:
;	rip	arg1,arg2
; Where:
;	if arg1 == text, arg2 contains the text of error message
;	otherwise, arg1 is the name of the message it will be referenced by
;-----------------------------------------------------------------------;

rip	macro	arg1,arg2
endm


data_check	macro	reg
	local	all_cool
ifdef FIREWALLS
	cmp	reg:[data_ident],DS_IDENT
	jz	all_cool
	rip	BadDataSegment
all_cool:
endif
	endm

;-----------------------------Macro-------------------------------------------;
; puts
;
; If FIREWALLS is nonzero, outputs a string to the debugging output screen.
;
; Entry:
;	String	 = string to output
;
; Example:
;	puts	<*** StretchBlt: creating shadow bitmap>
;
; Registers Preserved:
;	all
;
; Registers Destroyed:
;	none
;
; History:
;  Thu	9-Sep-1989		-by-  Michael Kerekes	[mikeke]
; Made it work.
;
;  Tue 28-Jun-1988 19:48:06	-by-  Lee A. Newberg	[leen]
; Put the string in the FIRESEG.
;
;  Wed 02-Mar-1988 02:43:38	-by-  Brian Conte	[brianc]
; Wrote it.
;-----------------------------------------------------------------------------;
puts	macro	string
	endm

;---------------------------Macro---------------------------------------;
; fw_zero is a firewall macro which zeros the registers in the given
; list.  It doesn't try to be smart about it.
;
; Usage:
;	fw_zero <list>
; Where:
;	list - the register to be zeroed
;
; Restrictions:
;	16-bit and 8-bit registers cannot be mixed in the same fw_zero.
;	This is because of the optimization of moving between registers
;	when possible.
;-----------------------------------------------------------------------;

fw_zero macro	list
endm


;---------------------------Macro---------------------------------------;
; access is a simple macro to check that we have access rights to the
; given selector.  If we do not, gain_access_to_selector is called.
;
; Usage:
;	access	reg,selector
; Where:
;	reg	 - A work register
;	selector - The selector we want access to.  Must not be the
;		   same as reg
; Restrictions:
;	Uses AX if access is needed
;-----------------------------------------------------------------------;

; ifndef DINCL_GAIN_ACCESS_DEFINED
;	  externFP gain_access_to_selector
; endif
;
; access  macro   reg,selector
;	  local   xyzzy
; ifidni <reg>,<selector>
;	  .err
; endif
;	  cmp	  selector,INVALID_SEL	  ;Don't gain access to bogus selectors
;	  je	  xyzzy
;	  lar	  reg,selector
;	  jz	  xyzzy
;	  cCall   gain_access_to_selector,<selector>
; xyzzy:
;	  endm


;---------------------------Macro---------------------------------------;
; pubabs is a simple macro to make an absolute value public
;
; Usage:
;	pubabs	name,val
; Where:
;	name	 - name of the equate
;	val	 - value it is to have
;-----------------------------------------------------------------------;

pubabs	macro	name,val
	public	name
name	equ	val
	endm

;======================================================================
; type and constants
;======================================================================
; Some basic constants

MAXSHORT	equ	7FFFh		;Kinda majorly positive
MINSHORT	equ	8000h		;Kinda majorly negative
MAXLONG 	equ	7FFFFFFFh	;Massively positive
MINLONG 	equ	80000000h	;Massively negative

MAX_COORDINATE	equ   007FFFFFFh	;Limit width and height to 27 bits
MIN_COORDINATE	equ   0F8000000h

SIZE_BYTE	equ	1		;I hope you never use this!
SIZE_WORD	equ	2		;# of bytes in a word
SIZE_DWORD	equ	4		;# of bytes in a dword
SHIFT_BYTE	equ	0		;I wish they had a power function
SHIFT_WORD	equ	1
SHIFT_DWORD	equ	2

INVALID_SEL	equ	0FFFFh
INVALID_ADDRESS equ   (-1)

;-----------------------------------------------------------------------;
;
; ca_fsNls denotes the string parsing rule for current font.
;
; NLSCA_SBCS		Use SBCS parsing rule
; NLSCA_MBCS		Use MBCS parsing rule
; NLSCA_DBCS		Use DBCS parsing rule
;
; NLSCA_CONCAT		Parsing option. The parser will check the string
;			last byte is DBCS leading byte or not. If it is,
;			the parser returns with this bit kept on.
;			In this case, the last byte is left unprocessed.
;
; NLSCA_MAP_SBCS	SBCS mapping vector available (= CA_MUST_MAP)
; NLSCA_MAP_DBCS	DBCS mapping vector available
;
; ca_fsFont denotes the current font characteristics.
;
; NLSCA_FONT_SBCS	font is SBCS font
; NLSCA_FONT_DBCS	font is DBCS font
; NLSCA_FONT_MBCS	font is MBCS font
; NLSCA_FONT_DBCS_USED	DBCS portion of font is used
; NLSCA_FONT_CACHED	cached fontseg (SBCS characters aren't resident)
; NLSCA_FONT_HUGE	less than 256 characrters in fontseg at once
;
; ca_cCache	Max number of characters which can be cached in fontseg
;		at once. Valid only when both flag of NLSCA_FONT_CACHED
;		and NLSCA_FONT_HUGE is specified.
;-----------------------------------------------------------------------;

NLSCA_SBCS	equ	0001h	    ;ca_fsNls
NLSCA_DBCS	equ	0002h
NLSCA_MBCS	equ	0004h
NLSCA_CONCAT	equ	0008h
;		equ	0010h
;		equ	0020h
NLSCA_MAP_SBCS	equ	0040h
NLSCA_MAP_DBCS	equ	0080h

NLSCA_FONT_SBCS equ	0001h	    ;ca_fsFont
NLSCA_FONT_DBCS equ	0002h
NLSCA_FONT_MBCS equ	0004h
NLSCA_FONT_DBCS_USED equ 0008h
;		equ	0010h
;		equ	0020h
NLSCA_FONT_CACHED equ	0040h
NLSCA_FONT_HUGE equ	0080h

CB_SBCS_MAP_TBL equ	512
CB_DBCS_MAP_TBL equ	256

DBCSEVLEN	equ	10

CpMapTable	struc		    ;ca_paus
cmt_CharToGlyph db	CB_SBCS_MAP_TBL dup (?) ; code-point to glyph-index
cmt_DBCSLeading db	CB_DBCS_MAP_TBL dup (?) ; code-point to DBCS leading byte
cmt_DBCSEnv	db	DBCSEVLEN dup (?)	; DBCS env vector
CpMapTable	ends


LONG	struc				;Used to access the low and
lo	dw	?			;   high words of a dword
hi	dw	?
LONG	ends

FARPOINTER	struc			;Used to access the offset
off	dw	?			;   and selector of a pointer
sel	dw	?
FARPOINTER	ends
				       ; 
DEFAULTVIOCODEPAGE  equ 850	       ; UGL codepage

;======================================================================
; alias definitions
;======================================================================
adDevCapsData	equ <_QueryCapsTable>

swDrvCompat	equ <_swDrvCompat>
swDrvCharBox	equ <_swDrvCharBox>
swDrvFontRes	equ <_swDrvFontRes>
swDrvIconSize	equ <_swDrvIconSize>

usSysFontHeight equ <_usSysFontHeight>
usSysFontWidth	equ <_usSysFontWidth>
szSysFontName	equ <_szSysFontName>
szVioFontName	equ <_szVioFontName>

DosGetProcAddr	equ	<Dos16GetProcAddr>
DosAllocSeg	equ	<Dos16AllocSeg>
DosFreeSeg	equ	<Dos16FreeSeg>
DosLoadModule	equ	<Dos16LoadModule>
DosGetSeg	equ	<Dos16GetSeg>
DosGetProcAddr	equ	<Dos16GetProcAddr>
DosGetDBCSEv	equ	<Dos16GetDBCSEv>
DosCallback	equ	<Dos16CallBack>

WinQueryCpList	equ	<Win16QueryCpList>

PrfQueryProfileInt	equ	<Prf16QueryProfileInt>
PrfQueryProfileString	equ	<Prf16QueryProfileString>

;======================================================================
; more segments...
;======================================================================
	.386p
_TEXT	SEGMENT DWORD PUBLIC USE32 'CODE'                               ;YOJN
_TEXT	ENDS								;YOJN
									;YOJN
_DATA	SEGMENT DWORD PUBLIC USE32 'DATA'                               ;YOJN
_DATA	ENDS								;YOJN

	.286p
