;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;----------------------------------------------------------------------;
; DCAF.MAC
;
;
; This file contains macros and EQUates used by DCAF.
;----------------------------------------------------------------------;



@FLD8   macro   instruction
ifdef _FIELD8
ifdef _FIELD16
if not (((_FIELD8 eq 0) and (_FIELD16 eq 1)) or ((_FIELD8 eq 1) and (_FIELD16 eq 0)))
%out _FIELD8 and _FIELD16 incorrectly defined
.err
endif
endif
endif
if      _FIELD8
        instruction
endif
endm

@FLD16  macro   instruction
ifdef _FIELD8
ifdef _FIELD16
if not (((_FIELD8 eq 0) and (_FIELD16 eq 1)) or ((_FIELD8 eq 1) and (_FIELD16 eq 0)))
.err _FIELD8 and _FIELD16 incorrectly defined
endif
endif
endif
if      _FIELD16
        instruction
endif
endm

NRPT    macro   instruction
if      data_type eq <non_repeating_data>
        instruction
endif
endm

RPT     macro   instruction
if      data_type eq <repeating_data>
        instruction
endif
endm


;----------------------------------------------------------------------;
;
; INITFIELDSIZE sets the values for _FIELD8 and _FIELD16 to be true or
; false depending on the field_size passed
;
;----------------------------------------------------------------------;
INITFIELDSIZE macro  field_size

        .erre   (field_size eq 8) or (field_size eq 16)

if (field_size) eq 8
        _FIELD8  =  1
        _FIELD16 =  0
else
        _FIELD8  =  0
        _FIELD16 =  1
endif
endm


;----------------------------------------------------------------------;
;
; store_repeating_data repeats the current data field ecx times to the
; destination
;
; Parameters:
;        field_size  - Specifies size in bits of data fields
;                      Must be 8 or 16
;
;
; Entry:
;        esi points to current data field
;        edi points to destination for data
;        ecx contains count of number of times to write data
;
; Exit:
;        esi incremented past data field
;        edi points to next free location in dest
;        ecx contains zero
;
;----------------------------------------------------------------------;
store_repeating_data     macro field_size

if      field_size eq 8
        lodsb
        rep     stosb
else
        .err    field_size ne 16
        lodsw
        rep     stosw
endif
endm


;----------------------------------------------------------------------;
;
; copy_non_repeating_data copies the next rcx data fields to the
; destination
;
; Parameters:
;        field_size  - Specifies size in bits of data fields
;                      Must be 8 or 16
;
;
; Entry:
;        esi points to first data field
;        edi points to destination for data
;        ecx contains count of number of data fields to copy
;
; Exit:
;        esi incremented past data fields
;        edi points to next free location in dest
;        ecx contains zero
;
;----------------------------------------------------------------------;
copy_non_repeating_data macro field_size

if      field_size eq 8
        rep     movsb
else
        .err    field_size ne 16
        rep     movsw
endif
endm


;----------------------------------------------------------------------;
;
; read_cell_header fetches the current cell header into ax (from the
; source pointer). The source pointer is incremented to point to the
; following data.
;
; If the data size is 8 bits, then the cell header is sign extended
; to fill all 16 bits of ax.
;
;----------------------------------------------------------------------;
read_cell_header macro field_size

if      field_size eq 8
        lodsb           ; Read byte into al
        cbw             ; Extend byte to fill ax
else
        lodsw           ; Read word into ax
endif
endm

