/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = cursor.h                                       */
/*                                                                    */
/*   Description     = Display Device Driver cursor definitions       */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/* To generate the .inc version of this file use the following:       */
/*                                                                    */
/*    h2inc -t -s s:\drv6\h\os2def.h cursor.h > cursor.inc            */
/*                                                                    */
/**********************************************************************/

VOID remove_software_cursor_worker(VOID);

/**********************************************************************/
/* The maximum dimension of a cursor is 40 pels.                      */
/* The maximum bpp used in the driver is 16.                          */
/**********************************************************************/
#define MAXBPP  16
#define MAXDIMN 64

/**********************************************************************/
/* Software cursor data structure                                     */
/**********************************************************************/
typedef struct _SOFTWARECURSOR { /* sc */
    ULONG       bm;
    ULONG       andmask;
    ULONG       xormask;
    ULONG       screen;
    POINTS      coord;
    POINTS      used;
    POINTS      defnsize;
    POINTS      hwsize;
    POINTS      hwusedsize;
    RECTL       XcludeRect;
} SOFTWARECURSOR;

#ifdef S3
typedef struct _S3CLR { /* s3clr */
    BYTE        clr8;
    BYTE        clr16;
    BYTE        clr24;
} S3CLR;
#endif

/**********************************************************************/
/* This structure holds all the data which the cursor code uses at    */
/* interrupt time.                                                    */
/**********************************************************************/
typedef struct _CURSORDATA { /* cd */
    /******************************************************************/
    /* These 2 fields are filled in by pmdd.sys when it locks the     */
    /* memory in place.                                               */
    /******************************************************************/
    PVOID       pGlobalCursorCode;
    PVOID       pGlobalCursorData;

    /******************************************************************/
    /* 2 fields to hold the latest cursor position to be drawn.       */
    /******************************************************************/
    ULONG       cursor_x;
    ULONG       cursor_y;

    /******************************************************************/
    /* Note the bodge here to cope with situations where the hotspot  */
    /* lies outside the cursor definition.  See note in               */
    /* DeviceSetCursor which is where this variable gets set up       */
    /******************************************************************/
    ULONG       cursor_adjust;

    /******************************************************************/
    /* Variables to hold the latest cursor position which are not     */
    /* used by eddm_excludecursor.  This ensures that the cursor      */
    /* position used by eddm_excludecursor is that of the cursor      */
    /* drawn on the screen and not that supplied on the most recent   */
    /* interrupt.                                                     */
    /******************************************************************/
    ULONG       new_cursor_x;
    ULONG       new_cursor_y;

    /******************************************************************/
    /* We need to store the size of the saved cursor data since this  */
    /* is dependent on how big the 'used' part of the cursor was at   */
    /* the time the data was saved - this may not be the same as the  */
    /* current used size.                                             */
    /******************************************************************/
    ULONG       savedusedsize;

    /******************************************************************/
    /* cursor_status is set if a cursor drawing process has been      */
    /* started. It is required since DrawCursor is non re-entrant.    */
    /* (This field has an initial value of CURSOR_NOTBUSY which is    */
    /* enforced by the assembler declaration of this structure).      */
    /******************************************************************/
    ULONG       cursor_status;

    /******************************************************************/
    /* Width of the sprite in bytes.                                  */
    /******************************************************************/
    ULONG       sprite_byte_width;

    /******************************************************************/
    /* The cursor hotspot.                                            */
    /******************************************************************/
    ULONG       hotspot_x;
    ULONG       hotspot_y;

    /******************************************************************/
    /* The cursor size.                                               */
    /******************************************************************/
    ULONG       cursor_height;
    ULONG       cursor_width;

    /******************************************************************/
    /* Software cursor data.                                          */
    /******************************************************************/
    SOFTWARECURSOR  software_cursor;

    /******************************************************************/
    /* Parameters for draw sprite.                                    */
    /******************************************************************/
    ULONG       draw_sprite_x;
    ULONG       draw_sprite_y;
    ULONG       draw_sprite_flags;
    ULONG       draw_sprite_hot_x;
    ULONG       draw_sprite_hot_y;
    ULONG       draw_sprite_addr;
    ULONG       draw_sprite_width;
    ULONG       draw_sprite_height;

#ifndef S3
    RGB2        draw_sprite_col1;
    RGB2        draw_sprite_col2;
#else
    S3CLR       draw_sprite_col1;
    S3CLR       draw_sprite_col2;
#endif

    /******************************************************************/
    /* Interrupt time copies of the register addresses.               */
    /******************************************************************/
    PVOID       memory_registers;
    ULONG       io_registers;
    PBYTE       polling_register;
    ULONG       bank_values;

    /******************************************************************/
    /* Cursor code needs to know what type of card it is drawing to.  */
    /******************************************************************/
    ULONG       adapter_id;

    BYTE        cursor_bits[MAXDIMN * MAXDIMN * 2 / 8];

    ULONG       screen_hw_format;
    ULONG       screen_hw_size;
    ULONG       screen_address;

    ULONG       savedcoords;

    ULONG       cursor_hwscan;
    ULONG       cursor_hwvram;
    BYTE        cursor_bm[MAXDIMN * MAXDIMN * MAXBPP / 8];
    BYTE        cursor_screen[MAXDIMN * MAXDIMN * MAXBPP / 8];
    BYTE        cursor_andmask[MAXDIMN * MAXDIMN / 8];
    BYTE        cursor_xormask[MAXDIMN * MAXDIMN / 8];
} CURSORDATA;

typedef CURSORDATA * PCURSORDATA;

/**********************************************************************/
/* cursor drawing status flags                                        */
/**********************************************************************/
#define CURSOR_NOTBUSY          0x00

#define CURSOR_BUSY             0x01
#define CURSOR_EXCLUDED         0x02
#define CURSOR_MOVED            0x04
#define CURSOR_VISIBLE          0x08
#define CURSOR_COLOUR           0x10
#define CURSOR_REDRAW           0x20
#define CURSOR_HWINUSE          0x40
#define CURSOR_SOFTWARE         0x80
#define CURSOR_XREGION          0x100

#ifdef S3
#define CURSOR_DRVR_IN_LA       0x200
#endif

/**********************************************************************/
/* Flag to specify if cursor is visible or not                        */
/**********************************************************************/
#define     SPRITE_VISIBLE      0
#define     SPRITE_INVISIBLE    1

/**********************************************************************/
/* bank switching defines used in the dev escs and cursor routines    */
/**********************************************************************/
#ifdef S3

// S3 Ports
#define S3_NDX_PORT    0x3D4
#define S3_RW_PORT     0x3D5

// S3 Indexes
#define S3_LAW_CTL     0x58
#define S3_EX_SCTL_2   0x51
#define S3_CRTR_LOCK   0x35
#define S3_CONFIG_REG1 0x36

// S3 significant bits
#define S3_LINEAR_ADDRESSING   0x10

// Define s3 adapter and its dac
#define S3_WITH_BROOK_DAC   0x01
#define S3_WITH_ATT_DAC     0x02
#define S3_WITH_MUSIC_DAC   0x04

#endif

