;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
comment $
cmacros - assembly macros for interfacing to hhls
(C)Copyright Microsoft Corp. 1984-1987
cmacro32 - assembly macros for interfacing to 32-bit hhls
(C) Copyright Micrografx Inc. 1991
$
CC_CDECL equ 0
CC_PLM equ 1
CC_PASCAL equ 1
CC_SYSCALL equ 2
CC_STDCALL equ 3
.xcref
.xcref ??_out
??_out macro t
ifdef ?VERBOSE
%out t
endif
endm
.xcref ?VERBOSEDEBUG
outif macro name,defval,onmsg,offmsg
ifndef name
ifb <defval>
name=0
else
name=defval
endif
endif
if name
name=1
ifnb <onmsg>
??_out <! onmsg>
endif
else
ifnb <offmsg>
??_out <! offmsg>
endif
endif
endm
.xcref ??error
??error macro msg
e r r o r ----- msg
.err
endm
.xcref ASMpass
.xcref memS,memMOD,sizec,sized
ASMpass = 1
ifdef ?SMALL
memS = 1
endif
?ADRCnt = 0
??_out <cMacro32 Version 1.00 - 08-Apr-1991>
??_out <Copyright (C) Microsoft Corp. 1984-1988. All rights reserved.>
??_out <Copyright (C) Micrografx, Inc. 1991. All rights reserved.>
outif memS,0,<Small Model>
memMOD = memS
if memMOD ne 1
if memMOD eq 0
memS = 1
outif memS,0,<Small model>
else
??error <must have only 1 memory model selected>
endif
endif
sizec = 0
sized = 0
ifndef ?VERBOSEDEBUG
?VERBOSEDEBUG = 0
endif
?TF=0
?wfp=0
?WIN=0
ifndef ?NODATA
?nodata1=0
else
?nodata1=1
??_out <! NODATA module>
endif
ifndef ?CHKSTK
?chkstk1=0
else
?chkstk1=1
ifdef ?CHKSTKPROC
??_out <! Private stack checking enabled>
else
??_out <! Stack checking enabled>
endif
endif
ifdef ?PROFILE
??_out <! Native profiling enabled>
endif
.xcref ?n,?eax,?ah,?al,?ebx,?bh
.xcref ?bl,?ecx,?ch,?cl,?edx,?dh
.xcref ?dl,?esi,?edi,?es,?ds,?ebp
.xcref ?esp,?ss,?cs
.xcref ?rsl,?cpd,?argl,?argc,?ba
.xcref ?acb,???,?po
.xcref ?pas
.xcref uconcat,mpush,mpop
.xcref ?ri,?pp,?pp1,?al1
.xcref ?ad,?ap,?atal,?dd,?dd1,?dd2
.xcref ?pg,?pg1,?aloc
.xcref ?ff,?PLM,?WIN,?ia,?pu,?adj
.xcref ?uf,?rp,?nx,?nd,?nodata1,?chkstk1
.xcref ?wfp,arg,cCall,cProc
.xcref save,outif,errnz,errn$,errnz1
.xcref ?PLMPrevParm,?gcc
.xcref ?cCall1,?cCall1p,?pcc
.xcref ?ADRCnt,?ADRS,?ADRS2x,?ADRSLn
.xcref ?NOPARMR,?NOPTR
.xcref ?TF
.xcref ?winp
?rsl = 0
?cpd = 0
?argl = 0
?argc = 0
?ba = 0
?acb = 0
??? = 0
?po = 0
?pas = 0
?ia = 0
?pu = 0
?adj = 0
?rp = 0
?uf = 0
?nd = 0
?nx = 0
?winp = 0
?ff = 0
?dd2 = 0
?cCall1 = 0
?cCall1p = 0
?pcc = 0
?PLMPrevParm = 0
.xcref ?casen
?casen = 0
?n = 0000000000000000b
?eax = 0000000000000011b
?ah = 0000000000000010b
?al = 0000000000000001b
?ebx = 0000000000001100b
?bh = 0000000000001000b
?bl = 0000000000000100b
?ecx = 0000000000110000b
?ch = 0000000000100000b
?cl = 0000000000010000b
?edx = 0000000011000000b
?dh = 0000000010000000b
?dl = 0000000001000000b
?esi = 0000000100000000b
?edi = 0000001000000000b
?ebp = 0000010000000000b
?esp = 0000100000000000b
?ds = 0001000000000000b
?es = 0010000000000000b
?ss = 0100000000000000b
?cs = 1000000000000000b
ifdif <EAX>,<eax>
.xcref ?EAX,?AH,?AL,?EBX,?BH
.xcref ?BL,?ECX,?CH,?CL,?EDX,?DH
.xcref ?DL,?ESI,?EDI,?ES,?DS,?EBP
.xcref ?ESP,?SS,?CS
?EAX = ?eax
?AH = ?ah
?AL = ?al
?EBX = ?ebx
?BH = ?bh
?BL = ?bl
?ECX = ?ecx
?CH = ?ch
?CL = ?cl
?EDX = ?edx
?DH = ?dh
?DL = ?dl
?ESI = ?esi
?EDI = ?edi
?EBP = ?ebp
?ESP = ?esp
?DS = ?ds
?ES = ?es
?SS = ?ss
?CS = ?cs
endif
.cref
uconcat macro a,b,c,d,e,f,g
a&b c&d e&f&g
endm
mpush macro r
irp x,<eax,ebx,ecx,edx,esi,edi,ebp,esp,es,ds,ss>
if (r and ?&&x)
push x
endif
endm
endm
mpop macro r
irp x,<ss,ds,es,esp,ebp,edi,esi,edx,ecx,ebx,eax>
if (r and ?&&x)
pop x
endif
endm
endm
save macro r
?rsl=0
?ri ?rsl,<r>
endm
ifdif <EAX>,<eax>
.xcref Save
Save macro r
?rsl=0
?ri ?rsl,<r>
endm
endif
?ri macro n,r
irp x,<r>
ifdef ?&&x
n=n or ?&&x
endif
endm
endm
.xcref
.xcref parmB,parmW,parmD,parmQ,parmT,parmCP,parmDP
.cref
parmB macro n
?pp <n>,<byte>,4,1
endm
parmW macro n
?pp <n>,<word>,4,2
endm
parmD macro n
?pp <n>,<dword>,4,4
endm
parmQ macro n
?pp <n>,<qword>,8,8
endm
parmT macro n
?pp <n>,<tbyte>,10,10
endm
parmCP macro n
parmD <n>
endm
parmDP macro n
parmD <n>
endm
?pp macro n,t,l,s
if ?cpd
.xcref
irp x,<n>
.xcref ?t&&x
?t&&x=s
if (?PLM eq 1)
?PLMPrevParm=?PLMPrevParm+1
?po=?po+l
?pp1 x,<t>,%?po,%?adj,,%?PLMPrevParm,%(?PLMPrevParm-1)
else
?pp1 x,<t>,,,%(?po+?adj)
?po=?po+l
endif
endm
.cref
else
??error <parm(s) "&n" declared outside proc def>
endif
endm
?pp1 macro n,t,o,a,b,cpc,ppc
if (?PLM eq 1)
.xcref
.xcref ?PLMParm&cpc
.cref
?PLMParm&cpc &macro po
uconcat <n>,,<equ>,,<(t ptr [ebp+>,%(a+po-o),<])>
?PLMParm&ppc po
purge ?PLMParm&cpc
&endm
else
n equ (t ptr [ebp+b])
endif
endm
.xcref ?NOPARMR
?NOPARMR=1
ifndef ?NOPARMR
.xcref
.xcref ?pr,parmR
.cref
parmR macro n,r,r2
?pr n,r,r2,%?rp,%(?ia+2)
endm
?pr macro n,r,r2,i,o
.xcref
ifnb <r2>
parmR seg_&n,r
parmR off_&n,r2
n equ (dword ptr [ebp-o-2])
.xcref ?t&n
?t&n=4
else
.xcref ?rp&i
?rp&i=0
ifdef ?&r
?rp&i=?&r
endif
if ??? or (?cpd eq 0) or (?rp&i eq 0)
??error <invalid parmR encountered: &n,&r>
exitm
endif
n equ (word ptr [ebp-o])
?t&n=2
irp x,<bh,ch,dh,bl,cl,dl,ah,al>
if ?&&x eq ?&r
n equ (byte ptr [ebp-o])
?t&n=1
exitm
endif
endm
?ia=?ia+2
?rp=?rp+1
endif
.cref
endm
endif
.xcref
.xcref localB,localW,localD,localQ,localT,localCP,localDP,localV
.cref
localB macro n
?aloc <n>,<byte ptr>,1,1,1
endm
localW macro n
?aloc <n>,<word ptr>,2,2,1
endm
localD macro n
?aloc <n>,<dword ptr>,4,4,1
endm
localQ macro n
?aloc <n>,<qword ptr>,8,8,1
endm
localT macro n
?aloc <n>,<tbyte ptr>,10,10,1
endm
localCP macro n
localD <n>
endm
localDP macro n
localD <n>
endm
localV macro n,a
?aloc <n>,,%(a),0,1
endm
?aloc macro n,t,len,s,a
if ?cpd
.xcref
irp x,<n>
???=???+len
if a
???=((??? + 3) and 0fffch)
endif
?al1 x,<t>,%(???+?ia)
.xcref ?t&&x
?t&&x=s
endm
.cref
else
??error <locals "&n" declared outside procedure def>
endif
endm
?al1 macro n,t,o
n equ (t [ebp-o])
endm
?gcc macro s,i,cc
s = i
ifnb <cc>
ifidn <cc>,<C>
s=0
endif
ifidn <cc>,<PLM>
s=1
endif
ifidn <cc>,<PASCAL>
s=1
endif
ifidn <cc>,<C_SYSCALL>
s=2
endif
ifidn <cc>,<SYSCALL>
s=2
endif
ifidn <cc>,<C_STDCALL>
s=3
endif
ifidn <cc>,<STDCALL>
s=3
endif
endif
endm
ifndef ?NOGLOBAL
.xcref
.xcref globalB,globalW,globalD,globalQ,globalT,globalCP,globalDP
.cref
globalB macro n,i,s,c
?ad <n>,1
?dd n,1,<byte>,<db>,<i>,<s>,<c>
endm
globalW macro n,i,s,c
?ad <n>,2
?dd n,1,<word>,<dw>,<i>,<s>,<c>
endm
globalD macro n,i,s,c
?ad <n>,4
?dd n,1,<dword>,<dd>,<i>,<s>,<c>
endm
globalQ macro n,i,s,c
?ad <n>,8
?dd n,1,<qword>,<dq>,<i>,<s>,<c>
endm
globalT macro n,i,s,c
?ad <n>,10
?dd n,1,<tbyte>,<dt>,<i>,<s>,<c>
endm
globalCP macro n,i,s,c
globalD n,<i>,<s>,<c>
endm
globalDP macro n,i,s,c
globalD n,<i>,<s>,<c>
endm
endif
ifndef ?NOSTATIC
.xcref
.xcref staticB,staticW,staticD,staticQ,staticT,staticCP,staticDP
.cref
staticB macro n,i,s
?ad <n>,1
?dd n,0,<byte>,<db>,<i>,<s>,<PLM>
endm
staticW macro n,i,s
?ad <n>,2
?dd n,0,<word>,<dw>,<i>,<s>,<PLM>
endm
staticD macro n,i,s
?ad <n>,4
?dd n,0,<dword>,<dd>,<i>,<s>,<PLM>
endm
staticQ macro n,i,s
?ad <n>,8
?dd n,0,<qword>,<dq>,<i>,<s>,<PLM>
endm
staticT macro n,i,s
?ad <n>,10
?dd n,0,<tbyte>,<dt>,<i>,<s>,<PLM>
endm
staticCP macro n,i,s
staticD n,<i>,<s>
endm
staticDP macro n,i,s
staticD n,<i>,<s>
endm
endif
?dd macro n,p,t,d,i,s,c
?gcc ?dd2,%?PLM,<c>
if ((?dd2 eq 1) OR (?dd2 eq 2))
?dd1 n,p,<d>,<i>,<s>
else
n label t
?dd1 _&n,p,<d>,<i>,<s>
endif
endm
?dd1 macro n,p,d,i,s
if p
public n
endif
ifb <s>
n d i
else
ifb <i>
n d s dup (?)
else
n d s dup (i)
endif
endif
endm
ifndef ?NOEXTERN
.xcref
.xcref ?ex1,?ex1p,?ex2,?ex2p,externB,externW,externD,externQ
.xcref externT,externP,externCP,externDP,externA
.cref
ifndef ?ex2
ifndef ?PLM
?ex2 = 0
else
?ex2 = ?PLM
endif
endif
ifndef ?ex2p
?ex2p = ?ex2
endif
externA macro n,c
?ex1 <n>,40h,<abs>,<c>
endm
externB macro n,c
?ex1 <n>,1,<byte>,<c>
endm
externW macro n,c
?ex1 <n>,2,<word>,<c>
endm
externD macro n,c
?ex1 <n>,4,<dword>,<c>
endm
externQ macro n,c
?ex1 <n>,8,<qword>,<c>
endm
externT macro n,c
?ex1 <n>,10,<tbyte>,<c>
endm
externP macro n,c
?ex1p <n>,4,<>,<c>
endm
externCP macro n,c
?ex1p <n>,4,<>,<c>
endm
externDP macro n,c
?ex1 <n>,4,<NEAR>,<c>
endm
?ex1 macro n,s,d,c
?gcc ?ex2,%?PLM,<c>
irp x,<n>
.xcref
.xcref ?t&&x
.cref
?t&&x=s
ife ?ex2
extrn _&&x:&d
x equ _&&x
else
extrn x:&d
endif
endm
endm
?ex1p macro n,s,d,c,scv
?gcc ?ex2p,%?PLM,<c>
irp x,<n>
.xcref
.xcref ?t&&x
.cref
?t&&x = s
if ((?ex2p eq 1) or (?ex2p eq 2))
extrn x:PROC
else
extrn _&&x:PROC
x equ _&&x
endif
.xcref
.xcref ?CC&&x
.cref
?CC&&x=?ex2p
endm
endm
endif
ifndef ?NOLABEL
.xcref
.xcref ?lb1,?lblpu,?lb2
.xcref labelB,labelW,labelD,labelQ,labelT
.xcref labelP,labelCP,labelDP
.cref
?lblpu = 0
?lb2 = 0
labelB macro n,c
?lb1 <n>,1,<byte>,<c>
endm
labelW macro n,c
?lb1 <n>,2,<word>,<c>
endm
labelD macro n,c
?lb1 <n>,4,<dword>,<c>
endm
labelQ macro n,c
?lb1 <n>,8,<qword>,<c>
endm
labelT macro n,c
?lb1 <n>,10,<tbyte>,<c>
endm
labelP macro n,c
?lb1 <n>,4,<PROC>,<c>
endm
labelCP macro n,c
?lb1 <n>,4,<PROC>,<c>
endm
labelDP macro n,c
?lb1 <n>,4,<dword>,<c>
endm
?lb1 macro n,s,d,c
?gcc ?lb2,%?PLM,<c>
?lblpu=0
irp x,<n>
ifidn <x>,<PUBLIC>
?lblpu=1
else
.xcref
.xcref ?t&&x
.cref
?t&&x=s
if (?lb2 eq 1)
if ?lblpu
public x
endif
x label &d
else
if ?lblpu
public _&&x
endif
_&&x label &d
x equ _&&x
endif
endif
endm
endm
endif
ifndef ?NODEF
.xcref
.xcref defB,defW,defD,defQ,defT,defCP,defDP
.cref
defB macro n
?ad <n>,1
endm
defW macro n
?ad <n>,2
endm
defD macro n
?ad <n>,4
endm
defQ macro n
?ad <n>,8
endm
defT macro n
?ad <n>,10
endm
defCP macro n
defD <n>
endm
defDP macro n
defD <n>
endm
endif
?ad macro n,s
irp x,<n>
.xcref
.xcref ?t&&x
.cref
?t&&x=s
endm
endm
?NOPTR=1
ifndef ?NOPTR
.xcref
.xcref regPtr,farPtr
.cref
regPtr macro n,s,o
farPtr n,s,o
endm
farPtr macro n,s,o
.xcref
.xcref ?t&n
.cref
n &macro
push s
push o
&endm
?t&n=80h
endm
endif
.xcref
.xcref xjmp
.cref
xjmp macro n
jmp FAR PTR FLAT:&n
endm
.xcref
.xcref ADR
.cref
ADR macro n
ifdef &n
@&n &macro
lea EAX,n
push EAX
&endm
?t@&n=80h
.xcref ?t@&n
ADRentry <@&n>
?ADRCnt = ?ADRCnt + 1
else
??error <Undefined local "&n" referenced in ADR.>
endif
endm
.xcref
.xcref ADRentry
.cref
ADRentry macro n
ifnb <n>
if ?ADRSLn
?ADRS catstr &?ADRS,<,&n>
else
?ADRS catstr <&n>
endif
?ADRSLn sizestr <&?ADRS>
endif
endm
arg macro a
irp x,<a>
?argc=?argc+1
?atal <x>,%?argc
endm
endm
?atal macro n,i
.xcref
.xcref ?ali&i
.cref
?ali&i &macro
?ap n
&endm
endm
?ap macro n
?argl=?argl+4
ifdef ?t&n
ife ?t&n-1
push dword ptr (n)
exitm
endif
ife ?t&n-2
push dword ptr (n)
exitm
endif
ife ?t&n-4
push dword ptr (n)
exitm
endif
ife ?t&n-8
push dword ptr (n)[4]
push dword ptr (n)
?argl=?argl+4
exitm
endif
if ?t&n and 80h
n
exitm
endif
ife ?t&n
push dword ptr (n)
exitm
endif
endif
push n
endm
cCall macro n,a,c
ifnb <a>
arg <a>
endif
mpush %?rsl
ifdef ?CC&n
?cCall1=?CC&n
else
?cCall1=?PLM
endif
ifnb <c>
?cCall1p = ?cCall1
?gcc ?cCall1,%?cCall1,<c>
if (?cCall1 ne ?cCall1p)
%out Overriding previous calling convention specified for "&n".
endif
endif
?argl=0
if (?cCall1 eq 1)
?acb=1
else
?acb=?argc
endif
rept ?argc
uconcat <?ali>,%?acb
uconcat <purge>,,<?ali>,%?acb
if (?cCall1 eq 1)
?acb=?acb+1
else
?acb=?acb-1
endif
endm
if ((?cCall1 eq 1) OR (?cCall1 eq 2))
call n
else
call _&n
endif
if (?argl ne 0)
if (?cCall1 eq 0) OR (?cCall1 eq 2)
add esp,?argl
endif
endif
mpop %?rsl
?rsl=0
?argc= 0
?argl= 0
endm
cProc macro n,cf,a
if ?cpd
?utpe
endif
?cpd=1
???=0
?argc=0
?ba=0
?po=0
?pu=0
?ia=0
?adj=8
?rp=0
?uf=0
?winp=?WIN
?ff=0
?pas=0
?pcc=?PLM
ifnb <a>
?ri ?pas,<a>
endif
?nd=?nodata1
?nx=0
irp x,<cf>
ifidn <x>,<PUBLIC>
?pu=1
endif
ifidn <x>,<SMALL>
?uf=1
endif
ifidn <x>,<DATA>
?nd=0
endif
ifidn <x>,<NODATA>
?nd=1
endif
ifidn <x>,<ATOMIC>
?nx=1
endif
ifidn <x>,<C>
?pcc=0
endif
ifidn <x>,<PLM>
?pcc=1
endif
ifidn <x>,<PASCAL>
?pcc=1
endif
ifidn <x>,<C_SYSCALL>
?pcc=2
endif
ifidn <x>,<SYSCALL>
?pcc=2
endif
ifidn <x>,<C_STDCALL>
?pcc=3
endif
ifidn <x>,<STDCALL>
?pcc=3
endif
ifidn <x>,<WIN>
?winp=1
endif
ifidn <x>,<NONWIN>
?winp=0
endif
endm
if (?pcc eq 1)
?PLMPrevParm=0
.xcref
.xcref ?PLMParm0
.cref
?PLMParm0 &macro
purge ?PLMParm0
&endm
endif
?ADRSLn = 0
.xcref
.xcref ?CC&n
.cref
?CC&n=?pcc
if (?nx eq 1) and (?nd eq 0)
?nx = 0
??error <ATOMIC specified without NODATA - ATOMIC ignored>
endif
if ?winp
ife ?nx
?ia=2
?pas = ?pas and (not ?ds)
endif
endif
?pas = ?pas and (not (?esp+?cs+?ss))
if ?uf
?pas = ?pas and (not (?ebp+?esi+?edi))
endif
if ((?pcc eq 1) OR (?pcc eq 2))
?pg <n>,%?pu,%?pas,%?winp,<n>,%?pcc
else
?pg <_&n>,%?pu,%?pas,%?winp,<n>,%?pcc
endif
endm
?pg macro n,p,a,w,nnu,cc
.xcref
if ?uf
if ?nd
??error <NODATA encountered in &n - user frame ignored>
?uf=0
endif
endif
.xcref cBegin
cBegin &macro g
.xcref
if (cc eq 1)
uconcat <?PLMParm>,%?PLMPrevParm,%?po
endif
if ?uf
if ?rp
??error <parmR encountered in &n - user frame ignored>
?uf=0
endif
endif
?pg1 <n>,a,%?po,w,%?uf,%?nd,%?rp,cc
?cpd=0
?argc=0
?ba=1
if p
public n
endif
n proc
if ((cc eq 0) OR (cc eq 3))
nnu equ n
endif
ifidn <g>,<nogen>
if ???+?po+a+?rp
??_out <cBegin - possible invalid use of nogen>
endif
else
if ?uf
?mf 0,%???,%?po
mpush a
else
if w
ife ?nd
mov ax,ds
nop
endif
ife ?nx
push ebp
mov ebp,esp
push ds
else
if ?ff+???+?po+?rp
push ebp
mov ebp,esp
endif
endif
ife ?nd
mov ds,ax
endif
else
if ?ff+???+?po+?rp
push ebp
mov ebp,esp
endif
endif
if ?rp
?uf=0
rept ?rp
uconcat mpush,,?rp,%?uf
?uf=?uf+1
endm
endif
if ???
if ?chkstk1
ifdef ?CHKSTKPROC
?CHKSTKPROC %???
else
mov eax,???
ife cc
call _chkstk
else
call chkstk
endif
endif
else
sub esp,???
endif
endif
mpush a
endif
ifdef ?PROFILE
call StartNMeas
endif
endif
.cref
purge cBegin
&endm
.xcref ?utpe
?utpe &macro
??error <unterminated procedure definition: "&n">
&endm
.cref
endm
?pg1 macro n,a,o,w,f,d,r,cc
.xcref
.xcref cEnd
cEnd &macro g
.xcref
?ba=0
ifidn <g>,<nogen>
if o+a+r
??_out <cEnd - possible invalid use of nogen>
endif
else
ifdef ?PROFILE
call StopNMeas
endif
mpop a
if f
        db      0c3h
else
if w
ife ?nx
if (?TF eq 0) or (???+?rp)
        lea     esp,-4[ebp]
endif
        pop     ds
        pop     ebp
else
if (?TF eq 0) or (???+?rp)
        mov     esp,ebp
endif
if ???+?po+?rp
pop ebp
endif
endif
else
if ?ff+???+?po+?rp
if (?TF eq 0) or (???+?rp)
mov esp,ebp
endif
pop ebp
endif
endif
if ((cc eq 0) OR (cc eq 2))
ret
else
ret o
endif
endif
endif
n endp
?ADRa = 0
?ADRc = 0
?ADRS2 catstr <>
ifdef ?ADRS
if ?ADRSLn
ADRSpurge
?ADRSLn = 0
?ADRS catstr <>
endif
endif
.cref
purge cEnd
&endm
.cref
endm
.xcref ADRSpurge,?ADRS2,?ADRc,?ADRa;*;,?ADRS2x
ADRSpurge macro
if (?ADRSLn AND ?ADRCnt)
?ADRS2 catstr ?ADRS
REPT &?ADRCnt
?ADRa instr ?ADRS2,<@>
?ADRc instr ?ADRS2,<,>
if ((?ADRc eq 0) OR (?ADRc eq 1))
?ADRS2x substr ?ADRS,&?ADRa
purge &?ADRS2
exitm
else
?ADRc = ?ADRc - 1
?ADRS2x substr ?ADRS2,&?ADRa,&?ADRc
purge &?ADRS2x
?ADRa = ?ADRa + 1
?ADRS2 substr ?ADRS2,&?ADRa
?ADRa instr ?ADRS2,<@>
?ADRS2 substr ?ADRS2,&?ADRa
?ADRa instr ?ADRS2,<@>
if (?ADRa gt 1)
?ADRS2 substr ?ADRS2,&?ADRa
?ADRa instr ?ADRS2,<@>
else
endif
?ADRc instr ?ADRS2,<,>
endif
endm
endif
endm
errnz macro x
errnz1 <x>,%(x)
endm
errnz1 macro x1,x2
= *errnz* x1 = x2
.err
endm
errn$ macro l,x
errnz <offset FLAT:$ - offset FLAT:l x>
endm
ifdef ?PROFILE
externP <StartNMeas,StopNMeas>
endif
.xcref FLATSEGDEF
FLATSEGDEF macro
.386p
.MODEL SMALL
ASSUME CS:FLAT, DS:FLAT, SS:FLAT, ES:FLAT
endm
ifndef ?ADRS
?ADRS equ <?ADRS>
endif
ifndef ?ADRS2x
?ADRS2x equ <?ADRS2x>
endif
