/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/* bitmaps.h                                                          */
/*                                                                    */
/* Function prototypes, macros and constants used when working with   */
/* bitmaps.                                                           */
/**********************************************************************/

/**********************************************************************/
/* Bitmap Constants                                                   */
/**********************************************************************/
/**********************************************************************/
/* Sizes of various groups of fields within BITMAPINFOHEADER2         */
/**********************************************************************/
#define SIZE_BM2_MIN(b) sizeof((b)->cbFix) +   \
                        sizeof((b)->cx) +      \
                        sizeof((b)->cy) +      \
                        sizeof((b)->cPlanes) + \
                        sizeof((b)->cBitCount)

#define SIZE_BM2_TO_COMPRESS(b) \
          SIZE_BM2_MIN(b) + sizeof((b)->ulCompression)

#define SIZE_BM2_TO_IMAGE(b)          \
          SIZE_BM2_TO_COMPRESS(b) + sizeof((b)->cbImage)

#define SIZE_BM2_TO_USED(b)           \
          SIZE_BM2_TO_IMAGE(b) +      \
          sizeof((b)->cxResolution) + \
          sizeof((b)->cyResolution) + \
          sizeof((b)->cclrUsed)

#define SIZE_BM2_TO_IMPORTANT(b) \
          SIZE_BM2_TO_USED(b) + sizeof((b)->cclrImportant)

#define SIZE_BM2_TO_UNITS(b) \
          SIZE_BM2_TO_IMPORTANT(b) + sizeof((b)->usUnits)

#define SIZE_BM2_TO_RESERVED(b) \
          SIZE_BM2_TO_UNITS(b) + sizeof((b)->usReserved)

#define SIZE_BM2_TO_RECORD(b) \
          SIZE_BM2_TO_RESERVED(b) + sizeof((b)->usRecording)

#define SIZE_BM2_TO_RENDER(b) \
          SIZE_BM2_TO_RECORD(b) + sizeof((b)->usRendering)

#define SIZE_ALL_BM2_FIELDS(b)        \
          SIZE_BM2_TO_RENDER(b) +     \
          sizeof((b)->cSize1) +       \
          sizeof((b)->cSize2) +       \
          sizeof((b)->ulColorEncoding)

/**********************************************************************/
/* Maximum scan count allowed by get/set bitmap bits                  */
/**********************************************************************/
#define MAX_SCAN_COUNT  0x0000FFFF

/**********************************************************************/
/* Padding required at the beginning and end of the bits in a bitmap  */
/* (because software drawing can access outside the actual bitmap     */
/* definition)                                                        */
/**********************************************************************/
#define INITIAL_PAD_SIZE 3
#define FINAL_PAD_SIZE   3

/**********************************************************************/
/* Macros                                                             */
/**********************************************************************/
/**********************************************************************/
/* Macro evaluating to TRUE if the bitmap header, b, is in the old    */
/* format.                                                            */
/**********************************************************************/
#define OldFormatBitmap(b) ((b)->cbFix == sizeof(BITMAPINFOHEADER))

/**********************************************************************/
/* Macro evaluating to TRUE if BITMAPINFOHEADER, b, says the bitmap   */
/* is compressed                                                      */
/**********************************************************************/
#define CompressedBitmap(b) ( ((b)->cbFix >= SIZE_BM2_TO_COMPRESS(b)) && \
                              ((b)->ulCompression != BCA_UNCOMP) )


/**********************************************************************/
/* Macro evaluating to the number of bytes in each scanline of an     */
/* internal bitmap specified by BITMAPINFO, b.                        */
/* This is padded to an 8-bit boundary only.                          */
/**********************************************************************/
#define BytesPerInternalLine(b)                                        \
  ((ULONG)(((((ULONG)((b)->cx))*                                       \
              ((ULONG)((b)->cBitCount)))+7)/8))

/**********************************************************************/
/* Macro evaluating to TRUE if the bitmap header, b, is in one of the */
/* standard PM formats.                                               */
/**********************************************************************/
#define StandardPlanesBitcount(b)                                      \
              (((b)->cPlanes == 1) &&                                  \
              (((b)->cBitCount == 1) ||                                \
               ((b)->cBitCount == 4) ||                                \
               ((b)->cBitCount == 8) ||                                \
               ((b)->cBitCount == 24)))

/**********************************************************************/
/* Defect 54391 - Support for 16 bpp bitmaps.                         */
/*                                                                    */
/* Macro evaluating to TRUE if the bitmap header, b, is in the same   */
/* format as the XGA hardware. This has been added in order to        */
/* support 16 bpp (DDB's) when running in direct color mode.          */
/*                                                                    */
/* Joe Celi (12/2/92) - Defect 58015                                  */
/**********************************************************************/
#define DeviceDependentFormat(b) ( (b)->cBitCount == DDT.BitCount )

/**********************************************************************/
/* Macro evaluating to the number of bytes in the bitmap specified by */
/* BITMAPINFOHEADER, b.                                               */
/**********************************************************************/
#define SizeOfExternalBitmap(b) (BytesPerExternalLine(b,(b)->cx) * (b)->cy)
#define SizeOfInternalBitmap(b) (BytesPerInternalLine(b) * (b)->cy)

/**********************************************************************/
/* Macro evaluating to TRUE if the bitmap header, b, is for the       */
/* screen.                                                            */
/*                                                                    */
/* MEB: I think it's a     test to rely on the bitmap bits address    */
/*      being zero for the screen - (zero so often means undefined)   */
/*      A far better test (with less indirection) is just to see if   */
/*      the current header is the DirectListEntry                     */
/**********************************************************************/
//#define BitmapIsScreen(b) (BOOL)((b)->Bitmap == FNULL)
#define BitmapIsScreen(b) (b == &DirectListEntry)

/**********************************************************************/
/* Function prototypes                                                */
/**********************************************************************/
BOOL PASCAL CheckBounds(ULONG         fsCommandBits,
                        PBITMAPINFO2  pInfo,
                        POINTL        ptlStartPoint,
                        LONG          clScanLines,
                        pBitmapHeader pbhBitmap);

PBITMAPINFO2 PASCAL MemoryForUncompressedBM(PBITMAPINFO2 pInfo,
                                            PBYTE *      ppbBitmap);

BOOL PASCAL ScanStartOutsideBM(ULONG         lScanStart,
                               pBitmapHeader pbhBitmap);

BOOL PASCAL InvalidScanCount(LONG clScanCount);

pBitmapHeader PASCAL GetBMHeader(HBITMAP hBitmap);

ULONG BytesPerExternalLine(PBITMAPINFO2  pExt,
                           ULONG         cpels);

/**********************************************************************/
/* Functions in file bitmaps.c                                        */
/**********************************************************************/
PBITMAPINFO2 PASCAL CreateExternalBitmap(PBITMAPINFO2  pInfo,
                                         PBYTE *       ppbBits);

pBitmapHeader PASCAL CreateInternalBitmap(PBITMAPINFO2 pInfo);

BOOL PASCAL ValidHeader(PBITMAPINFO2 pInfo);
