/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

#define HSLPC_DATA struct { USHORT length, count; }
/* usage: HSLPC_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  USHORT count;                                                       */
/*  }                                                                   */
/*                                                                      */


#define HRLPC_DATA struct { USHORT length, count; }
/* usage: HSLPC_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  USHORT count;                                                       */
/*  }                                                                   */
/*                                                                      */

#define HSAFP_DATA struct { USHORT length; PBYTE address; BYTE flags; }
/* usage: HSAFP_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  PBYTE  address;                                                     */
/*  BYTE   flags;                                                       */
/*  }                                                                   */
/*                                                                      */

typedef struct
{
    USHORT length;
    USHORT flags;
    USHORT blk_width, blk_height;
    BYTE   dst_format, dst_reserved;
    PBYTE  dst_addr;
    USHORT dst_width, dst_height;
    coord_pr dst_xy;
    BYTE   src_format, src_reserved;
    PBYTE  src_addr;
    USHORT src_width, src_height;
    coord_pr src_xy;
    BYTE   pat_format, pat_reserved;
    PBYTE  pat_addr;
    USHORT pat_width, pat_height;
    coord_pr pat_xy;
} HBMC_DATA_TYPE;

#define HSSPRITE_DATA struct { USHORT length; BYTE flags; BYTE reserved; \
                               BYTE hot_x; BYTE hot_y;                   \
                               PBYTE sprite;                             \
                               USHORT width; USHORT height;              \
                               USHORT green1, red1, blue1;               \
                               USHORT green2, red2, blue2;}
/* usage: HSSPRITE_DATA will give the following structure               */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  BYTE   flags;                                                       */
/*  BYTE reserved;                                                      */
/*  BYTE hot_x;                                                         */
/*  BYTE hot_y;                                                         */
/*  PBYTE sprite;                                                       */
/*  USHORT width;                                                       */
/*  USHORT height;                                                      */
/*  USHORT green1, red1, blue1;                                         */
/*  USHORT green2, red2, blue2;                                         */
/*  }                                                                   */
/*                                                                      */

#define HSPRITE_DATA struct { USHORT length; coord_pr coord; }
/* usage: HSPRITE_DATA will give the following structure                */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  coord_pr coord;                                                     */
/*  }                                                                   */
/*                                                                      */

#define AI_MIX_OVERPAINT           0x02
#define AI_MIX_PATCOPY             0x13
#define AI_MIX_EXCLUSIVEOR         0x16
#define AI_MIX_DESTINVERT          0x1A
