;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)memhelp.asm        6.0 91/10/11
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************
        PAGE    58,132
        TITLE   Memory Management Device Driver - (memhelp.asm)
        .386p

        include devhlp.inc              ; Define DevHlp functions
        include devsym.inc              ; Define DOS equates
        include error.inc               ; Define Error Messages
        include ioctl.inc               ; Define IOCTL equates
        include memhelp.inc
.xlist
        include basemaca.inc            ;;;;;; 2.0 unique (dosmac replacement)
        include struc.inc               ; Define STRUC macros
.list

BioData segment word public 'DATA' use16 ;           changed class name

        extrn   DevHelp : dword         ; DevHelp Function Router Address

DevName db      DeviceDriverName, 0

GDTSels label   word                    ; allocated GDT selector
ROMFontGDT  dw  ?                       ; ROM font access
VideoGDT    dw  ?                       ; Video buffer

VideoGDTAllocFlag   dw      0           ; Video buffer is already allocated ?

DATA_END label  byte

BioData ends

BiosSeg segment byte public 'CODE' use16
        Assume  CS:BiosSeg,DS:BioData,ES:NOTHING,SS:NOTHING

Param2          equ     <(dword ptr [bp+10])>
Param1          equ     <(dword ptr [bp+14])>
Function        equ     <(dword ptr [bp+18])>

MemoryEntry     proc    far
        public  MemoryEntry

        enter 0, 0
        push    ebx                     ; save registers
        push    ecx
        push    edx
        push    esi
        push    edi
        push    ds
        push    es

        mov     ax, BioData             ; set data segment
        mov     ds, ax

        .if     <Function eq CmdRegVDDEntry>
            mov     ax, 1               ; no error
        .elseif <Function eq CmdGetGlobal>
            mov     eax, 0001b
            les     si, Param1
            mov     ebx, es:[si].GlobalInAddr
            mov     ecx, es:[si].GlobalInLen
            mov     dl, DevHlp_VMProcessToGlobal
            call    ds:DevHelp
            les     si, Param2
            mov     es:[si].GlobalOutAddr, eax
            .if     <c>
                xor     ax, ax          ; error
            .else
                mov     ax, 1           ; no error
            .endif
        .elseif <Function eq CmdFreeGlobal>
            les     si, Param1
            mov     eax, es:[si].FreeGlobalAddr
            mov     dl, DevHlp_VMFree
            call    ds:DevHelp
            .if     <c>
                xor     ax, ax          ; error
            .else
                mov     ax, 1           ; no error
            .endif
        .else
            xor     ax, ax              ; error
        .endif

        pop     es                      ; restore registers
        pop     ds
        pop     edi
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        leave
        db   66h                        ; make return 32 bit
        ret  12                         ; return, pop 12 bytes of parameter data
MemoryEntry     endp

MemoryIoctl     proc    near
        public  MemoryIoctl

        .if <es:[bx].GIOCategory eq CAT_MEMHELP> near

            .if <es:[bx].GIOFunction eq FUNC_GET_PHYS_ADDR>
                push    ds
                push    es
                push    BioData
                pop     ds

                mov     si, ds:ROMFontGDT   ; set allocated selector
                les     di, es:[bx].GIOParaPack
                mov     eax, es:[di].GetPhysAddr
                movzx   ecx, es:[di].GetPhysLen
                mov     dh, 1
                mov     dl, DevHlp_PhysToGDTSel
                call    ds:DevHelp      ; get addressability

                .if     nc
                    mov     es:[di].GetPhysSel, si
                .else
                    mov     es:[di].GetPhysSel, 0
                .endif

                pop     es
                pop     ds

                xor     ax, ax

            .elseif <es:[bx].GIOFunction eq FUNC_ALLOC_BUFF>
                push    bx
                push    ds
                push    es
                push    BioData
                pop     ds

                les     di, es:[bx].GIOParaPack
                                                        ; video buffer isn't
                .if     <ds:VideoGDTAllocFlag eq 0>     ; allocated yet ?
                    xor     ax, ax
                    mov     bx, es:[di].AllocBuffLen    ; length
                    mov     dh, 0                       ; above 1MB
                    mov     dl, DevHlp_AllocPhys
                    call    ds:DevHelp                  ; alloc phys mem
                    .if     c
                        mov     ax, STERR+ERROR_I24_GEN_FAILURE ; set error code
                        jmp     AllocBuffExit
                    .endif

                    shl     eax, 16
                    mov     ax, bx                      ; alloc phys mem addr
                    movzx   ecx, es:[di].AllocBuffLen
                    mov     si, ds:VideoGDT
                    mov     dh, 1
                    mov     dl, DevHlp_PhysToGDTSel
                    call    ds:DevHelp                  ; get addressability

                    mov     ds:VideoGDTAllocFlag, 1     ; set allocated flag

                .endif

                mov     ax, ds:VideoGDT                 ; set allocated sel
                mov     es:[di].AllocBuffSel, ax        ; set GDT sel

AllocBuffExit:
                pop     es
                pop     ds
                pop     bx

                xor     ax, ax

            .else
                mov     ax, STERR+ERROR_I24_BAD_COMMAND ; set error code

            .endif

        .else
            mov     ax, STERR+ERROR_I24_BAD_COMMAND ; set error code

        .endif

        ret
MemoryIoctl     endp

DEVICE_END LABEL BYTE

;**     INIT - MEMHELP function initialization routine
;
;       ENTRY
;               ES:BX = Request Packet
;               DS    = ?
;       EXIT
;               PDD name registered
;               GDT selectors allocated
;

MemoryInit  proc    near
        public  MemoryInit

        pusha
        push    ds
        push    es

; Register PDD
        mov     ax, BioData
        mov     ds, ax
        lea     si, DevName
        mov     ax, cs
        mov     es, ax
        lea     di, MemoryEntry
        mov     dl, DevHlp_RegisterPDD
        call    DevHelp

; allocate GDT selector
        mov     ax, BioData
        mov     ds, ax
        mov     es, ax
        mov     di, offset GDTSels
        mov     cx, 2
        mov     dl, DevHlp_AllocGDTSelector
        call    DevHelp

        pop     es
        pop     ds
        popa

; Set ends of code/data segment
        mov     word ptr es:[bx.InitpEnd],offset DEVICE_END-1
        mov     word ptr es:[bx.InitpEnd+2],offset DATA_END-1

        ret
MemoryInit  endp

BiosSeg ends
        end
