;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
_1KB	EQU	(1 *1024 )     
_64KB	EQU	(64 *_1KB)     
_128KB	EQU	(2 *_64KB)     
_640KB	EQU	(10 *_64KB)    
_1MEGB	EQU	(_1KB*_1KB)    
_4MEGB	EQU	(4 *_1MEGB)    
_16MEGB	EQU	(16 *_1MEGB)   
_64MEGB	EQU	(64 *_1MEGB)   
_4GB	EQU	(0 )           
PARASHIFT	EQU	4          
PARASIZE	EQU	(1   SHL  PARASHIFT)    
PARAMASK	EQU	(PARASIZE - 1 )
NUMPARAIN64K	EQU	(1   SHL  (16  - PARASHIFT)) 
SECTSHIFT	EQU	9          
SECTSIZE	EQU	(1   SHL  SECTSHIFT)    
SECTMASK	EQU	(SECTSIZE - 1 )
HardwareInterruptFlagSize	EQU	02H 
CFG_MCA	EQU	01H 
CFG_EISA	EQU	02H 
CFG_ABIOS_SUPPORTED	EQU	04H 
CFG_ABIOS_PRESENT	EQU	08H 
CFG_PROTECTONLY	EQU	08H 
MACH_NONE	EQU	00H       
MACH_COMPAQ	EQU	01H       
FT_MCA	EQU	02H 
FT_MCA_AND_AT	EQU	01H 
DHSTAT_DISCARDED	EQU	01H 
DHSTAT_RELOCATED	EQU	02H 
DHSTAT_MSG_LOADED	EQU	04H 
PIC1_EOI_MASK	EQU	60H   
PIC2_EOI	EQU	62H   
DH_IRQ_OUT_OF_RANGE	EQU	01H  
NPX287_BUSY_PORT	EQU	0F0H    
NPX287_REAL_PORT	EQU	0F1H    
IRQ_NPX	EQU	13        
NPX_287	EQU	0     
NPX_387	EQU	1     
OFF	EQU	0 
ON	EQU	1 
CFGAX_NPX_PRESENT	EQU	80H 
CFGAX_PS2_CENTURY_BYTE	EQU	10H             
IVTLEN	EQU	(4  * 7FH )  
DefDosHlp   MACRO dhfunction
   extrn DH&dhfunction:far
   DHtmp = offset $ - offset DosHlpFunctions
   .errnz   (DHtmp - DosHlp&dhfunction)
   dw DH&dhfunction
   dw DOSHLP_CODESEL
      ENDM

DefDiscDosHlp  MACRO dhfunction
   extrn DH&dhfunction:far
   DHtmp = offset $ - offset DosHlpFunctions
   .errnz   (DHtmp - DosHlp&dhfunction)
   dw DH&dhfunction
   dw DOSHLP_CODESEL + 10H
      ENDM

selSysInitCode EQU   110h
selSysInitData EQU   118h

DOSHLPVERSION	EQU	8 
TABLE_VERSION_SIZE	EQU	2 

DosHlpFunction	STRUC
TableVersion	DW	?
DosHlpInit	DD	?
DosHlpReboot	DD	?
DosHlpNMI	DD	?
DosHlpSizeMem	DD	?
DosHlpConfig	DD	?
DosHlpBaseDDList	DD	?
DosHlpGetDriveParms	DD	?
DosHlpInitSystemDump	DD	?
DosHlpSystemDump	DD	?
DosHlpReadSectors	DD	?
DosHlpSerInit	DD	?
DosHlpSetBaudRate	DD	?
DosHlpSerIn	DD	?
DosHlpSerOut	DD	?
DosHlpToneOn	DD	?
DosHlpToneOff	DD	?
DosHlpGetMask	DD	?
DosHlpSetMask	DD	?
DosHlpSetRealMask	DD	?
DosHlpSetProtMask	DD	?
DosHlpCallInt10	DD	?
DosHlpProtGetMessage	DD	?
DosHlpRealGetMessage	DD	?
DosHlpRegisterTmrDD	DD	?
DosHlpTmr16QueryTime	DD	?
DosHlpEnableWatchdogNMI	DD	?
DosHlpDisableWatchdogNMI	DD	?
DosHlpInstallIRET	DD	?
DosHlpDiscard	DD	?
DosHlpInitInterrupts	DD	?
DosHlpSetIRQMask	DD	?
DosHlpSendEOI	DD	?
DosHlpTmr32QueryTime	DD	?
DosHlpTmrSetRollover	DD	?
DosHlpInitNPX	DD	?
DosHlpClrBusyNPX	DD	?
DosHlpAckIntNPX	DD	?
DosHlpWaitNPX	DD	?
DosHlpValidNPXSwitch	DD	?
DosHlpVNPXReset	DD	?
DosHlpVNPXClrBusy	DD	?
DosHlpWhyNMI	DD	?
DosHlpAckNMI	DD	?
DosHlpGetIOPLList	DD	?
DosHlpResetWatchdogNMI	DD	?
DosHlpDisableCache	DD	?
DosHlpFindParity	DD	?
DosHlpEnableCache	DD	?
DosHlpGetErrorLogPtr	DD	?
DosHlpWriteErrorLog	DD	?
DosHlpReadErrorLog	DD	?
DosHlpResetParity	DD	?
DosHlpFunction	ENDS

EndKernelAccessTable MACRO
   KFtmp = offset $ - offset KernelAccessTable
   .errnz   (KFtmp - SIZE KernelAccess)
      ENDM


KernelAccess	STRUC
KernelAllocGDT	DD	?
KernelPhysToGDT	DD	?
KernelGotoReal	DD	?
KernelGotoProt	DD	?
KernelSetSSBase	DD	?
KernelIRQRouter	DD	?
KernelVirtToLin	DD	?
Kernel_IDT	DW	?
KernelNMICount	DD	?
Kernel_LoaderIOCTLWorker	DD	?
KernelAccess	ENDS


Int15c7Table	STRUC
ByteLength	DW	?
LocHiMem	DD	?
LocExMem	DD	?
SysHiMem	DD	?
SysExMem	DD	?
CacHiMem	DD	?
CacExMem	DD	?
PadHiMem	DD	?
PadExMem	DD	?
Reserved1	DW	2 DUP (?)
Reserved2	DD	7 DUP (?)
Int15c7Table	ENDS

PHYSMEMARRAYLIMIT	EQU	32 

_PHYSMEMBLOCK	STRUC
BlockStartAddr	DD	?
BlockByteLength	DD	?
WhichCPULocal	DD	?
WhichCPUCached	DD	?
_PHYSMEMBLOCK	ENDS

PHYSMEMBLOCK struc
db size _PHYSMEMBLOCK dup(?)
PHYSMEMBLOCK ends

DHVA_ACCESS_READ	EQU	0   
DHVA_ACCESS_WRITE	EQU	1   
DHPU_ACCESS_EXECUTE	EQU	0   
DHPU_ACCESS_FREE	EQU	2   
KPG_RING0_CODE	EQU	5   
CALLDH16  macro   name        


    db       MI_LONG_CALL
    CatPrefix <dd offset>, %F16PRE_, <name>
    dw       DOSHLP_CODESEL
endm

CALLDDH16  macro    name      


    db       MI_LONG_CALL
    CatPrefix <dd offset>, %F16PRE_, <name>
    dw       selSysInitCode
endm

Dev_Hlp macro  function
   mov   dl, DevHlp_&function
   call  [DEVHLP]
   endm

IPL_DEPENDENT	EQU	1   
IPL_INDEPEND	EQU	2   
BASEDD_AT	EQU	0   
BASEDD_PS2	EQU	1   
DHDriveParms   STRUC
   DPCylcount     DW 0  
   DPSPT       DW 0  
   DPHeads     DW 0  
   DPPrecomp      DW 0  
   DPFlags     DW 0  


DHDriveParms   ENDS

BOOTOFFSET	EQU	8bH       
ALT_SUPP_PORT	EQU	92H 
ALT_SUPP_REBOOT	EQU	01H 
ALT_SUPP_A20	EQU	02H 
SETSPEED_HIGH	EQU	0f002H  
_8514_HORZTOTAL	EQU	02E8H        
_8514_DSPCTRL	EQU	22E8H        
_8514_ADVCTRL	EQU	4AE8H        
_8514_ERRORTERM	EQU	92E8H        
_8514_STATUS	EQU	9AE8H        
_8514_TEST_VALUE	EQU	5555H 
_8514_STATUS_ERROR	EQU	80H 
_8514_APPLY_CRTC_RESET	EQU	53H 
_8514_REMOVE_CRTC_RESET	EQU	33H 
_8514_VGA_MODE	EQU	02H 
_8514_AF_DRAM_REFRESH	EQU	0aH 
INT10_SETMODE	EQU	00H 
INT10_WRITETTY	EQU	0eH 
INT10_QUERYMODE	EQU	0fH 
VIDEOMODE_CO80	EQU	003H 
VIDEOMODE_MONO80	EQU	007H 
VIDEOMODE_MONO640X350X4	EQU	00FH 
COM1_PORT	EQU	03f8H 
COM2_PORT	EQU	02f8H 
COM_DAT	EQU	00H 
COM_IEN	EQU	01H      
COM_IER	EQU	02H      
COM_LCR	EQU	03H      
COM_MCR	EQU	04H      
COM_LSR	EQU	05H      
COM_MSR	EQU	06H      
COM_DLL	EQU	00H      
COM_DLM	EQU	01H      
KBD_STATUS_PORT	EQU	64H      
PORT_A	EQU	60H      
BUF_FULL	EQU	2H       
PORTRESET	EQU	0F0H     
BUF_FULL_IN	EQU	2      
BUF_FULL_OUT	EQU	1      
CLOCK_RATEL	EQU	1      
CLOCK_RATEH	EQU	0C200H   
LC_DLAB	EQU	80H      
BD_150	EQU	150 
BD_300	EQU	300 
BD_600	EQU	600 
BD_1200	EQU	1200 
BD_2400	EQU	2400 
BD_4800	EQU	4800 
BD_9600	EQU	9600 
BD_19200	EQU	19200 
TIMER_PORT	EQU	40H      
SPEAKER_PORT	EQU	61H      
SPEAKER_MASK	EQU	03H      
TIMER_FREQ_HI	EQU	12H      
TIMER_FREQ_LO	EQU	34CFH 
CMOS_CTRL	EQU	70H   
CMOS_DATA	EQU	71H   
CMOS_REG_B	EQU	8bH   
ENABLE_PERIODIC_TIMER	EQU	52H   
RomDataSeg	EQU	40H   
NMI_STATUS_PORT	EQU	61H   
NMI_PORT	EQU	70H   
ENABLENMI	EQU	0dH   
DISABLENMI	EQU	8dH   
DISABLENMI_REQ	EQU	80H   
NMI_IOCHK_CONTROL	EQU	04H   
NMI_FAILSAFE_CONTROL	EQU	08H   
NWD_MAX_INTERVAL	EQU	1000      
IT_COUNTER0	EQU	0      
IT_LSBMSB	EQU	30H      
IT_LSB	EQU	10H      
IT_MODE0	EQU	0      
IT_BINARY	EQU	0      
DP_IT_ICOUNTL	EQU	0FFFFH       
DP_IT_ICOUNTH	EQU	0FFFFH       
DP_NMI_PERIOD	EQU	55     
DP_FAILSAFE_NMI_OCCURRED	EQU	80H   
DP_FAILSAFE_NMI_MASK	EQU	04H   
DP_IT2_C0_COUNT	EQU	48H      
DP_IT2_COMMAND	EQU	4BH      
EISA_IT_ICOUNTL	EQU	0FFFFH       
EISA_IT_ICOUNTH	EQU	0FFFFH       
EISA_IT_PERIOD	EQU	220       
EISA_IT2_C0_COUNT	EQU	48H      
EISA_IT2_COMMAND	EQU	4bH      
MCA_IT_ICOUNT	EQU	9      
MCA_NMI_PERIOD	EQU	500       
MCA_ARBITRATION_MASK	EQU	40H      
MCA_WATCHDOG_NMI_MASK	EQU	10H      
MCA_TC3_COUNT	EQU	44H      
MCA_TC3_COMMAND	EQU	47H      
MCA_SYSTEM_CONTROL_PORT_A	EQU	92H   
MCA_SYSTEM_CONTROL_PORT_B	EQU	61H   
MCA_ARBITRATION_REG	EQU	90H   
