;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***	VVD.INC
;
;
;	MVDM Virtual Video Exported Definitions
;
;	For include file hierarchy, see MVDM.INC
;
;	MODIFICATION HISTORY
;	07/08/92    JTP	    Created.
;

VXVIO_NAME	EQU	"VXVIO$"	    ;registered name of VXVIO

;***	Mode Data tables
;
DefStruc ,vxmode_s
    USHORT vxm_cb
    UCHAR  vxm_fbType
    UCHAR  vxm_color
    USHORT vxm_col
    USHORT vxm_row
    USHORT vxm_hres
    USHORT vxm_vres
    UCHAR  vxm_FormatID
    UCHAR  vxm_attrib
EndStruc VXMODE

DefType PVXMODE,dd

;***	VXVIO constants for system communication
;

ifndef DSP2OLD			       ;if vxvio.sys,		 ;j-ea0610
VXSYSREQ_WAITEVENT	EQU	1
VXSYSREQ_GETCURSOR	EQU	2
VXSYSREQ_SETCURSOR	EQU	3
VXSYSREQ_COPYLVB	EQU	4
VXSYSREQ_WRITESTR	EQU	5
VXSYSREQ_SAVESCREEN	EQU	6
VXSYSREQ_RESTORESCREEN	EQU	7
VXSYSREQ_SETEVENTFILTER		EQU	8

VXSYSREQ_MAX	EQU	8
else								     ;j-ea1210
VXSYSREQ_WAITEVENT	EQU	1   + VVDSYSREQ_MAX
VXSYSREQ_GETCURSOR	EQU	6   + VVDSYSREQ_MAX
VXSYSREQ_SETCURSOR	EQU	3   + VVDSYSREQ_MAX
VXSYSREQ_COPYLVB	EQU	4   + VVDSYSREQ_MAX
VXSYSREQ_WRITESTR	EQU	2   + VVDSYSREQ_MAX
VXSYSREQ_SAVESCREEN	EQU	5   + VVDSYSREQ_MAX
VXSYSREQ_RESTORESCREEN	EQU	8   + VVDSYSREQ_MAX
VXSYSREQ_SETEVENTFILTER		EQU	7   + VVDSYSREQ_MAX

VXSYSREQ_MAX	EQU	8   + VVDSYSREQ_MAX

;VVDSYSREQ_WAITSGEVENT	EQU	18
;VVDSYSREQ_WRITESTR	EQU	19
;VVDSYSREQ_SETCURSOR	EQU	20
;VVDSYSREQ_COPYLVBX	EQU	21
;VVDSYSREQ_SAVESCREEN	EQU	22
;VVDSYSREQ_GETCURSOR	EQU	23
;VVDSYSREQ_SETEVENTFILTER	EQU	24
;VVDSYSREQ_RESTORESCREEN	EQU	25
endif								     ;j-ea1210

; VX event IDs for VXSYSREQ_WAITEVENT
;

VXEVENT_NONE	EQU	0    ;no events
VXEVENT_MODE	EQU	1    ;change in VDM's mode         
VXEVENT_LVB	EQU	2    ;change in VDM's LVB          
VXEVENT_CURSOR	EQU	3    ;cursor position/type change
VXEVENT_REDRAW	EQU	4    ;redraw request from vvideo
VXEVENT_HIDE	EQU	5    ;change in foreground session
VXEVENT_FOREGROUND	EQU	6    ;change in foreground session
VXEVENT_BACKGROUND	EQU	7    ;change in foreground session
VXEVENT_STRING	EQU	8    ;string output

VXEVENT_MAX	EQU	8

VXEVENTMASK_MODE	EQU	000000001h  ;change in VDM's mode         
VXEVENTMASK_LVB		EQU	000000002h  ;change in VDM's LVB          
VXEVENTMASK_CURSOR	EQU	000000004h  ;cursor position/type change
VXEVENTMASK_REDRAW	EQU	000000008h  ;redraw request from vvideo
VXEVENTMASK_HIDE	EQU	000000010h  ;redraw request from vvideo
VXEVENTMASK_FOREGROUND	EQU	000000020h  ;change in foreground session
VXEVENTMASK_BACKGROUND	EQU	000000040h  ;change in foreground session
VXEVENTMASK_STRING	EQU	000000080h  ;string output
VXEVENTMASK_ANY		EQU	0ffffffffh

XEVENT_FLUSH	EQU	00002h	    ;flush event immediately
XEVENT_ASYNC	EQU	00008h	    ;asynchronous event
XEVENT_FORCE	EQU	00010h	    ;force to add even if the event is masked
XEVENT_OWNER	EQU	01000h	    ;caller owns EventUpdate semaphore

DefStruc ,vxe_s
    LONG   vxe_iEvent	       ;one of the VVDEVENT_* constants
    ULONG  vxe_sgID	       ;screen group ID of VDM --- Input !!
    ULONG  vxe_nData	       ;# of entries of information returned
    ULONG  vxe_iEventMask      ;event mask
EndStruc VXEVENT

DefType PVXEVENT,dd

;*** VXVIO exported function prototypes
;

 ;vvc (input for SETCURSOR and output for WaitEvent request)
DefStruc ,vxc_s
    ULONG  vxc_row	       ;row (y position) of VDM's cursor            
    ULONG  vxc_col	       ;column (x position) of VDM's cursor         
    ULONG  vxc_ulScanStart     ;starting scan-line for VDM's cursor         
    ULONG  vxc_ulScanEnd       ;ending scan-line for VDM's cursor           
    ULONG  vxc_attribute       ;cursor color( hide )/blink etc.
    ULONG  vxc_frequest	       ;indicate request type. posion, type or both.
EndStruc VXCURSOR

DefType PVXCURSOR,dd

; bit definition for vxc_attribute

CURS_MASKBLINK	EQU	00300h
CURS_BLINKOFF	EQU	00000h
CURS_BLINKLOW	EQU	00100h
CURS_BLINKMED	EQU	00200h
CURS_BLINKHI	EQU	00300h
CURS_MASKCOLOR	EQU	000f0h	 ;CURS_COLOR is always 0 for output parmeter
CURS_HIDDEN	EQU	00001h

; definition for vxc_frequest

VXC_SETPOSITION		EQU	000000001h
VXC_SETCTYPE	EQU	000000002h

DefStruc ,vxws_s			;vvws (write string event)
    ULONG  vxws_row	       ;start row position
    ULONG  vxws_col	       ;start column position
    ULONG  vxws_depth	       ;write depth
    ULONG  vxws_psinfo	       ;indicate presence of PS
EndStruc VXWSTR

DefType PVXWSTR,dd

DefStruc ,vxs_s			;vvs (output for SCROLL event)
    RECTL  vxs_rcl	       ;rectangle being scrolled
    LONG   vxs_fill	       ;fill value
    LONG   vxs_nRows	       ;# rows (negative means reverse scroll)
    LONG   vxs_nCols	       ;# columns (0,0 means rectangle blankfilled)
EndStruc VXSCROLL

DefType PVXSCROLL,dd

DefStruc ,vxa_s			;vva (output for STRING event)
    ULONG  vxa_row	       ;beginning row of string
    ULONG  vxa_col	       ;beginning column of string
    ULONG  vxa_nChars	       ;# characters in string
EndStruc VXSTRING

DefType PVXSTRING,dd

FORMATID_EPOCHCOLOR	EQU	041h
FORMATID_EPOCHMONO	EQU	081h
FORMATID_MCKCOLOR	EQU	020h
FORMATID_COMMON		EQU	070h

DefType VXLVB,RECTL
DefType PVXLVB,dd

;*** VXVIO - VVD entry table
;

DefType PVVDENTRY,dd
DefType PXVIOENTRY,dd

DefStruc ,vxex_s			;vxex (VXVIO service entries)
    PXVIOENTRY	vxex_SetVVDType
    PXVIOENTRY	vxex_AddEvent
    PXVIOENTRY	vxex_FlushEvent
    PXVIOENTRY	vxex_SetStatus
EndStruc VXENTRYSX

DefType PVXENTRYSX,dd

DefStruc ,vxev_s			;vxev (VVD service entries)
    PVVDENTRY	vxev_GetCursor
    PVVDENTRY	vxev_SetCursor
    PVVDENTRY	vxev_CopyLVB
    PVVDENTRY	vxev_WriteString
    PVVDENTRY	vxev_SaveScreen
    PVVDENTRY	vxev_RestoreScreen
EndStruc VXENTRYSV

DefType PVXENTRYSV,dd

XVIO_RESET_FLAG		EQU	0
XVIO_SET_FLAG	EQU	1

XVIO_STATUS_MODECHANGING	EQU	0
XVIO_STATUS_XVIOUPDATING	EQU	1
XVIO_STATUS_STATEINIT	EQU	2

;***	VXVIO constants for inter-VDD communication
;

VXDEVREQ_REGISTERVVD	EQU	1   ;register VVD into VXVIO

VXDEVREQ_MAX	EQU	1

DefStruc ,vxr_s
    ULONG	vxr_VVDID
    VXENTRYSX	vxr_XVIOEntry
EndStruc VXREGISTER

DefType PVXREGISTER,dd
