;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;***	VKBD.INC
;
;
;	MVDM Virtual Keyboard Exported Definitions
;
;	For include file hierarchy, see MVDM.INC
;
;
;	MODIFICATION HISTORY
;	10/11/88	Created.
;


ifndef INCL_NONE	       ;include everything by default
INCL_VKBD	EQU 1
endif

ifdef  INCL_VKBD
INCL_VKBDSYSREQ		EQU 1
INCL_VKBDINTERFACES	EQU 1
endif



ifdef  INCL_VKBDSYSREQ

;***	VKBD constants
;

VKBD_NAME	EQU	"VKBD$"


;***	VKBD constants for PMVDMP				       ;ss0007
;								       ;ss0007
ifdef  INCL_NLSSHLD						      ;ss0007
								       ;ss0007
NIP_PMINPUTMETHOD	EQU	00000h	;Current Input method is of PM	 ;ss0008
NIP_FSINPUTMETHOD	EQU	00001h	;Current Input method is of FS	 ;ss0008
NIP_PS55	EQU	00000h	;PS/55 BIOS : bit 2-1 : 0 0	 ;ss0008
NIP_PS2		EQU	00002h	;PS/2  BIOS :		0 1	 ;ss0008
				    ;PS/55 GALE :(reserved) 1 0	     ;ss0008
				    ;Reserved	:	    1 1	     ;ss0008
endif  ;INCL_NLSSHLD						     //ss0007

; VKBD functions for use by PMVDMP
;
VKBDSYSREQ_SETACCESS	EQU	1   ;Obtain exclusive access for VDM
VKBDSYSREQ_SETFOCUS	EQU	2   ;Notify VDM is gaining/losing focus
VKBDSYSREQ_POSTSCAN	EQU	3   ;Send scan code (typed)
VKBDSYSREQ_POSTCHAR	EQU	4   ;Send character code (pasted)
VKBDSYSREQ_MONREGIST	EQU	5   ;Register Monitor into VKBD		      ;ss0001
VKBDSYSREQ_MONDEREGIST	EQU	6   ;Deregister Monitor from VKBD	      ;ss0001
VKBDSYSREQ_MONREAD	EQU	7   ;Read key-stroke			      ;ss0001
VKBDSYSREQ_MONWRITE	EQU	8   ;Write key-stroke			      ;ss0001
VKBDSYSREQ_SETSHIFT	EQU	9   ;Set Keyboard shift status		      ;ss0001
VKBDSYSREQ_GETSHIFT	EQU	10   ;Get Keyboard shift status		       ;ss0001
VKBDSYSREQ_REGWVDM	EQU	11   ;Register PMFEP into VKBD		       ;ss0006
VKBDSYSREQ_DEREGWVDM	EQU	12   ;Deregister PMFEP from VKBD	       ;ss0006
VKBDSYSREQ_READWVDM	EQU	13   ;Read key-stroke			       ;ss0006
VKBDSYSREQ_WRITEWVDM	EQU	14   ;Write key-stroke			       ;ss0006
VKBDSYSREQ_MAX	EQU	14						 ;ss0006


;***	VKBD data types
;

DefStruc ,keypkt_s			;kp (for VKBDSYSREQ_POSTSCAN/CHAR)
    UCHAR	kp_Scan		   ;scan code
    UCHAR	kp_Char		   ;translated char
    USHORT	kp_fsState	   ;shift states
    USHORT	kp_fsDDFlags	   ;translated flags
    USHORT	kp_fsKey	   ;key flags
EndStruc KEYPKT
DefType PKEYPKT,dd
DefType PPKEYPKT,dd

DefStruc ,shiftpkt_s			;sp (for VKBDSYSREQ_SETFOCUS)
    USHORT	fSetFocus	   ;TRUE to set focus, FALSE to clear focus
    USHORT	fsShift		   ;PM shift states during set focus
				    ;  undefined during clear focus
EndStruc SHIFTPKT
DefType PSHIFTPKT,dd
DefType PPSHIFTPKT,dd

VKBDEVENT_CREATE	EQU	0				       ;ss0001
VKBDEVENT_TERM	EQU	1				       ;ss0001

VKBDEVENT_KEY	EQU	2				       ;ss0001
VKBDEVENT_SHIFT		EQU	3				       ;ss0001
VKBDEVENT_DOS_SHIFT	EQU	4				       ;ss0002

VKBDEVENT_CHG_ENV	EQU	5				       ;ss0012

VKBD_KKC_DOS	EQU	00000h				       ;ss0012
VKBD_KKC_SHARED		EQU	00001h				       ;ss0012

VKBD_VDMIMFEP_MODE	EQU	00000h				       ;ss0012
VKBD_VDMPMFEP_MODE	EQU	00002h				       ;ss0012

VKBD_REG_VDMIMFEP	EQU	00001h				       ;ss0006
VKBD_REG_VDMPMFEP	EQU	00002h				       ;ss0006

VKBD_US_BIOS_MODE	EQU	08000h				       ;ss0020
VKBD_JP_BIOS_DOSV	EQU	00002h	  ;1 means Environment is DOSV	    ;ss0020

VKBD_ENV_TO_FULLSCREEN	EQU	0				       ;ss0012
VKBD_ENV_TO_WINDOWED	EQU	1				       ;ss0012

DefStruc ,vkevent_s			;ve (for DBCS SystemReq)       ;ss0001
	USHORT	ve_event_id					      ;ss0001
	SGID	ve_sgid						      ;ss0001
	UCHAR	ve_monitor_flag					      ;ss0001
	UCHAR	ve_r_scancode					      ;ss0001
	UCHAR	ve_charcode					      ;ss0001
	UCHAR	ve_scancode					      ;ss0001
	UCHAR	ve_nlsstate					      ;ss0001
	UCHAR	ve_nlsshift					      ;ss0001
	USHORT	ve_shift					      ;ss0001
	ULONG	ve_timestamp					      ;ss0001
	USHORT	ve_DDFlags					      ;ss0001
EndStruc VKEVENT							     ;ss0001

DefType PVKEVENT,dd			;ss0001

;ss0010	   Property Entry Name
;ss0031 DBCS_INPUT_METHOD_LIST	EQU	"FS Input Method in Windowed DOS\0PM Input Method in Windowed DOS\0Using DOS KKC Device Driver\0"
DBCS_INPUT_METHOD_LIST	EQU	"OS2_FS_FEP\0PM_FEP\0DOS_FEP\0"			;ss0031

;ss0014 Following definitions are moved to PROPNAME.INC				 //ss0014
;SINGLE_INPUT_METHOD	EQU	"FS Input Method in Windowed DOS"	      //ss0010
;DUAL_INPUT_METHODS	EQU	"PM Input Method in Windowed DOS"	      //ss0010
;DOS_KKC_MODE	EQU	"Using DOS KKC Device Driver"		      //ss0010
;ss0010

endif ;INCL_VKBDSYSREQ



;***	VKBD function prototypes
;

ifdef INCL_VKBDINTERFACES

DefType PFNSCRNP,dd

VDHENTRY VDHRegisterScreenProc		<PFNSCRNP>
VDHENTRY VDHQueryKeyShift		<HVDM>

;VPL Idle detection services
VDHENTRY VDHWakeIdle		<HVDM>
VDHENTRY VDHReportPeek		<ULONG>
VDHENTRY VDHNotIdle		<VOID>
VDHENTRY VDHGetBusyFlagPtr		<void>

;requests for SVC access to VPL polling services
VPL_NAME	EQU	"VPL_IDLE"
VDHVPL_BUSY_ADDR	EQU	0	  ;provide V86 busy byte address
VDHVPL_WAIT	EQU	1	  ;make VDM sleep
VDHVPL_NOIDLE	EQU	2	  ;Turn idle detection off
VDHVPL_WAKE	EQU	3	  ;Report busy activity

endif
