;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*static char *SCCSID = "@(#)vgaemu     1.0 92/05/01";*/
;
;/**********************  START OF SPECIFICATIONS  ***********************/
;/*                                                                      */
;/*  SOURCE FILE NAME:    VGAEMU.H                                       */
;/*                                                                      */
;/*  DESCRIPTIVE NAME:    Video buffer, font buffer, work variables      */
;/*                       definitions for text mode emulation            */
;/*                       with VGA graphics mode for VGA version OS/2.   */
;/*                                                                      */
;/*  COPYRIGHT:           na                                             */
;/*                                                                      */
;/*  STATUS:              na                                             */
;/*                                                                      */
;/*  NOTES:               None                                           */
;/*                                                                      */
;/*  CHANGE HISTORY:                                                     */
;/*                      92/05/01    Initial coding (T.Sobue)            */
;/*                                                                      */
;/***********************  END OF SPECIFICATIONS  ************************/

MAX_ROWS        equ     26              ; maximun row count
MAX_COLS        equ     82              ; maximun column count
CELL_SIZE       equ     4               ; cell size (char/attr0/attr1/attr2)
                                        ; 
FONT_HEIGHT     equ     18              ; font height on screen
FONT_HEIGHT2    equ     19              ; font height in font file
MAX_SBCS_FONT   equ     256             ; number of SBCS character font
                                        ; 
MAX_PLANE       equ     4               ; max APA plane
MAX_SAVE_CHAR   equ     2               ; max save char count for text cursor

VGASBCSFontType     struc
VGA_CodePage        dw  ?                                   ; code page
VGA_FontType0       dw  ?                                   ; font type 0
VGA_FontType1       dw  ?                                   ; font type 1
VGA_FontID          dw  ?                                   ; font ID
VGASBCSFontType     ends

VGASBCSFont         struc
VGA_FontType        db  size VGASBCSFontType dup(?)         ; font attr
VGA_FontImage       db  MAX_SBCS_FONT*FONT_HEIGHT2 dup(?)   ; font image
VGASBCSFont         ends

VGATextEmulationBuffer  struc
shadow              db  MAX_ROWS*MAX_COLS*CELL_SIZE dup(?)  ; text video buffer
VGA_APAStart        dw  ?, ?                                ; APA start address
VGA_GridColor       db  ?, ?                                ; grid draw color
VGA_CsrRow          dw  ?                                   ; cursor row position
VGA_CsrCol          dw  ?                                   ; cursor column position
VGA_CsrStart        dw  ?                                   ; cursor start line
VGA_CsrEnd          dw  ?                                   ; cursor end line
VGA_CsrWidth        dw  ?                                   ; cursor width
VGA_CsrAttrib       dw  ?                                   ; cursor attribute
VGA_CsrColor        dw  ?                                   ; cursor color
VGA_CsrScrWidth     dw  ?                                   ; screen width for cursor draw
VGA_SaveFlag        dw  ?                                   ; character save flag
VGA_SaveChar        db  MAX_SAVE_CHAR*MAX_PLANE*FONT_HEIGHT dup(?)  ; character save area
VGA_BaseFont        db  size VGASBCSFont dup(?)             ; base SBCS font
VGA_ExtensionFont   db  size VGASBCSFont dup(?)             ; extension SBCS font
VGATextEmulationBuffer  ends
