;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)memhelp.inc            6.0 91/10/14
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;/***********************************************************************/
;/*                                                                     */
;/* SOURCE FILE NAME: memhelp.inc       STATUS: Version 1.0             */
;/*                                                                     */
;/* DESCRIPTIVE NAME:  Memory Management Helper for VDD include file    */
;/*                                                                     */
;/* FUNCTION:   Define all global values.                               */
;/*                                                                     */
;/************************ END OF SPECIFICATIONS ************************/


; Memory management device driver name

DeviceDriverName    equ    'SCREEN$ '           ; must be length 8 byte !!

; protect mode service routine definition

CAT_MEMHELP         equ     03h                 ; memhelp category
FUNC_GET_PHYS_ADDR  equ     7fh                 ; get ROS font address
FUNC_ALLOC_BUFF     equ     7eh                 ; allocate video buffer

; FUNC_GET_PHYS_ADDR

ParamGetPhys        struc
GetPhysAddr         dd      ?                   ; requested physical address
GetPhysLen          dw      ?                   ; length
GetPhysSel          dw      ?                   ; allocated GDT
ParamGetPhys        ends

; FUNC_ALLOC_BUFF

ParamAllocBuff      struc
AllocBuffLen        dw      ?                   ; requested buffer length
AllocBuffSel        dw      ?                   ; allocated GDT
ParamAllocBuff      ends

; VDD service routine definition

; Command definitions

CmdRegVDDEntry      equ     0                   ; register the entry of VDD
CmdGetGlobal        equ     1                   ; map private to global
CmdFreeGlobal       equ     2                   ; free global mapping

; Command parameter definitions

; CmdGetGlobal

GetGlobalIn         struc
GlobalInAddr        dd      ?                   ; linear address to be mapped into global address
GlobalInLen         dd      ?                   ; memory length
GetGlobalIn         ends

GetGlobalOut        struc
GlobalOutAddr       dd      ?                   ; mapped global linear address
GetGlobalOut        ends

; CmdFreeGlobal
FreeGlobalIn        struc
FreeGlobalAddr      dd      ?                   ; linear address to be freed
FreeGlobalIn        ends
