;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;***	INT2F.INC
;
;
;	Title:
;
;	_INT 2F API definations
;
;	Description:
;
;	Contains the         3.0 _INT 2F services definations
;



INT2F_INT	EQU	02Fh

; All         3.0 _INT 2F API must be issued with AH = 16h

INT2F_WINDOWS_MULTIPLEX		EQU	016h

;         3.0 _INT 2F API calls

INT2F_GET_VERSION	EQU	000h	;install check/Get version
INT2F_OLD_GET_VMID_API	EQU	002h	;2.xx get VMID API call
INT2F_STARTUP	EQU	005h	;sent when Win386 starting
INT2F_EXIT	EQU	006h	;sent when Win386 exited
INT2F_DEVICE_BROADCAST	EQU	007h	;sent by virtual device
INT2F_STARTUP_COMPLETE	EQU	008h	;sent when start is done
INT2F_BEGIN_EXIT	EQU	009h	;starting a NORMAL exit

INT2F_HIGH_FUNCTION	EQU	080h
INT2F_HIGH_FUNCTION_BIT		EQU	7

INT2F_RELEASE_TIME	EQU	080h	;release cur VM's time-slice
INT2F_BEGIN_CRITICAL	EQU	081h	;begin critical section
INT2F_END_CRITICAL	EQU	082h	;end critical section
INT2F_GET_CUR_VMID	EQU	083h	;returns BX = ID of current VM
INT2F_GET_DEVICE_API	EQU	084h	;returns ES:DI -> Device API
INT2F_SWITCH_AND_CALL	EQU	085h	;change VMs and call-back
INT2F_TEST_INT31_AVAIL	EQU	086h	;returns AX=0 if Int 31 avail
INT2F_GET_PM_SWITCH_ADDR	EQU	087h	;get call-back addr for PM
INT2F_GET_LDT_BASE_SEL	EQU	088h	;get selector to LDT
INT2F_WIN_KERNEL_IDLE	EQU	089h	;windows kernel idle call

; Flags passed to the INT2F_WIN_KERNEL_IDLE call to indicate
; state of         in the BX register.

INT2F_WIN_IDLE_MOUSE_BUSY	EQU	001h
INT2F_WIN_IDLE_MOUSE_BUSY_BIT	EQU	0

; Flags returned by INT2F_GET_PM_SWITCH_ADDR

INT2F_32BIT_PROGRAMS_SUPPORTED	EQU	001h

INT2F_286_PROCESSOR	EQU	002h
INT2F_386_PROCESSOR	EQU	003h
INT2F_486_PROCESSOR	EQU	004h

;  Equates for OS/2 detect and get VDD API calls
INT2F_GETOS2VER		EQU	04010h
INT2F_GETVDDAPI		EQU	04011h
