/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( suspend )
   #endif
   #pragma checkout( resume )
#endif
/* INC */

#define PMWINP_INCLUDED


#ifndef INCL_WINP_SELECTIVE
   #define INCL_WINP_ALL
#endif

#ifdef INCL_WINP_ALL
   #define INCL_WINP_SEI
   #define INCL_WINP_FSRS
   #define INCL_WINP_MISC
   #define INCL_WINP_WININSTDATA
   #define INCL_WINP_DISP32
#endif
#define WPTR_ARROW          32512
#define WPTR_UPARROW        32516
#define WPTR_CROSS          32515
#define WPTR_IBEAM          32513
#define WPTR_ICON           32641
#define WPTR_SIZE           32640
#define WPTR_SIZENS         32645
#define WPTR_SIZEWE         32644
#define WPTR_SIZENWSE       32642
#define WPTR_SIZENESW       32643
#define WPTR_WAIT           32514

#ifndef RC_INVOKED
   
   #ifdef INCL_WINP_SEI
      #ifndef SEI_PMWIN                                                       /*@D7D*/
         #define SEI_PMWINP                                                    /*@D7D*/
         #include <pmsei.h>                                                    /*@D7D*/
      #endif /*SEI_PMWIN*/                                                    /*@D7D*/
   #endif /* INCL_WINP_SEI */
   
   #ifdef INCL_WINP_FSRS
      
      /* Fast, Safe RAM Semaphore declarations */
      
      typedef struct _FSRSEM    /* fsrs */
      {
         USHORT Length;
         USHORT Padding;
         USHORT ProcID;
         USHORT ThrdID;
         USHORT Usage;
         USHORT Client;
         ULONG  Timeout;
         ULONG  RAMsem;
      } FSRSEM;
      typedef FSRSEM *PFSRSEM;
      
      int   APIENTRY FSRSemEnter( PFSRSEM );
      
      VOID  APIENTRY FSRSemLeave( PFSRSEM );
      
      VOID  APIENTRY FSRSemExit( PFSRSEM );
      
      ULONG APIENTRY FSRSemCheck(  PFSRSEM );
      
      int   APIENTRY FSRSemEnterP( ULONG,
                                  PFSRSEM );
      
   #endif /* INCL_WINP_FSRS */
   #define EXLST_PRTY_UNLOCK       0x1080      /* Unlock DLL: free semaphores, etc */
   #define EXLST_PRTY_PMDRIVERS    0xad00      /* Drivers: display, printers */
#endif /* RC_INVOKED */

#ifdef INCL_WINP_MISC
   
   #ifndef RC_INVOKED
      #define HK_PREACCEL                 17
      /* InputGetDeviceInfo declarations */
      
      typedef struct _INPUTINFO     /* inpi */
      {
         USHORT KbdType;
         USHORT NumFunc;
         USHORT HasBreak;
         USHORT MouType;
         USHORT NumButtons;
         USHORT NumMickeys;
      } INPUTINFO;
      typedef INPUTINFO *PINPUTINFO;
      
      int  APIENTRY InputGetDeviceInfo( PINPUTINFO );
      typedef struct _KBDEVENT      /* kevt */
      {
         BYTE monFlags;          /* Open, Close and Flush monitor flags */
         BYTE scancode;          /* Original scan code (actually high byte of
         monitor flags */
         BYTE xlatedchar;        /* Output of interrupt level character translation
         table */
         
         BYTE xlatedscan;        /* Translated scan code.  Different only for
         the enhanced keyboard */
         
         USHORT shiftDBCS;         /* DBCS shift state and status */
         USHORT shiftstate;        /* Current state of shift keys */
         ULONG time;             /* millisecond counter time stamp */
         USHORT ddFlags;           /* Keyboard device driver flags */
      } KBDEVENT;
      typedef KBDEVENT *PKBDEVENT;
      /* Valid values for ddFlags field */
      #define KDD_MULTIMAKE   0x0100
      #define KDD_BREAK       0x0040
      
      #define KDD_EXTENDEDKEY 0x0020  /* added for dcr 357 */
      /* Valid values for KDD_ACTIONFIELD portion of ddFlags field */
      #define KDD_SHIFTKEY    0x0007
      #define KDD_PAUSEKEY    0x0008
      #define KDD_BREAKKEY    0x0011
      #define KDD_PSEUDOBREAK 0x0012
      #define DebugOutput Debug32Output
      int     APIENTRY Debug32Output( PCH );
   #endif      /* RC_INVOKED */
   
   
   
   /* Input Translation Tables */
   
   /* Valid values for idKeyboardType field */
   #define KB_AT         0       /* PC/AT physical keyboard */
   #define KB_ENHANCED   1       /* Enhanced PC/AT physical keyboard */
   #define KB_SUPERSPORT 2       /* Supersport physical keyboard   @D1A  */
   #define KB_JAGUAR     3       /* Jaguar physical keyboard PeteR Jaguar */
   #define KBD_MSG  0x0200       /* Offset to add when looking up layout names */
   
   /* Valid values for idNationalKeyboard field */
   #define LG_VKEY       1       /* VKey translation table */
   #define LG_BE         2       /* Belgium translation table */
   #define LG_CF         3       /* Canadian-French translation table */
   #define LG_DK         4       /* Denmark translation table */
   #define LG_FR         5       /* France translation table */
   #define LG_GR         6       /* Germany translation table */
   #define LG_IT         7       /* Italy translation table */
   #define LG_LA         8       /* Latin-American Spanish translation table */
   #define LG_NL         9       /* Netherlands translation table */
   #define LG_NO        10       /* Norway translation table */
   #define LG_PO        11       /* Portugal translation table */
   #define LG_SF        12       /* Swiss-French translation table */
   #define LG_SG        13       /* Swiss-German translation table */
   #define LG_SP        14       /* Spain translation table */
   #define LG_SU        15       /* Finland translation table */
   #define LG_SV        16       /* Sweden translation table */
   #define LG_UK        17       /* United Kingdom translation table */
   #define LG_US        18       /* United States translation table */
   #define LG_FR_NEW    19       /* New French layout */
   #define LG_IT_NEW    20       /* New Italian layout */
   #define LG_UK_NEW    21       /* New British layout */
   #define LG_TR        22         /* Turkish */
   #define LG_CS        23         /* Czech */
   #define LG_CS_NEW    24         /* New Czech */
   #define LG_HU        25         /* Hungarian */
   #define LG_YU        26         /* Yugoslav */
   #define LG_PL        27         /* Polish */
   #define LG_IC        28         /* Icelandic */
   #define LG_BR        29         /* Brazil */
   #define LG_ALPHANUMERIC 0x50
   #define LG_KATAKANA     0x51
   #define LG_KATAR        0x52
   #define LG_HIRAGANA     0x53
   #define LG_HIRAR        0x54
   /* Valid values for iOutputType field */
   #define OUT_GLYPH     0       /* Table outputs a glyph */
   #define OUT_VKEY      1       /* Table outputs a vkey  */
   
   
   
   #ifndef RC_INVOKED
      
      typedef struct _VKEYGLYPHXLATETBL   /* vkglxl */
      {
         USHORT    cbHeader;       /* size of fixed header (this structure) */
         USHORT    signature;      /* Signature USHORT */
         USHORT    idKeyboardtype; /* PC/AT or enhanced keyboard */
         USHORT    idNationalKeyboard; /* National keyboard identity */
         USHORT    iOutputType;    /* Table returns glyph or vkey */
         USHORT    cShiftKeys;     /* number of shift keys */
         USHORT    offShiftKeys;   /* offset to shift key table */
         USHORT    cTglKeys;       /* number of toggle keys */
         USHORT    offTglKeys;     /* offset to toggle key table */
         USHORT    cShiftStates;   /* number of shift states */
         USHORT    offShiftXLate;  /* offset to shift state translation table */
      } VKEYGLYPHXLATETBL;
      typedef VKEYGLYPHXLATETBL *PVKEYGLYPHXLATETBL;
      
      
      typedef struct _VKEYGLYPHXLATETBL2   /* vkglxl2 */
      {
         USHORT    cbHeader;       /* size of fixed header (this structure) */
         USHORT    signature;      /* Signature USHORT */
         USHORT    idKeyboardtype; /* PC/AT or enhanced keyboard */
         USHORT    idNationalKeyboard; /* National keyboard identity */
         USHORT    iOutputType;    /* Table returns glyph or vkey */
         USHORT    cShiftKeys;     /* number of shift keys */
         USHORT    offShiftKeys;   /* offset to shift key table */
         USHORT    cTglKeys;       /* number of toggle keys */
         USHORT    offTglKeys;     /* offset to toggle key table */
         USHORT    cShiftStates;   /* number of shift states */
         USHORT    offShiftXLate;  /* offset to shift state translation table */
         USHORT    offTglKeys2;    /* offset to toggle key table(new format) @NSJ200322 */
      } VKEYGLYPHXLATETBL2;
      typedef VKEYGLYPHXLATETBL2 *PVKEYGLYPHXLATETBL2;
      
      /* Valid value for signature field */
      #define VKEYGLYPHXLATETBL_SIG     0x4758  /* Signature value = 'GX' */
      
      
      typedef struct _SHIFTKEYS       /* scsh */
      {
         BYTE    rgShiftKeys[ 1 ];       /* scan code for each shift key */
         BYTE    rgShiftPriority[ 1 ];   /* priority of this shift key (1-8) */
      } SHIFTKEYS[];
      
      /* The shift state priority is used to compute the shift state bit for each */
      /* shift key.  For example, the standard PC-AT keyboard has the following   */
      /* shift key table:                                                         */
      /*                                                                          */
      /*     DB Alt, Ctrl, LeftShift, RightShift                                  */
      /*     DB 3,   2,    1,         1                                           */
      /* The following flag, if set in the rgShiftPriority field, causes the      */
      /* a down transition of this shift key to reset any toggle key that         */
      /* toggles this shift priority.  Used to implement ShiftLock key            */
      /* functionality                                                            */
      /*                                                                          */
      
      #define XL_TOGGLERESET  0x80
      
      
      typedef struct _TOGGLEKEYS      /* sctg */
      {
         BYTE    rgTglKeys[ 1 ];     /* scan code for each toggle key */
         USHORT  rgoffTglInfo[ 1 ];  /* offset to toggle key information */
      } TOGGLEKEYS[];
      
      typedef struct _TOGGLEKEYS2     /* sctg2 */
      {
         BYTE    rgTglKeys[ 1 ];     /* scan code for each toggle key */
         USHORT  rgoffTglInfo[ 1 ];  /* offset to toggle key information */
         BYTE    rgTglShiftState[ 1 ];/* shift state for each toggle key @NSJ200322 */
      } TOGGLEKEYS2[];
      
      #define tglshft_base_state               0x00
      #define tglshft_shift_state              0x01
      #define tglshft_ctrl_state               0x02
      #define tglshft_ctrl_shift_state         0x03
      #define tglshft_alt_state                0x04
      #define tglshft_alt_shift_state          0x05
      #define tglshft_alt_ctrl_state           0x06
      #define tglshft_alt_ctrl_shift_state     0x07
      
      
      typedef struct _TOGGLEINFO      /* tgi */
      {
         BYTE    nTglShiftPri;       /* Shift key priority to toggle */
         BYTE    cTglKeyRanges;      /* #scan code ranges for this toggle key */
         USHORT  rgTglKeys[ 1 ];     /* scan code ranges */
      } TOGGLEINFO;
      /* Low byte is low scan code of range and */
      /* High byte is high scan code of range */
      
      
      typedef struct _SHIFTXLATE      /* shxl */
      {
         USHORT    rgoffScanXLate[ 1 ];/* offset to scan code xlates for shift state */
      } SHIFTXLATE;
      
      
      typedef struct _SCANXLATE       /* scxl */
      {
         USHORT  cScanRanges;        /* number of distinct scan code ranges */
         BYTE    bScanLow;           /* Low value of first scan code range */
         BYTE    bScanHigh;          /* High value of first scan code range */
         USHORT  rgScanXLate[ 1 ];   /* Array of translations for each scan code
         in range */
      } SCANXLATE;
      
      
      /* Valid values for elements of rgScanXLate array */
      #define XL_NOXLATE      0x0000
      #define XL_NOTENHANCED  0x00FF                                     /* @D1A */
      #define XL_GLYPHMASK    0x7FFF
      #define XL_VKEYMASK     0x00FF
      #define XL_VKEYBITS     0x7F00
      
      /* The high order bit is always returned as zero */
      /* Internally, high bit is used for controlling the translation process */
      #define XL_NORETRY      0x8000
      
      
      typedef struct _CHARXLATETBL    /* chxl */
      {
         USHORT    cbHeader;       /* size of fixed header (this structure) */
         USHORT    signature;      /* Signature word */
         USHORT    idCodePage;     /* code page that this table is for */
         USHORT    cGlyphRanges;   /* number of glyph ranges */
         USHORT    offGlyphTbl;    /* Offset to glyph ranges */
         USHORT    cCharRanges;    /* number of character ranges */
         USHORT    offCharTbl;     /* Offset to character ranges */
      } CHARXLATETBL;
      typedef CHARXLATETBL *PCHARXLATETBL;
      
      /* Valid value for signature field */
      #define CHARXLATETBL_SIG    0x4358  /* Signature value = 'CX' */
      
      typedef struct _GLYPHTBL    /* gltb */
      {
         USHORT wGlyphLow;         /* Low glyph for this range */
         USHORT wGlyphHigh;        /* High glyph for this range */
         USHORT rgChars[ 1 ];      /* Character code for each glyph in range */
      } GLYPHTBL;
      /* High byte valid only if low byte is a       */
      /* valid DBCS prefix character (i.e. contained */
      /* in DBCSTBL).  Word of zeros means that      */
      /* no code point in code page for this glyph   */
      
      typedef struct _CHARTBL     /* chtb */
      {
         USHORT wCharLow;          /* Low character for this range */
         USHORT wCharHigh;         /* High character for this range */
         USHORT rgGlyphs[ 1 ];     /* Glyph code for each character in range */
      } CHARTBL;
      
      typedef struct _DKEYTBL     /* dktb */
      {
         USHORT wDKeyLow;          /* Low glyph for this range */
         USHORT wDKeyHigh;         /* High glyph for this range */
         USHORT rgoffDKeyInfo[ 1 ];/* Deadkey info for each glyph in range */
      } DKEYTBL;
      
      typedef struct _DKEYINFO    /* dki */
      {
         USHORT cDKeyComb;         /* number of valid deadkey combinations */
         USHORT rgDKeyComb[ 1 ];   /* Second glyph in deadkey combination */
         USHORT rgDKeyGlyph[ 1 ];  /* Resulting glyph for corresponding comb */
      } DKEYINFO;
      
      
      PVKEYGLYPHXLATETBL APIENTRY WinLoadVKeyGlyphXlateTbl(HAB,
                                                           HMODULE,
                                                           USHORT,
                                                           USHORT,
                                                           USHORT);
      PCHARXLATETBL      APIENTRY WinLoadCharXlateTbl(HAB,
                                                      HMODULE,
                                                      USHORT);
      PVKEYGLYPHXLATETBL APIENTRY WinSetVKeyGlyphXlateTbl(PVKEYGLYPHXLATETBL,
                                                          USHORT);
      PCHARXLATETBL      APIENTRY WinSetCharXlateTbl(HMQ,
                                                     PCHARXLATETBL);
      USHORT             APIENTRY WinQueryProcessCP( VOID );
   #endif      /* RC_INVOKED */
   
   /* IDS for separators in system menu */
   #define SMID_SEPARATOR1  -2
   #define SMID_SEPARATOR2  -3
#endif /* INCL_WINP_MISC */

#ifdef INCL_WINP_SELSERVER
   USHORT APIENTRY SSAllocSeg(USHORT cb,
                              PSEL ps,
                              USHORT fsAttr);
   USHORT APIENTRY SSFreeSeg(SEL s);
#endif /* INCL_WINP_SELSERVER */
#ifdef INCL_WINPOINTERS
   
   #ifdef KITTYHAWK
      /* system bitmap constants for closebutton */
      #define SBMP_CLOSEBUTTON           50
      #define SBMP_CLOSEBUTTONDEP        51
   #endif
#endif      /* INCL_WINPOINTERS */
#ifdef INCL_WINP_WININSTDATA
   ULONG   APIENTRY WinVisRegionNotify(HDC hdc);
#endif /* INCL_WINP_WININSTDATA */
#ifdef INCL_WINHELP
   typedef HWND (EXPENTRY FNCHI)(HAB, PHELPINIT);         /* WinCreateHelpInstance    */
   typedef FNCHI *PFNCHI;
   typedef BOOL (EXPENTRY FNDHI)(HWND);                   /* WinDestroyHelpInstance   */
   typedef FNDHI *PFNDHI;
   typedef BOOL (EXPENTRY FNAHI)(HWND, HWND);             /* WinAssociateHelpInstance */
   typedef FNAHI *PFNAHI;
#endif

/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( resume )
   #endif
   #pragma checkout( resume )
#endif
/* INC */
