/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vkbd.h     6.6 92/02/14";*/
/***    VKBD.H
 *
 *      SCCSID = @(#)vkbd.h     6.6 92/02/14
 *
 *      MVDM Virtual Keyboard Exported Definitions
 *
 *      For include file hierarchy, see MVDM.H
 *
 *
 *      MODIFICATION HISTORY
 *      10/11/88        Created.
 */


#ifndef INCL_NONE               // include everything by default
#define INCL_VKBD
#endif

#ifdef  INCL_VKBD
#define INCL_VKBDSYSREQ
#define INCL_VKBDINTERFACES
#endif



#ifdef  INCL_VKBDSYSREQ

/***    VKBD constants
 */

#define VKBD_NAME               "VKBD$"


/***    VKBD constants for PMVDMP                                      //ss0007
 */                                                                    //ss0007
#ifdef  INCL_NLSSHLD                                                   //ss0007
                                                                       //ss0007
#define NIP_PMINPUTMETHOD   0x0000  // Current Input method is of PM   //ss0008
#define NIP_FSINPUTMETHOD   0x0001  // Current Input method is of FS   //ss0008
#define NIP_PS55            0x0000  // PS/55 BIOS : bit 2-1 : 0 0      //ss0008
#define NIP_PS2             0x0002  // PS/2  BIOS :           0 1      //ss0008
                                    // PS/55 GALE :(reserved) 1 0      //ss0008
                                    // Reserved   :           1 1      //ss0008
#endif  //INCL_NLSSHLD                                                 //ss0007

/* VKBD functions for use by PMVDMP
 */
#define VKBDSYSREQ_SETACCESS    1   // Obtain exclusive access for VDM
#define VKBDSYSREQ_SETFOCUS     2   // Notify VDM is gaining/losing focus
#define VKBDSYSREQ_POSTSCAN     3   // Send scan code (typed)
#define VKBDSYSREQ_POSTCHAR     4   // Send character code (pasted)
#define VKBDSYSREQ_MONREGIST    5   // Register Monitor into VKBD               //ss0001
#define VKBDSYSREQ_MONDEREGIST  6   // Deregister Monitor from VKBD             //ss0001
#define VKBDSYSREQ_MONREAD      7   // Read key-stroke                          //ss0001
#define VKBDSYSREQ_MONWRITE     8   // Write key-stroke                         //ss0001
#define VKBDSYSREQ_SETSHIFT     9   // Set Keyboard shift status                //ss0001
#define VKBDSYSREQ_GETSHIFT    10   // Get Keyboard shift status                //ss0001
#define VKBDSYSREQ_REGWVDM     11   // Register PMFEP into VKBD                 //ss0006
#define VKBDSYSREQ_DEREGWVDM   12   // Deregister PMFEP from VKBD               //ss0006
#define VKBDSYSREQ_READWVDM    13   // Read key-stroke                          //ss0006
#define VKBDSYSREQ_WRITEWVDM   14   // Write key-stroke                         //ss0006
#define VKBDSYSREQ_MAX         14                                               //ss0006


/***    VKBD data types
 */

typedef struct keypkt_s {           /* kp (for VKBDSYSREQ_POSTSCAN/CHAR) */
    UCHAR       kp_Scan;            // scan code
    UCHAR       kp_Char;            // translated char
    USHORT      kp_fsState;         // shift states
    USHORT      kp_fsDDFlags;       // translated flags
    USHORT      kp_fsKey;           // key flags
} KEYPKT;
typedef KEYPKT *PKEYPKT;
typedef PKEYPKT *PPKEYPKT;

typedef struct shiftpkt_s {         /* sp (for VKBDSYSREQ_SETFOCUS) */
    USHORT      fSetFocus;          // TRUE to set focus, FALSE to clear focus
    USHORT      fsShift;            // PM shift states during set focus
                                    //   undefined during clear focus
} SHIFTPKT;
typedef SHIFTPKT *PSHIFTPKT;
typedef PSHIFTPKT *PPSHIFTPKT;

#define VKBDEVENT_CREATE        0                                      //ss0001
#define VKBDEVENT_TERM          1                                      //ss0001

#define VKBDEVENT_KEY           2                                      //ss0001
#define VKBDEVENT_SHIFT         3                                      //ss0001
#define VKBDEVENT_DOS_SHIFT     4                                      //ss0002

#define VKBDEVENT_CHG_ENV       5                                      //ss0012

#define VKBD_KKC_DOS            0x0000                                 //ss0012
#define VKBD_KKC_SHARED         0x0001                                 //ss0012

#define VKBD_VDMIMFEP_MODE      0x0000                                 //ss0012
#define VKBD_VDMPMFEP_MODE      0x0002                                 //ss0012

#define VKBD_REG_VDMIMFEP       0x0001                                 //ss0006
#define VKBD_REG_VDMPMFEP       0x0002                                 //ss0006

#define VKBD_US_BIOS_MODE       0x8000                                 //ss0020
#define VKBD_JP_BIOS_DOSV       0x0002    /* 1 means Environment is DOSV */     //ss0020

#define VKBD_ENV_TO_FULLSCREEN  0                                      //ss0012
#define VKBD_ENV_TO_WINDOWED    1                                      //ss0012

typedef struct vkevent_s {          /* ve (for DBCS SystemReq)  */     //ss0001
        USHORT  ve_event_id;                                           //ss0001
        SGID    ve_sgid;                                               //ss0001
        UCHAR   ve_monitor_flag;                                       //ss0001
        UCHAR   ve_r_scancode;                                         //ss0001
        UCHAR   ve_charcode;                                           //ss0001
        UCHAR   ve_scancode;                                           //ss0001
        UCHAR   ve_nlsstate;                                           //ss0001
        UCHAR   ve_nlsshift;                                           //ss0001
        USHORT  ve_shift;                                              //ss0001
        ULONG   ve_timestamp;                                          //ss0001
        USHORT  ve_DDFlags;                                            //ss0001
} VKEVENT;                                                             //ss0001

typedef VKEVENT *PVKEVENT;                                             //ss0001

//ss0010    Property Entry Name
//ss0031 #define DBCS_INPUT_METHOD_LIST  "FS Input Method in Windowed DOS\0PM Input Method in Windowed DOS\0Using DOS KKC Device Driver\0"
#define DBCS_INPUT_METHOD_LIST  "OS2_FS_FEP\0PM_FEP\0DOS_FEP\0"                 //ss0031

//ss0014 Following definitions are moved to PROPNAME.H                          //ss0014
//#define SINGLE_INPUT_METHOD     "FS Input Method in Windowed DOS"             //ss0010
//#define DUAL_INPUT_METHODS      "PM Input Method in Windowed DOS"             //ss0010
//#define DOS_KKC_MODE            "Using DOS KKC Device Driver"                 //ss0010
//ss0010

#endif //INCL_VKBDSYSREQ



/***    VKBD function prototypes
 */

#ifdef INCL_VKBDINTERFACES

typedef (PASCAL *PFNSCRNP)(VOID);

VOID VDHENTRY VDHRegisterScreenProc(PFNSCRNP);
USHORT VDHENTRY VDHQueryKeyShift(HVDM);

// VPL Idle detection services
VOID VDHENTRY VDHWakeIdle(HVDM);
VOID VDHENTRY VDHReportPeek(ULONG);
VOID VDHENTRY VDHNotIdle(VOID);
BOOL * VDHENTRY VDHGetBusyFlagPtr(void);

// requests for SVC access to VPL polling services
#define VPL_NAME "VPL_IDLE"
#define VDHVPL_BUSY_ADDR 0         // provide V86 busy byte address
#define VDHVPL_WAIT      1         // make VDM sleep
#define VDHVPL_NOIDLE    2         // Turn idle detection off
#define VDHVPL_WAKE      3         // Report busy activity

#endif
