/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vgaemu     1.0 92/05/01";*/

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SOURCE FILE NAME:    VGAEMU.H                                       */
/*                                                                      */
/*  DESCRIPTIVE NAME:    Video buffer, font buffer, work variables      */
/*                       definitions for text mode emulation            */
/*                       with VGA graphics mode for VGA version OS/2.   */
/*                                                                      */
/*  COPYRIGHT:           na                                             */
/*                                                                      */
/*  STATUS:              na                                             */
/*                                                                      */
/*  NOTES:               None                                           */
/*                                                                      */
/*  CHANGE HISTORY:                                                     */
/*                      92/05/01    Initial coding (T.Sobue)            */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/

#define MAX_ROWS        26              // maximun row count
#define MAX_COLS        82              // maximun column count
#define CELL_SIZE       4               // cell size (char/attr0/attr1/attr2)

#define FONT_HEIGHT     18              // font height
#define FONT_HEIGHT2    19              // font height in font file
#define FONT_HEIGHT2    19              // font height
#define MAX_SBCS_FONT   256             // number of SBCS character font

#define MAX_PLANE       4               // max APA plane
#define MAX_SAVE_CHAR   2               // max save char count for text cursor

typedef struct {
    USHORT CodePage;                                        // code page
    USHORT FontType0;                                       // font type 0
    USHORT FontType1;                                       // font type 1
    USHORT FontID;                                          // font ID
} SBCS_FONT_TYPE;

struct VGASBCSFont {
    SBCS_FONT_TYPE FontType;                                // font attr
    UCHAR          FontImage[MAX_SBCS_FONT * FONT_HEIGHT2]; // font image
};

struct VGATextEmulationBuffer {
    UCHAR  shadow[MAX_ROWS][MAX_COLS][CELL_SIZE];           // text video buffer
    ULONG  APAStart;                                        // APA start address
    USHORT GridColor;                                       // grid draw color
    USHORT CsrRow;                                          // cursor row position
    USHORT CsrCol;                                          // cursor column position
    USHORT CsrStart;                                        // cursor start line
    USHORT CsrEnd;                                          // cursor end line
    USHORT CsrWidth;                                        // cursor width
    USHORT CsrAttrib;                                       // cursor attribute
    USHORT CsrColor;                                        // cursor color
    USHORT CsrScrWidth;                                     // screen width for cursor draw
    USHORT SaveFlag;                                        // character save flag
    UCHAR  SaveChar[MAX_SAVE_CHAR][MAX_PLANE][FONT_HEIGHT]; // character save area
    struct VGASBCSFont BaseFont;                            // base SBCS font
    struct VGASBCSFont ExtensionFont;                       // extension SBCS font
};
