/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)vfntv.h    6.0 91/07/08";*/
/***    Virtual Font External Definitions
 *
 *      SCCSID = @(#)vfntv.h    6.0 91/07/08
 *
 *
 *
 *
 *      DESCRIPTION
 *      VFNTV externally defined constants, types, and function prototypes
 *
 *      MODIFICATION HISTORY
 *      07/08/91    J-TS00  Created.
 *      07/12/93    J-TS288 DCR 288.1 JIS'90 support
 *      08/05/93    J-TS269 DCT 269 VTEXT support
 */

// Font size definition

#define DBCS24_FONT_SIZE                72
#define DBCS16_FONT_SIZE                32
#define SBCS16_FONT_SIZE                16
#define SBCS19_FONT_SIZE                19


// VDD name definition

#define VFNTV_NAME                      "VFNTV$"


// Interface definition between VDD-VDD

#define VFSYSREQ_GET_ENTRY              0

#define VFNTV_FUNC_ENTRY_COUNT          7

#define VFNTV_FUNC_GET_SBCS16_BUF       0
#define VFNTV_FUNC_GET_DBCS16_FONT      1
#define VFNTV_FUNC_GET_DBCS24_FONT      2


// Mapped font definition                                           //J-TS288
                                                                    //J-TS288
typedef struct {                                                    //J-TS288
    USHORT IntCode;                         // Internal PC code     //J-TS288
    UCHAR  FontImage[DBCS16_FONT_SIZE];     // font image           //J-TS288
} MAPPED_FONT;                                                      //J-TS288


//  Interface definition between VDD-Protect mode process

                    // acknowledgement definition from monitor to VDD
#define VFNT_ACK_WAIT_EVENT             0
#define VFNT_ACK_GIVE_ALL_FONT          1
#define VFNT_ACK_GIVE_ONE_FONT          2
#define VFNT_ACK_FREE_ALL_FONT          3                           //J-TS269

                    // request definition from VDD to monitor
#define VFNT_EVENT_ALL_FONT             0
#define VFNT_EVENT_ONE_FONT             1
#define VFNT_EVENT_FREE_ALL_FONT        2

// event parameter definition

typedef struct {                                // VFNT_EVENT_ONE_FONT parameter
    USHORT row;
    USHORT col;
    USHORT code;
} REQ_ONE_FONT;

typedef struct {                // VFNT_EVENT_ALL_FONT param        //J-TS269
    USHORT size;                                                    //J-TS269
} REQ_ALL_FONT;                                                     //J-TS269

typedef struct {                // VFNT_EVENT_FREE_ALL_FONT param   //J-TS269
    USHORT size;                                                    //J-TS269
} REQ_FREE_FONT;                                                    //J-TS269

typedef struct {                                // universal event definition
    USHORT request;
    union {
        REQ_ONE_FONT  OneFont;
        REQ_ALL_FONT  AllFont;                                      //J-TS269
        REQ_FREE_FONT FreeFont;                                     //J-TS269
    } param;
} VFNT_EVENT;

// acknowledgement definition

typedef struct {                                // VFNT_ACK_GIVE_ALL_FONT parameter
    ULONG   SBCSFont;
    ULONG   DBCSIndex;
    ULONG   DBCSExistFlag;
    ULONG   DBCSSel;
    USHORT  SegCnt;
    USHORT  SegSize;
    USHORT  LastSize;
    UCHAR   DBCSVector[4];
    UCHAR   DBCSUser[2];
    USHORT  RomFontExist;
    ULONG   RomFontWindow;
    ULONG   RomDBCSTable;
    ULONG   MapFileBuf;                                             //J-TS288
    USHORT  MapFileSize;                                            //J-TS288
    USHORT  MapFontCnt;                                             //J-TS288
    USHORT  FontSize;                                               //J-TS269
} ALL_FONT;

typedef struct {                                // VFNT_ACK_GIVE_ONE_FONT parameter
    UCHAR  FontImage[DBCS24_FONT_SIZE];
} ONE_FONT;

typedef struct {                                // universal acknowledgement definition
    USHORT RetCode;
    union {
        ONE_FONT OneFont;
        ALL_FONT AllFont;
    } param;
} VFNT_ACK;
