/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*
 *      VBIOS Virtual Device Driver definitions
 *                                              08/08/90    Y.Funaki
 */

// VFNT.SYS registered name
#define VFNT_NAME "VFNT$"
#define SG_3XBOX  2
#define NUMRAMREGEN 1536

// VFNT.SYS internal prottypes
BOOL    HOOKENTRY VFNTCreateVDM(HVDM);
BOOL    HOOKENTRY VFNTSetFgnd(HVDM);
BOOL    HOOKENTRY VFNTSetBgnd(HVDM);
BOOL    HOOKENTRY VFNTTerminateVDM(HVDM);
BOOL    HOOKENTRY VFNTIntEntry(PCRF);
VOID    HOOKENTRY saveLFB(HVDM);                                      //J-YF126
VOID    HOOKENTRY restoreLFB(HVDM,PCRF);                              //J-YF126
LONG    EXPENTRY  VFNTSysEntry(SGID, ULONG, ULONG, PVOID, ULONG, PVOID);
LONG    EXPENTRY  VFNTDevEntry(HVDM, ULONG, PVOID, PVOID);
BOOL    PRIVENTRY VFNTSetStub(VOID);
BOOL    PRIVENTRY getcpi(VOID);
BOOL    PRIVENTRY getmap(VOID);
BOOL    PRIVENTRY getatlasslot(VOID);                                 //J-YF117
WORD    PRIVENTRY inttoromregen(WORD);
WORD    PRIVENTRY inttoseq(WORD);
WORD    PRIVENTRY seqtoromregen(WORD);
BOOL    PRIVENTRY processmap(WORD);
BOOL    PRIVENTRY getgdt(VOID);
BOOL    PRIVENTRY getsdata(VOID);
WORD    PRIVENTRY scanregint(WORD);
//J-YF315BOOL    PRIVENTRY allocLFB(VOID);                                     //J-YF126
BOOL    PRIVENTRY allocLFB(HVDM);                                     //J-YF315
BOOL    PRIVENTRY freeLFB(VOID);                                      //J-YF126
BOOL    PRIVENTRY allocLFBX(VOID);                                    //J-YF307
BOOL    PRIVENTRY freeLFBX(VOID);                                     //J-YF307

WORD    EXPENTRY  IntToRegen(VOID);                                   //J-YF300
WORD    EXPENTRY  RegenToInt(VOID);                                   //J-YF300
WORD    EXPENTRY  GetImage(VOID);                                     //J-YF300
WORD    EXPENTRY  PurgeFont(VOID);                                    //J-YF300

/*** VFNTUsrEntry - VFNT user entry point
 *
 *  This routine is called by VVIDEO, VLPT and VFNTIntEntry.
 *
 *  input   : func    - function codes
 *            code    - internal/regen code
 *            option  - options for getimege
 *            pbuffer - pointer to output buffer
 *            (please refer "VFNT.H")
 *  output  : success - 0
 *            failure - error code from FNTCALLS.DLL
 *  effect  : contents of the output buffer
 *  context : VDM Task-time
 */
// prottype
WORD    EXPENTRY  VFNTUsrEntry(HVDM, WORD, WORD, WORD, PBYTE);         //J-YF130
typedef WORD (EXPENTRY *PVFNTUSRENTRY)(HVDM, WORD, WORD, WORD, PBYTE); //J-YF130
// function codes
#define VFNT_CMD_INTTOREGEN     0x01
#define VFNT_CMD_REGENTOINT     0x02
#define VFNT_CMD_GETIMAGE       0x03
#define VFNT_CMD_PURGEFONT      0x04
#define VFNT_CMD_SETMODE        0x05
#define   MODE_ET       0x0000            //epoch text mode           //J-YF305
#define   MODE_EG       0x0001            //epoch graphic mode        //J-YF305
#define   MODE_AT       0x0002            //atlas text mode           //J-YF305
#define   MODE_AG       0x0003            //atlas graphic mode        //J-YF305
#define   MODE_VGA      0x8000            //VGA mode                  //J-YF305
#define   MODE_UNKNOWN  0xFFFF            //mode unknown              //J-YF305
#define VFNT_CMD_CHGSG          0x06
#define VFNT_CMD_VDMHLP         0x07
#define   VFNT_SUBCMD_GETCPI       0x01
#define   VFNT_SUBCMD_GETMAPLEN    0x02
#define   VFNT_SUBCMD_GETMAPDATA   0x03
#define   VFNT_SUBCMD_GETGDTSEL    0x04
//J-YF117#define   VFNT_SUBCMD_GETDSPTYPE  0x05
#define   VFNT_SUBCMD_GETATLASSLOT 0x05                               //J-YF117
#define   VFNT_SUBCMD_GETSDATA     0x06
#define   VFNT_SUBCMD_GETHANKAKU   0x07                               //J-YF315
#define VFNT_CMD_QUERYRC        0x08                                  //J-YF308
#define VFNT_CMD_RESTORE        0x09                                  //j-ys0702
#define VFNT_CMD_GETUSRENTRY    0xFF
// options for getimage
#define FULLBOX     0x80
#define PUTFONT     0x40
#define EXTHANKAKU  0x01
//c-begin
// VFSTUB
BOOL    PRIVENTRY VFStubStart(VOID);    // head of stub
BOOL    PRIVENTRY VFStubEnd(VOID);      // tail of stub
#define VFSTUBSIZE  ((ULONG)VFStubEnd - (ULONG)VFStubStart)
//c-begin
