/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************** Module Header ******************************\
*
* Module Name: PMWP.H
*
* OS/2 Presentation Manager Workplace include file.
*
*
* ===========================================================================
*
* The folowing symbols are used in this file for conditional sections.
*
*   #define:                To include:
*
*   INCL_WINWORKPLACE       All of Workplace Shell
*   INCL_WPCLASS            Workplace object class API's
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
#ifndef __IBMC__
   * The public version of this file (as shipped with the OS/2 Toolkit
   * product) excludes all non 32-bit material marked in this file
   * as well as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
\***************************************************************************/

#ifdef __IBMC__
   #pragma checkout( suspend )
      #ifndef __CHKHDR__
         #pragma checkout( suspend )
      #endif
   #pragma checkout( resume )
#endif

/* NOINC */
#ifndef PMWP_INCLUDED  /* multiple include protection */
   /* INC */
   #define PMWP_INCLUDED

#ifndef __IBMC__
   /* TEMP HACK, should be INCL_WINWORKPLACE for both IBM and MS */
   /* but I don't want to risk breaking anyone yet! David Kerr */
   #if (defined(INCL_WP) || defined(INCL_WINWORKPLACE))
      #define INCL_WPCLASS
   #endif
#else
   #ifdef INCL_WINWORKPLACE
      #define INCL_WPCLASS
   #endif
#endif

   /*** Common types *******************************************************/

   typedef LHANDLE HOBJECT;

   /*** Object management calls ********************************************/
   #if (defined(INCL_WPCLASS) || !defined(INCL_NOCOMMON))
      /*** Standard object classes *****************************************/


      #define CCHMAXCLASS              3      /* Length of a classname     */

      #define QC_First                 0      /* Codes for OA_QueryContent */
      #define QC_Next                  1
      #define QC_Last                  2
      #define QC_FIRST              QC_First
      #define QC_NEXT               QC_Next
      #define QC_LAST               QC_Last

      /*** An object's appearance (icon or bitmap or outline) **************/

      typedef struct _OBJECTIMAGE {   /* oimg */
         HPOINTER hptrObject;
      } OBJECTIMAGE;
      typedef OBJECTIMAGE FAR * POBJECTIMAGE;

      /*** Class info structure returned by WinEnumObjectClasses ***********/
      typedef struct _OBJCLASS {       /* ocls */
         struct _OBJCLASS *pNext;         /* Null for the last structure.. */
         PSZ               pszClassName;  /* Class name                    */
         PSZ               pszModName;    /* Module name                   */
      } OBJCLASS;
      typedef OBJCLASS FAR *POBJCLASS;


      /*** Workplace object management functions ***************************/

      BOOL APIENTRY WinRegisterObjectClass(PSZ pszClassName,
                                           PSZ pszModName);

      BOOL APIENTRY WinDeregisterObjectClass(PSZ pszClassName);

      BOOL APIENTRY WinReplaceObjectClass(PSZ pszOldClassName,
                                          PSZ pszNewClassName,
                                          BOOL fReplace);

      BOOL APIENTRY WinEnumObjectClasses(POBJCLASS pObjClass,
                                         PULONG pulSize);

      HOBJECT APIENTRY WinCreateObject(PSZ pszClassName,
                                       PSZ pszTitle,
                                       PSZ pszSetupString,
                                       PSZ pszLocation,
                                       ULONG ulFlags );
      #define CO_FAILIFEXISTS     0
      #define CO_REPLACEIFEXISTS  1
      #define CO_UPDATEIFEXISTS   2

      BOOL APIENTRY WinSetObjectData(HOBJECT hObject,
                                     PSZ pszSetupString);

      BOOL APIENTRY WinDestroyObject(HOBJECT hObject);

      HOBJECT APIENTRY WinQueryObject(PSZ pszObjectID);

   #endif  /*WPCLASS*/

   /*** Error codes ********************************************************/
   #define INCL_WPERRORS
   #include <pmerr.h>

   /*** Object settings notebook page insertion structure ******************/

   typedef struct _PAGEINFO {   /* pginf */
      ULONG   cb;
      HWND    hwndPage;
      PFNWP   pfnwp;
      ULONG   resid;
      PVOID   pCreateParams;
      USHORT  dlgid;
      USHORT  usPageStyleFlags;
      USHORT  usPageInsertFlags;
      USHORT  usSettingsFlags;
      PSZ     pszName;
      USHORT  idDefaultHelpPanel;
      USHORT  usReserved2;
      PSZ     pszHelpLibraryName;
      PUSHORT pHelpSubtable;   /* PHELPSUBTABLE when PMHELP.H is included*/
      HMODULE hmodHelpSubtable;
      ULONG   ulPageInsertId;
   } PAGEINFO;
   typedef PAGEINFO FAR *PPAGEINFO;

   #define  SETTINGS_PAGE_NUMBERS     0x01

   /*** Utility apis +******************************************************/

   #if (!defined(INCL_NOCOMMON))
      typedef struct _ICONPOS {   /* icp */
         POINTL  ptlIcon;                    /* Location */
         CHAR    szIdentity[1];              /* Object identity string */
      } ICONPOS;
      typedef ICONPOS FAR * PICONPOS;

      /*********************************************************************/
      #ifdef INCL_WINPOINTERS
         BOOL APIENTRY WinSetFileIcon(PSZ pszFileName,
                                      PICONINFO pIcnInfo);
      #endif
      BOOL APIENTRY WinFreeFileIcon(HPOINTER hptr);

      HPOINTER APIENTRY WinLoadFileIcon(PSZ pszFileName,
                                        BOOL fPrivate);

      BOOL APIENTRY WinStoreWindowPos(PSZ pszAppName,
                                      PSZ pszKeyName,
                                      HWND hwnd);

      BOOL APIENTRY WinRestoreWindowPos(PSZ pszAppName,
                                        PSZ pszKeyName,
                                        HWND hwnd);

      BOOL APIENTRY WinShutdownSystem(HAB hab,
                                      HMQ hmq);
   #endif
#ifndef __IBMC__
   /* TEMP HACK, this is private, needs moving to private header - David Kerr */
   /*** Picked up from PMSHLTKT.H ******************************************/
   #define    DOTICON             ".ICON"
   #define    ICONGEALENGTH       7

   #define WM_QUERYOBJECTPTR    0x0407
   #define WM_SETOBJECTPTR      0x0408

   ULONG  APIENTRY MRILoadResource (HWND hwndOwner,
                                    PHMODULE pulModHandle,
                                    PSZ pszModuleName,
                                    PSZ pszAppName);

   VOID APIENTRY WinStartShell(HAB hab,
                               HMQ hmq);

   BOOL APIENTRY WinRestartWorkplace(VOID);

   #define UNREFERENCED( c ) c;

#endif

   /* NOINC */
#endif /* PMWP_INCLUDED */
/* INC */

#ifdef __IBMC__
   #pragma checkout( suspend )
      #ifndef __CHKHDR__
         #pragma checkout( resume )
      #endif
   #pragma checkout( resume )
#endif

/**************************** end of file **********************************/
