/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/***************************************************************************\
*
* Module Name: OS2NLSP.H
*
* OS/2 Presentation Manager DBCS Stuff include file ( Private )
*
*
* 18-Dec-91 Naoto Satoh  Cleaned up along with OS2NLS.H  JS02448/JP20
* 02-Dec-92 NSu          Merge OEM code   DCR253/JC20       J-@OEM@NSu
*
\***************************************************************************/

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
      #ifdef M_I386
         #define INCL_32 /* Compiling for 32-bit */
      #else
         #define INCL_16 /* Compiling for 16-bit */
      #endif
   #endif
#endif

/* KC_ flags definition of WM_CHAR */

#define KC_DBE_INTERIMCHAR      KC_DBCSRSRVD2


/* definition of Keyboard Type for DBCS */
#define KB_JATYPE               0x05
#define KB_JGTYPE               0x06
#define KB_PHUKET1              0x07  /*  Phuket w/  10 key pad  */
#define KB_PHUKET2              0x08  /*  Phuket w/o 10 key pad  */
#define KB_AX                   0x09                                /*J-@OEM@NSu*/
#define KB_J3100                0x0A    /* TOSHIBA */               /*J-@OEM@NSu*/
#define KB_US101                0x0B    /* US101   */

/* definition of National Language Keyboard ID for DBCS */

/* Japan translation tables */
#define LG_JALPHANUMERIC        0x50
#define LG_JKATAKANA            0x51
#define LG_JKATAKANAROMAN       0x52
#define LG_JHIRAGANA            0x53
#define LG_JHIRAGANAROMAN       0x54
#define LG_JCAPSALPHANUMERIC    0x55

/* Korea translation tables  */
#define LG_KALPHANUMERIC        0x56
#define LG_KJAMO                0x57

/* PRC    translation tables */
#define LG_SALPHANUMERIC        0x58

/* Taiwan translation tables */
#define LG_TALPHANUMERIC        0x59


/* resource ID offset for bi-lingual system resources */
#define STR_DBE_OFFSET          0x1000

ULONG APIENTRY WinDBCSStdWindowNotify( HAB, HWND, USHORT );

ULONG APIENTRY WinDBCSSSCMsgNotify( HAB, HWND, USHORT, MPARAM, MPARAM );

PSZ FAR PASCAL WinDBCSAllocMem( USHORT );

BOOL FAR PASCAL WinDBCSFreeMem( PSZ );

BOOL FAR PASCAL WinDBCSIsCodepageSupported( USHORT );

USHORT FAR PASCAL WinDBCSGetStatusString( HWND, USHORT, USHORT, PSZ, USHORT );

HWND FAR PASCAL WinDBCSQueryFrame( HWND );

/* WM_SETWINDOWPARAM ctldata of KKPopup control*/
typedef struct _KKPOPUPDATA {   /* kkpopupdata */
    USHORT      flag;
    USHORT      textlength;
    PSZ         lpTextString;
    PSZ         lpAttrString;
    HWND        hwndTarget;
    PRECTL      lprcCursorPos;
    USHORT      textCursorPos;
    USHORT      textCursorAttr;
    PVOID       lpAttrTbl;
} KKPOPUPDATA;
typedef KKPOPUPDATA FAR * PKKPOPUPDATA;


/* flag definition of KKPOPUPDATA */
#define DBE_PWF_ENTRYF          0x0001
#define DBE_PWF_CLIENT          0x0002
#define DBE_PWF_SPLIT           0x0004
#define DBE_PWF_NODRAW          0x0008
#define DBE_PWF_TYPEMASK        0x000f

#define DBE_PWF_VERTICALOTS     0x4000
#define DBE_PWF_SHIELD          0x8000


/* the notifycode of the Kanakan Pop-up Control's WM_CONTROL */
#define DBE_KN_DESTROY          1


/* DBCS unique internal Vkey     */
#define VK_DBE_POSTEDROMAN      0x9f   //@ IBMJ JS06039   Generated from WinDBCSModeControl,
                                       //@ IBMJ           it will be replaced with VK_DBE_ROMAN
                                       //@ IBMJ           in INPUTHOOK

/* DBCS unique internal messages */
//#define WM_DBE_CHAR             0x00b1
//#define WM_DBE_KKCCHAR          0x00b2
//#define WM_DBE_KKNOTIFY         0x00b3
//#define WM_DBE_KKEREGISTER      0x00b4
//#define WM_DBE_FOCUSCHANGE      0x00b5
//#define WM_DBE_SETAPPLSTAT      0x00b6  // in OS2NLS.H
#define WM_QUERY_PLAYBACK       0x00b7
//#define WM_QUERYCURRENTFONT     0x00b8
#define WM_DBE_QUERYFLCREATE    0x00ba
#define WM_DBE_SHLDNOTIFYSETCP  0x00bb
//#define WM_DBE_KKCPARAMS        0x00bc  // in OS2NLS.H
//#define WM_DBE_MODECONTROL      0x00be
//#define WM_DBE_KKCREGISTER      0x00bf
#define WM_DBE_IMFEPCOMMAND     0x00c0
//#define WM_DBE_FDLOADING        0x00c1
#define WM_DBE_PECIC_UPDATE     0x00cd   /* for STS use -  P0302(ST11) */
#define WM_DBE_PECIC_RESERVED   0x00ce
#define WM_DBE_NOTIFYSETCP      0x00cf



/* Code Page definition */
#define CP_UNITED               437
#define CP_JAPANMIXED           932
#define CP_JAPANMIXEDSAA        942
#define CP_JAPANSBCS            897
#define CP_JAPANSBCSSAA        1041
#define CP_JAPANDBCS            301
#define CP_MULTILINGUAL         850
#define CP_DESKTOPPUBLISHING   1004                                 /*J-@OEM@NSu*/
#define CP_KOREAMIXED           934
#define CP_KOREASBCS            891
#define CP_KOREADBCS            926
#define CP_KOREAMIXEDSAA        944
#define CP_KOREASBCSSAA        1040
#define CP_TCHINMIXED           938
#define CP_TCHINSBCS            904
#define CP_TCHINDBCS            927
#define CP_TCHINMIXEDSAA        948
#define CP_TCHINSBCSSAA        1043


/* DBCS countries reserved Universal Glyphs Range */
#define UGL_DBCSFIRST           0x0300
#define UGL_DBCSLAST            0x03ff


/* Font Driver internal functions */
BOOL    APIENTRY SSCLoadPublicFD( ULONG, PSZ );
BOOL    APIENTRY NLSLoadPublicFD( HAB, PSZ );
BOOL    APIENTRY NLSUnloadPublicFD( HAB, PSZ );
BOOL    APIENTRY WinDBCSLoadPublicFD( HAB, PSZ );
BOOL    APIENTRY WinDBCSUnloadPublicFD( HAB, PSZ );


/* Font Driver Loading Definition */
#define DBE_LOAD_FD             0x0001
#define DBE_UNLOAD_FD           0x0002


/* IM Control Panel internal functions */
INT FAR PASCAL IMCplChangeCurIME( PSZ, HWND, USHORT );


/* return code of IMCplChangeCurIME */
#define IMCPL_CHANGED           0
#define IMCPL_NOT_CHANGED       1
#define IMCPL_SETUP             2
#define IMCPL_WORDREGISTER      3
#define IMCPL_ALREADYUSED       4


/* definition of cmd of WM_DBE_IMFEPCOMMAND */
#define DBE_IMFEP_IMEDIALOG     1
#define DBE_IMFEP_QUERY         2
#define DBE_IMFEP_SET           3
#define DBE_IMFEP_DBCSMODE      4
#define DBE_IMFEP_SYSCOMMAND    5
#define DBE_IMFEP_KKCCHAR       6
#define DBE_IMFEP_QUERYPARENT   7
#define DBE_IMFEP_UPDATEIME     8
#define DBE_IMFEP_UPDATEFRAME   9


/* WM_DBE_IMFEPCOMMAND structure for DBE_IMFEP_IMEDIALOG */
typedef struct _IMFEPPARAM {    /* imfepparam */
    HWND        hwndFrame;
    PVOID       pParam;
} IMFEPPARAM;
typedef IMFEPPARAM FAR * PIMFEPPARAM;

/* WM_DBE_IMFEPCOMMAND structure for generic use */
typedef struct _IMFEPCMD {    /* imfepcmd */
    PVOID       pParam1;
    PVOID       pParam2;
} IMFEPCMD;
typedef IMFEPCMD FAR * PIMFEPCMD;


/* SSC thread control block offset in KbdStat window control block    @APPX */
#define EXTRA_SSCTCB             8


/* WM_QUERYCONVERTPOS return value */
#define QCP_VERTICAL            0x0002
#define QCP_SHIELD              0x8000

#define WM_PECIC_NOTIFY    WM_DBE_PECIC_RESERVED
#define WPN_MAYUPDATE           0x0001
#define WPN_HIDE                0x0002
#define WPN_QUERYFRAMEFLAG      0x0003


/* internal value for WinDBCSModeControl */
#define DBE_MCTL_STSDISABLE     0x8000

/* internal value for WinDBCSIMEControl */
#define DBE_IMCTL_EXECKKFEP     0x8000

#define DBE_FD_VERSION_3        1300

/* definition of NlsQueryCpInfo() */
#define NLSCPINFO_SBCS      0x0001        /*     Pure SBCS     */
#define NLSCPINFO_DBCS      0x0002        /*     Pure DBCS     */
#define NLSCPINFO_MBCS_ENV  0x0004        /* Environment MBCS  */
#define NLSCPINFO_MBCS_SOSI 0x0008        /* Shift In/Out MBCS */

typedef struct _NLSCPINFO {   /* nlscpinfo */
        USHORT fType;         /* type of codpage */
        USHORT usCc;          /* country code */
        USHORT usSbCp;        /* codepage of SBCS char set */
        USHORT usDbCp;        /* codepage of DBCS char set */
        USHORT usMdCp;        /* codepage of MBCS char set */
        USHORT usTrCp;        /* codepage for TransDt()    */
} NLSCPINFO;
typedef NLSCPINFO FAR *LPNLSCPINFO;

/** PMNLS Entry table **  DCR110/JP13 **/

/* NlsInit */
typedef BOOL (FAR PASCAL *PNLSI)( VOID );

/* NlsDrawText */
typedef BOOL (FAR PASCAL *PNLSDT)( USHORT, HPS, PSZ, USHORT, PRECTL, USHORT, PULONG );

/* NlsFindWord */
typedef BOOL (FAR PASCAL *PNLSFW)(USHORT, PSZ, ULONG, ULONG, PULONG, PULONG, PULONG);

/* NlsPmcplEntry */
typedef ULONG (FAR PASCAL *PNLSPE)( USHORT, USHORT, ULONG );

/* NlsSetHook */
typedef BOOL (FAR PASCAL *PNLSSH)( HAB, HMQ, SHORT, PFN, HMODULE );

/* NlsSetKeyboardStateTable */
typedef BOOL (FAR PASCAL *PNLSSKST)( HWND, PUCHAR, BOOL );

/* NlsLoadPublicFD */
typedef BOOL (APIENTRY *PNLSLPFD)( HAB, PSZ );

/* NlsUnloadPublicFD */
typedef BOOL (APIENTRY *PNLSUPFD)( HAB, PSZ );

/* NlsQueryCpInfo */
typedef LPNLSCPINFO (APIENTRY *PNLSQCI)( HAB, USHORT );

/* NlsCpTranslateString */
typedef BOOL  (FAR PASCAL *PNLSCTS)( HAB, USHORT, PSZ, USHORT, USHORT, PSZ );

/* NlsQueryCodePgaeInfo */
typedef BOOL  (FAR PASCAL *PNLSQCPI)( USHORT, USHORT, LPNLSCPINFO );

/* NlsQueryFontIndex */
typedef USHORT (FAR PASCAL *PNLSQFI)( USHORT, USHORT, PSZ );

/* NlsQueryCodepoint */
typedef USHORT (FAR PASCAL *PNLSQC)( USHORT, USHORT, PSZ );

typedef struct _NLSENTRY { /* NlsEntry */
   PNLSI    NlsInit;
   PNLSCTS  NlsCpTranslateString;
   PNLSDT   NlsDrawText;
   PNLSSH   NlsSetHook;
   PNLSQCI  NlsQueryCpInfo;
   PNLSPE   NlsPmcplEntry;
   PNLSLPFD NLSLoadPublicFD;
   PNLSUPFD NLSUnloadPublicFD;
   PNLSFW   NlsFindWord;
   PNLSSKST NlsSetKeyboardStateTable;
   PNLSQCPI NlsQueryCodePageInfo;
   PNLSQFI  NlsQueryFontIndex;
   PNLSQC   NlsQueryCodepoint;
} NLSENTRY;
typedef NLSENTRY FAR *PNLSENTRY;

/* Sts exported entry */
BOOL EXPENTRY StsCheckDesktopSts( HWND, BOOL );

/* Fep exported entry */
MRESULT FAR PASCAL FepWndProc( HWND, USHORT, MPARAM, MPARAM );
BOOL   EXPENTRY FepDispPanel( HWND, USHORT );
BOOL   EXPENTRY FepQueryStatus( HWND, USHORT );
BOOL   APIENTRY FepSetupDefaultIME( HWND, PSZ );
BOOL   APIENTRY Fep32SetupDefaultIME( HWND, PSZ );
USHORT FAR  PASCAL AlxInOut( PVOID, PQMSG );
BOOL   EXPENTRY FepQueryNewIF( HWND );

#define ALX_RC_EAT           0                  /* ROMAJI - ON_THE_WAY */
#define ALX_RC_GIVE_NEXT     1                /* ROMAJI - RQST_NXT_CHR */
#define ALX_RC_GIVE          2                /* ROMAJI - ON_THE_BEGIN */

/* return code for FepWndProc */
#define FEP_RC_EATEN    1
#define FEP_RC_IGNORED  2

/* internal value for FepDispPanel */
#define PANID_NONE              0x0000
#define PANID_IMCPL             0x0001
#define PANID_TANGO             0x0002
#define PANID_HOMONYM           0x0004
#define PANID_SETUP             0x0008
#define PANID_ALREADY_EXIST     0x0010
#define PANID_SETUP_INUSE       0x0020
#define PANID_HOMONYM_INUSE     0x0040
#define PANID_TANGO_INUSE       0x0080

/* flag value for FepQueryStatus */
#define FQS_DISPLAYBUFFER_EXIST 0x0001

/* Ssc exported entry */
BOOL FAR PASCAL SscInsertSysMenuItem( HAB, HWND, BOOL );
ULONG FAR PASCAL SscModeControl( HAB, HWND, USHORT, USHORT, PUSHORT, BOOL );
USHORT EXPENTRY SscQuerySGID( VOID );
USHORT EXPENTRY SscSetVDMInfo( SGID );
BOOL EXPENTRY SscQueryDlgStat( USHORT );
BOOL EXPENTRY SscChangeDlgStat( HWND, USHORT, USHORT );
BOOL EXPENTRY SscIsWindowList( HWND );                   //@ JS04389
BOOL EXPENTRY SscQueryInstIME( VOID );                   //@ JS04150

#ifdef KBD_UD                                                       /*J-@OEM@NSu*/

/** Keyboard Unique Data **/

typedef struct   _KBDUNIQDATA  {  /* kbduniqdata */
    ULONG         ulKey;                /* key word for this structure      */
    ULONG         cbSize;               /* size of this structure in bytes  */
    ULONG         ulKBDid;              /* keyboard id                      */
    ULONG         ulChar1;              /* keyboard character field 1       */
} KBDUNIQDATA;
typedef KBDUNIQDATA   FAR * PKBDUNIQDATA;

#define KEY_KBDUNIQDATA         0x554B  /* KU */

/* bit definition of character field 1 */
#define KBDU_C1_INITNUMLOCK     0x00000001  /* initial numlock state is on   */
#define KBDU_C1_KANALED         0x00000002  /* There is katakana LED         */
#define KBDU_C1_KANALED_J3100   0x00000004  /* There is katakana LED (J3100) */
#define KBDU_C1_SET_CODEPAGE    0x00000008  /* set codepage to physical kbd  */


PKBDUNIQDATA APIENTRY SSCGetKBDUniqData( VOID );

#endif /*KBD_UD*/                                                   /*J-@OEM@NSu*/


/* OS2.INI string name */
#define  KKC_APPNAME                 "PMNLSKKC"
#define  KKC_KEYNAME_DEFINPMODE      "DefaultInputMode" //DCR187/JP20
#define  KKC_KEYNAME_SINGLEKKC       "SingleKKC"

#ifdef INCL_16

typedef struct _KEYSTSDATA32 {        /* keysts32 */
    ULONG       wpmctlflag;
    ULONG       textlength;
    PSZ         pTextString;
    PSZ         pAttrString;
    PSZ         pRomanString;
} KEYSTSDATA32;

typedef struct _WPMCTLPARAMS32 {      /* wpmctlprm32 */
    ULONG       wpmctlflag;
    ULONG       textlength;
    PSZ         pTextString;
    PSZ         pAttrString;
} WPMCTLPARAMS32;

typedef struct _PECICDATA32 {      /* pecicdata32 */
    ULONG       wpmctlflag;
    ULONG       textlength;
    PSZ         pTextString;
    PSZ         pAttrString;
    ULONG       CursorPos;
    ULONG       CursorAttr;
} PECICDATA32;

#else

typedef struct _KEYSTSDATA16 {        /* keysts16 */
    USHORT      wpmctlflag;
    USHORT      textlength;
    PSZ         lpTextString;
    PSZ         lpAttrString;
    PSZ         lpRomanString;
} KEYSTSDATA16;

typedef struct _WPMCTLPARAMS16 {      /* wpmctlprm16 */
    USHORT      wpmctlflag;
    USHORT      textlength;
    PSZ         lpTextString;
    PSZ         lpAttrString;
} WPMCTLPARAMS16;

typedef struct _PECICDATA16 {      /* pecicdata16 */
    USHORT      wpmctlflag;
    USHORT      textlength;
    PSZ         lpTextString;
    PSZ         lpAttrString;
    USHORT      CursorPos;
    USHORT      CursorAttr;
} PECICDATA16;

#endif

